/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.RunnableTrackThread;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.Win32EventLogNotification;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.FileWatcherThread;
import org.hyperic.sigar.win32.EventLog;
import org.hyperic.sigar.win32.EventLogNotification;
import org.hyperic.sigar.win32.EventLogThread;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigSchema;

public abstract class TrackEventPluginManager
extends PluginManager {
    public static final int DEFAULT_INTERVAL = 60000;
    public static final String PROP_INTERVAL = "track.interval";
    private static final String[][] GENERIC_HELP = new String[][]{{"log_track.enable", "Check to enable log tracking."}, {"log_track.level", "Only track events of level greater than or equal to this level.  Order is: " + Arrays.asList(LogTrackPlugin.LOGLEVEL_LABELS)}, {"log_track.include", "Include messages that match the given regular expression.  The given pattern can be a substring to look for in log messages or a regular expression.  See: <a href=\"http://java.sun.com/j2se/1.4.2/docs/api/java/util/regex/Pattern.html\">java.util.regex.Pattern</a>."}, {"log_track.exclude", "Exclude messages that match the given regular expression.  "}, {"log_track.files", "Comma delimited list of log files to track. Relative files are resolved to ${installpath}."}, {"platform.log_track.eventlogs", "Comma delimited list of Event Log names to track. Value of <b>*</b> will track all existing Event Logs."}};
    private long fileWatchInterval = 0L;
    private long eventLogInterval = 0L;
    private long runnableTrackInterval = 0L;
    private HashMap eventLogs = new HashMap();
    private FileWatcherThread fileWatcherThread = null;
    private RunnableTrackThread runnableTrackThread = null;
    private LinkedList events = new LinkedList();

    public TrackEventPluginManager() {
    }

    public TrackEventPluginManager(Properties props) {
        super(props);
    }

    @Override
    public abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportEvent(TrackEvent event) {
        LinkedList linkedList = this.events;
        synchronized (linkedList) {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getEvents() {
        LinkedList eventsToReport;
        if (this.events.isEmpty()) {
            return new LinkedList();
        }
        LinkedList linkedList = this.events;
        synchronized (linkedList) {
            eventsToReport = (LinkedList)this.events.clone();
            this.events.clear();
        }
        return eventsToReport;
    }

    private long getInterval(PluginManager manager, String source) {
        String prop = "track.interval." + source;
        String interval = manager.getProperty(prop, manager.getProperty(PROP_INTERVAL));
        if (interval == null) {
            return 60000L;
        }
        return Long.parseLong(interval) * 1000L;
    }

    @Override
    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.fileWatchInterval = this.getInterval(manager, "files");
        this.eventLogInterval = this.getInterval(manager, "eventlog");
        this.runnableTrackInterval = this.getInterval(manager, "runnable");
    }

    @Override
    public void shutdown() throws PluginException {
        super.shutdown();
        if (this.fileWatcherThread != null) {
            this.fileWatcherThread.doStop();
            this.fileWatcherThread = null;
        }
        if (this.runnableTrackThread != null) {
            this.runnableTrackThread.doStop();
            this.runnableTrackThread = null;
        }
        this.closeEventLogs();
        LogFileTailPlugin.cleanup();
    }

    private FileWatcherThread getFileWatcherThread() {
        if (this.fileWatcherThread == null) {
            this.fileWatcherThread = FileWatcherThread.getInstance();
            if (this.fileWatchInterval != 0L) {
                this.fileWatcherThread.setInterval(this.fileWatchInterval);
            }
            this.fileWatcherThread.doStart();
        }
        return this.fileWatcherThread;
    }

    public void addFileWatcher(FileWatcher watcher) {
        this.getFileWatcherThread().add(watcher);
    }

    public void removeFileWatcher(FileWatcher watcher) {
        this.getFileWatcherThread().remove(watcher);
    }

    private EventLogThread getEventLogThread(String name) {
        EventLogThread instance = (EventLogThread)this.eventLogs.get(name = name.toUpperCase());
        if (instance == null) {
            instance = new EventLogThread();
            instance.setLogName(name);
            if (this.eventLogInterval != 0L) {
                instance.setInterval(this.eventLogInterval);
            }
            instance.doStart();
            this.eventLogs.put(name, instance);
            this.log.debug((Object)("Created EventLogThread(" + name + ")"));
        }
        return instance;
    }

    public void closeEventLogs() {
        for (EventLogThread eventLogThread : this.eventLogs.values()) {
            eventLogThread.doStop();
        }
        this.eventLogs.clear();
    }

    private String[] getEventLogNames(Win32EventLogNotification notifier) throws PluginException {
        String[] eventLogs = EventLog.getLogNames();
        String name = notifier.getLogName();
        if (name.equals("*")) {
            return eventLogs;
        }
        HashMap<String, Boolean> lcNames = new HashMap<String, Boolean>();
        for (int i = 0; i < eventLogs.length; ++i) {
            lcNames.put(eventLogs[i].toLowerCase(), Boolean.TRUE);
        }
        StringTokenizer tok = new StringTokenizer(name, ",");
        int i = 0;
        int num = tok.countTokens();
        String[] names = new String[num];
        while (tok.hasMoreTokens()) {
            String logName = tok.nextToken();
            if (lcNames.get(logName.toLowerCase()) != Boolean.TRUE) {
                String msg = "Event Log '" + logName + "' does not exist";
                throw new PluginException(msg);
            }
            names[i++] = logName;
        }
        return names;
    }

    public void addEventLogNotification(Win32EventLogNotification notifier) throws PluginException {
        String[] names = this.getEventLogNames(notifier);
        for (int i = 0; i < names.length; ++i) {
            this.getEventLogThread(names[i]).add((EventLogNotification)notifier);
        }
    }

    public void removeEventLogNotification(Win32EventLogNotification notifier) throws PluginException {
        String[] names = this.getEventLogNames(notifier);
        for (int i = 0; i < names.length; ++i) {
            this.getEventLogThread(names[i]).remove((EventLogNotification)notifier);
        }
    }

    private RunnableTrackThread getRunnableTrackThread() {
        if (this.runnableTrackThread == null) {
            this.runnableTrackThread = RunnableTrackThread.getInstance();
            if (this.runnableTrackInterval != 0L) {
                this.runnableTrackThread.setInterval(this.runnableTrackInterval);
            }
            this.runnableTrackThread.doStart();
        }
        return this.runnableTrackThread;
    }

    public void addRunnableTracker(Runnable tracker) {
        this.getRunnableTrackThread().add(tracker);
    }

    public void removeRunnableTracker(Runnable tracker) {
        this.getRunnableTrackThread().remove(tracker);
    }

    static String getGenericHelp(LogTrackPluginManager ltpm, ConfigSchema schema, TypeInfo info) {
        StringBuffer buffer = null;
        boolean isPlatform = info.getType() == 1;
        String defaultDir = info.isWin32Platform() ? "\\" : "/";
        LogTrackPlugin plugin = ltpm.getLogTrackPlugin(info.getName());
        for (int i = 0; i < GENERIC_HELP.length; ++i) {
            String[] levels;
            String[] aliases;
            String name = GENERIC_HELP[i][0];
            String key = GenericPlugin.TYPE_LABELS[info.getType()] + name;
            String val = GENERIC_HELP[i][1];
            ConfigOption option = schema.getOption(key);
            if (option == null) {
                option = schema.getOption(name);
            }
            if (option == null) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
                buffer.append("<p><h4>General Log and Config Track Properties</h4></p>\n");
                buffer.append("<ul>\n");
            }
            if (isPlatform) {
                val = StringUtil.replace((String)val, (String)"${installpath}", (String)defaultDir);
            }
            buffer.append("<li>").append(option.getDescription()).append(" - ").append(val);
            if (key.endsWith("log_track.level") && plugin != null && (aliases = plugin.getLogLevelAliases()) != (levels = LogTrackPlugin.LOGLEVEL_LABELS)) {
                buffer.append("<br>Mapping:<ul>\n");
                for (int j = 0; j < levels.length; ++j) {
                    buffer.append("<li>").append(aliases[j]).append(" -> ").append(levels[j]).append("</li>\n");
                }
                buffer.append("</ul>\n");
            }
            buffer.append("</li>\n");
        }
        if (buffer != null) {
            buffer.append("</ul>\n");
            return buffer.toString();
        }
        return null;
    }
}

