/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.jmx.MxUtil;

public class MBeanDumper {
    private static Log log = LogFactory.getLog(MBeanDumper.class);
    protected Properties _config;
    private MBeanServerConnection _server;
    protected static final String PROP_JMX_QUERY = "jmx.query";
    private static final String DEFAULT_URL = "service:jmx:rmi://localhost/jndi/rmi://localhost:1099/jmxrmi";

    protected boolean isValidObjectName(String name) {
        try {
            new ObjectName(name);
            return true;
        }
        catch (MalformedObjectNameException e) {
            return false;
        }
    }

    protected boolean isValidURL(String url) {
        if (url.startsWith("ptql:")) {
            return true;
        }
        try {
            new JMXServiceURL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    protected Properties getConfig(String[] args) {
        this._config = new Properties();
        String url = DEFAULT_URL;
        String query = "*:*";
        String user = System.getProperty("user");
        String pass = System.getProperty("pass");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isValidURL(arg)) {
                url = arg;
                continue;
            }
            if (this.isValidObjectName(arg)) {
                query = arg;
                continue;
            }
            if (user == null) {
                user = arg;
                continue;
            }
            if (pass == null) {
                pass = arg;
                continue;
            }
            throw new IllegalArgumentException("Invalid argument: " + arg);
        }
        this._config.putAll((Map<?, ?>)System.getProperties());
        if (this._config.getProperty("jmx.url") == null) {
            this._config.setProperty("jmx.url", url);
        }
        if (this._config.getProperty(PROP_JMX_QUERY) == null) {
            this._config.setProperty(PROP_JMX_QUERY, query);
        }
        if (user != null) {
            this._config.setProperty("jmx.username", user);
        }
        if (pass != null) {
            this._config.setProperty("jmx.password", pass);
        }
        String[][] keys = this.getPropertyMap();
        for (int i = 0; i < keys.length; ++i) {
            this._config.setProperty(keys[i][1], this._config.getProperty(keys[i][0]));
        }
        return this._config;
    }

    protected String[][] getPropertyMap() {
        return new String[0][0];
    }

    protected MBeanServerConnection getMBeanServer(Properties config) throws Exception {
        this._server = MxUtil.getMBeanServer(config);
        return this._server;
    }

    protected MBeanInfo getMBeanInfo(ObjectName obj) throws Exception {
        return this._server.getMBeanInfo(obj);
    }

    protected Object getAttribute(ObjectName obj, String name) throws Exception {
        return this._server.getAttribute(obj, name);
    }

    protected ObjectName getQuery() {
        String query = this._config.getProperty(PROP_JMX_QUERY);
        try {
            return new ObjectName(query);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(query);
        }
    }

    public void dump(String[] args) throws Exception {
        this.dump(this.getConfig(args));
    }

    public void dump(Properties config) throws Exception {
        MBeanServerConnection mServer = this.getMBeanServer(config);
        this.dump(mServer.queryNames(this.getQuery(), null));
    }

    public void dump(Set beans) {
        for (ObjectName obj : beans) {
            block12: {
                try {
                    MBeanInfo info = this.getMBeanInfo(obj);
                    System.out.println("MBean: " + info.getClassName());
                    System.out.println("Name:  " + obj);
                    MBeanAttributeInfo[] attrs = info.getAttributes();
                    for (int k = 0; k < attrs.length; ++k) {
                        String value;
                        String name;
                        block11: {
                            name = attrs[k].getName();
                            value = "null";
                            try {
                                Object o = this.getAttribute(obj, name);
                                if (o != null) {
                                    value = o.getClass().isArray() ? Arrays.asList((Object[])o).toString() : o.toString();
                                }
                            }
                            catch (Exception e) {
                                value = "ERROR";
                                if (!log.isDebugEnabled()) break block11;
                                e.printStackTrace();
                            }
                        }
                        String perms = "";
                        if (attrs[k].isReadable()) {
                            perms = perms + "r";
                        }
                        if (attrs[k].isWritable()) {
                            perms = perms + "w";
                        }
                        System.out.println("\t" + k + ". Attribute: " + name + " = " + value + " (" + perms + ")");
                    }
                    MBeanOperationInfo[] ops = info.getOperations();
                    for (int i = 0; i < ops.length; ++i) {
                        ArrayList<String> sig = new ArrayList<String>();
                        MBeanParameterInfo[] params = ops[i].getSignature();
                        for (int j = 0; j < params.length; ++j) {
                            sig.add(params[j].getType());
                        }
                        System.out.println("\t Operation: " + ops[i].getReturnType() + " " + ops[i].getName() + " " + sig);
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block12;
                    e.printStackTrace();
                }
            }
            System.out.println("");
        }
    }

    public static void main(String[] args) throws Exception {
        new MBeanDumper().dump(args);
    }
}

