/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.Properties;
import javax.management.ObjectName;
import org.hyperic.hq.product.jmx.MxQuery;
import org.hyperic.hq.product.jmx.MxServerQuery;

public abstract class MxServiceQuery
extends MxQuery {
    private MxQuery parent;
    private MxServerQuery serverQuery;

    public abstract String getQueryName();

    public abstract String getMBeanClass();

    public abstract String getObjectNameFilter();

    public boolean apply(ObjectName name) {
        return true;
    }

    public MxServiceQuery cloneInstance() {
        MxServiceQuery query;
        try {
            query = (MxServiceQuery)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        query.setParent(this.getParent());
        query.setName(this.getName());
        return query;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    @Override
    public String getResourceType() {
        return this.getServerQuery().getResourceType() + " " + this.getServiceResourceType();
    }

    public abstract String getServiceResourceType();

    @Override
    public Properties getResourceConfig() {
        return new Properties();
    }

    @Override
    public String getQualifiedName() {
        StringBuffer buf = new StringBuffer();
        MxQuery query = this;
        while ((query = query.getParent()) != null) {
            buf.append(query.getQualifiedName());
            buf.append(" ");
        }
        String type = this.getServiceResourceType();
        String name = this.objectName.getKeyProperty("name");
        if (name != null) {
            if (!name.equalsIgnoreCase(type)) {
                buf.append(name);
                buf.append(" ");
            }
        } else {
            buf.append(this.getName());
            buf.append(" ");
        }
        buf.append(type);
        return buf.toString();
    }

    @Override
    public MxQuery getParent() {
        return this.parent;
    }

    public void setParent(MxQuery parent) {
        this.parent = parent;
    }

    public MxServerQuery getServerQuery() {
        return this.serverQuery;
    }

    public void setServerQuery(MxServerQuery serverQuery) {
        this.serverQuery = serverQuery;
    }
}

