/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.util;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.common.shared.ProductProperties;
import org.hyperic.hq.measurement.UnitsConvert;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.ControlPluginManager;
import org.hyperic.hq.product.LiveDataPluginManager;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.MeasurementPluginManager;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformTypeInfo;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginExistsException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.util.PluginDiscoverer;
import org.hyperic.sigar.FileWatcherThread;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.timer.StopWatch;
import org.hyperic.util.units.FormattedNumber;

public class PluginDumper {
    static final String PRODUCT_JAR = "dcs-tools-pdk";
    static Log log = LogFactory.getLog((String)PluginDumper.class.getName());
    PluginDumperConfig config;
    protected ProductPluginManager ppm;
    protected MeasurementPluginManager mpm;
    protected ControlPluginManager cpm;
    protected LiveDataPluginManager ldpm;
    protected LogTrackPluginManager ltpm;
    AutoinventoryPluginManager apm;
    HashMap productTypes = new HashMap();
    static final String OS = OperatingSystem.getInstance().getName();
    protected ProductPlugin[] pPlugins;
    private static final String XML_VERSION = "<?xml version=\"1.0\"?>";
    private static final String[] TYPES = new String[]{"", "platform", "server", "service"};
    private static final String[] TYPE_INDENT = new String[]{"", "   ", "   ", "      "};
    static final String PROP_METHOD = "dumper.method";
    static final String PROP_PLUGIN = "dumper.plugin";
    static final String PROP_TYPE = "dumper.type";
    static final String METHOD_METRIC = "metric";
    static final String METHOD_CONTROL = "control";
    static final String METHOD_LIVEDATA = "livedata";
    static final String METHOD_DISCOVER = "discover";
    static final String METHOD_GENERATE = "generate";
    static final String METHOD_TRACK = "track";
    static final String DEFAULT_FILE = "metrics.xml";
    private static final Collection<Collector> executedCollectors = new ArrayList<Collector>();

    public PluginDumper() {
        this.setInterval("exec.interval", 1);
        System.setProperty("collector.isPoolable", "false");
        this.setInterval("track.interval", 1);
        FileWatcherThread.getInstance().setInterval(1000L);
        this.config = new PluginDumperConfig();
    }

    public PluginDumper(String pdkDir, String pluginDir) {
        this();
        this.config.pdkDir = pdkDir;
        this.config.pluginDir = pluginDir;
    }

    public PluginDumper(String[] args) {
        this();
        this.getopt(args);
    }

    public static void help(String msg) {
        PrintStream os = System.out;
        if (msg != null) {
            os.println(msg);
        }
        os.println("[-p plugin] [-t type] [-m method] [-a action] [-o outputDir] [-f filename] [-D key=value]");
    }

    private void setInterval(String prop, int seconds) {
        if (System.getProperty(prop) == null) {
            System.setProperty(prop, String.valueOf(seconds));
        }
    }

    private void getopt(String[] args) {
        int opt;
        Getopt parser = new Getopt("plugindumper", args, "hvp:t:m:a:o:f:D:");
        parser.setOpterr(false);
        PluginDumperConfig config = this.config;
        block10: while ((opt = parser.getopt()) != -1) {
            config.hasSwitches = true;
            switch (opt) {
                case 112: {
                    config.plugin = parser.getOptarg();
                    continue block10;
                }
                case 116: {
                    config.type = parser.getOptarg();
                    continue block10;
                }
                case 109: {
                    config.method = parser.getOptarg();
                    continue block10;
                }
                case 97: {
                    config.action = parser.getOptarg();
                    continue block10;
                }
                case 111: {
                    config.outputDir = parser.getOptarg();
                    continue block10;
                }
                case 102: {
                    config.filename = parser.getOptarg();
                    continue block10;
                }
                case 68: {
                    String arg;
                    String key = arg = parser.getOptarg();
                    String val = "true";
                    int ix = arg.indexOf("=");
                    if (ix != -1) {
                        key = arg.substring(0, ix);
                        val = arg.substring(ix + 1, arg.length());
                    }
                    config.props.setProperty(key, val);
                    config.defines.setProperty(key, val);
                    continue block10;
                }
                case 118: {
                    System.out.println(ProductProperties.getVersion());
                    continue block10;
                }
            }
            config.help = true;
            return;
        }
        int i = parser.getOptind();
        if (i < args.length) {
            ArrayList<String> extra = new ArrayList<String>();
            while (i < args.length) {
                if (args[i].endsWith(".properties")) {
                    config.hasSwitches = true;
                    config.load(args[i]);
                } else {
                    extra.add(args[i]);
                }
                ++i;
            }
            config.args = extra.toArray(new String[0]);
        } else {
            config.args = new String[0];
        }
    }

    public void init() throws PluginException {
        List include;
        this.config.props.putAll((Map<?, ?>)System.getProperties());
        this.config.init();
        File pdkDir = new File(this.config.pdkDir);
        if (!pdkDir.exists()) {
            System.out.println(this.config.pdkDir + " does not exist");
            System.exit(1);
        }
        String bh = "agent.bundle.home";
        if (System.getProperty("agent.bundle.home") == null) {
            System.setProperty("agent.bundle.home", pdkDir.getParent());
        }
        this.ppm = new ProductPluginManager(this.config.props);
        this.ppm.setRegisterTypes(this.config.registerTypes);
        this.ppm.init();
        this.mpm = this.ppm.getMeasurementPluginManager();
        this.cpm = this.ppm.getControlPluginManager();
        this.ldpm = this.ppm.getLiveDataPluginManager();
        this.apm = this.ppm.getAutoinventoryPluginManager();
        this.ltpm = this.ppm.getLogTrackPluginManager();
        this.loadPlugins();
        if (this.config.plugin == null && (include = this.getPluginsInclude()) != null && include.size() == 1) {
            this.config.plugin = (String)include.get(0);
        }
        this.pPlugins = this.config.plugin != null ? new ProductPlugin[]{(ProductPlugin)this.ppm.getPlugin(this.config.plugin)} : this.ppm.getPlugins().values().toArray(new ProductPlugin[0]);
    }

    public void shutdown() {
        try {
            this.ppm.shutdown();
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke() throws PluginException, IOException {
        String method = this.config.method;
        if (this.config.help) {
            PluginDumper.help(null);
            return;
        }
        if (method.equals(METHOD_METRIC)) {
            boolean translateOnly = "translate".equals(this.config.action);
            if ("raw".equals(this.config.action)) {
                String template = this.getProperty("template");
                try {
                    System.out.println(this.getValue(template));
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            if (this.config.plugin != null) {
                this.fetchMetrics(this.config.plugin, translateOnly);
                return;
            }
            if (!translateOnly) {
                PluginDumper.help("No plugin specified");
                return;
            }
            int i = 0;
            while (i < this.pPlugins.length) {
                this.fetchMetrics(this.pPlugins[i].getName(), translateOnly);
                ++i;
            }
            return;
        }
        if (method.equals(METHOD_CONTROL)) {
            if (this.config.plugin != null) {
                this.testControl(this.config.plugin);
                return;
            }
            PluginDumper.help("No plugin specified");
            return;
        }
        if (method.equals(METHOD_LIVEDATA)) {
            if (this.config.type == null) {
                PluginDumper.help("-t required");
                return;
            }
            if (this.config.action == null) {
                PluginDumper.help("-a required");
                return;
            }
            this.testLiveData();
            return;
        }
        if (method.equals(METHOD_TRACK)) {
            if (this.config.plugin != null) {
                this.testTrack();
                return;
            }
            PluginDumper.help("No plugin specified");
            return;
        }
        if (method.equals(METHOD_DISCOVER)) {
            this.testDiscovery();
            return;
        }
        if (method.equals(METHOD_GENERATE)) {
            String outputDir = this.config.outputDir;
            String action = this.config.action;
            String filename = this.config.filename;
            if (action == null) {
                PluginDumper.help("No action specified");
                return;
            }
            if (action.equals("help")) {
                this.dumpHelp(new File(outputDir, "plugin-help"));
                return;
            }
            if (action.equals("metrics-xml")) {
                this.dumpMetrics(outputDir, filename, true);
                return;
            }
            if (action.equals("metrics-txt")) {
                this.dumpMetrics(outputDir, filename, false);
                return;
            }
            if (action.equals("metrics-wiki")) {
                this.dumpWikiDocs();
                return;
            }
            PluginDumper.help("Unknown action: " + action);
            return;
        }
        if (method.equals("lifecycle")) {
            return;
        }
        PluginDumper.help("Unknown method: " + method);
    }

    public Properties getProperties() {
        return this.config.props;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defVal) {
        return System.getProperty(key, this.config.props.getProperty(key, defVal));
    }

    private List getPluginsInclude() {
        String include = this.getProperty("plugins.include");
        if (include == null) {
            return null;
        }
        return StringUtil.explode((String)include, (String)",");
    }

    private void loadPlugins() {
        int nplugins = this.ppm.registerPlugins(this.config.pluginDir, null).size();
        String dir = this.config.props.getProperty("plugin.dir");
        if ((nplugins += this.ppm.registerPlugins(dir, null).size()) == 0) {
            System.out.println("no plugins loaded from directory: " + this.config.pluginDir);
            return;
        }
        for (String name : this.ppm.getPlugins().keySet()) {
            ProductPlugin plugin;
            if (this.config.plugin != null && !name.startsWith(this.config.plugin) || (plugin = this.ppm.getProductPlugin(name)) == null) continue;
            TypeInfo[] types = plugin.getTypes();
            for (int j = 0; j < types.length; ++j) {
                this.productTypes.put(types[j].getName(), name);
            }
        }
    }

    private void getConfig(ConfigResponse config, ConfigSchema schema) {
        List options = schema.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            ConfigOption opt = (ConfigOption)options.get(i);
            String key = opt.getName();
            config.setValue(key, this.getProperty(key, opt.getDefault()));
        }
    }

    private void getConfig(ConfigResponse config, TypeInfo type) throws PluginException {
        String[] types = new String[]{METHOD_CONTROL, "measurement"};
        for (int i = 0; i < types.length; ++i) {
            try {
                PluginManager pm = this.ppm.getPluginManager(types[i]);
                ConfigSchema schema = pm.getConfigSchema(type.getName(), type, config);
                this.getConfig(config, schema);
                continue;
            }
            catch (PluginNotFoundException e) {
                // empty catch block
            }
        }
    }

    ConfigResponse getPluginConfig(ProductPlugin pPlugin, TypeInfo type) throws PluginException {
        ConfigResponse config = new ConfigResponse();
        this.getConfig(config, pPlugin.getConfigSchema(type, config));
        this.getConfig(config, type);
        if (type.getType() == 3) {
            ServiceTypeInfo service = (ServiceTypeInfo)type;
            ServerTypeInfo serverType = service.getServerTypeInfo();
            this.getConfig(config, serverType);
            this.getConfig(config, pPlugin.getConfigSchema(serverType, config));
        }
        String platform = type.getPlatformTypes()[0];
        this.getConfig(config, new PlatformTypeInfo(platform));
        for (Map.Entry<Object, Object> entry : this.config.defines.entrySet()) {
            config.setValue((String)entry.getKey(), (String)entry.getValue());
        }
        String[] paths = new String[]{"installpath", this.config.plugin + "." + "installpath"};
        String installpath = null;
        for (int j = 0; j < paths.length && (installpath = this.config.props.getProperty(paths[j])) == null; ++j) {
        }
        if (installpath != null) {
            config.setValue("installpath", installpath);
        }
        return config;
    }

    private MetricValue getValue(String template) throws Exception {
        MetricValue value = this.mpm.getValue(template);
        if (value.isFuture() || value.isNone()) {
            Collection<Collector> collectorsToExecute = Collector.getCollectorsToExecute();
            for (Collector collector : collectorsToExecute) {
                if (executedCollectors.contains(collector)) continue;
                log.debug((Object)("[getValue] running collector:'" + collector.getClass().getName() + "' " + collector));
                collector.run();
                executedCollectors.add(collector);
            }
            value = this.mpm.getValue(template);
        }
        return value;
    }

    private boolean isRunnablePlatform(TypeInfo type) {
        String[] platforms = type.getPlatformTypes();
        if (!PlatformDetector.isSupportedPlatform(platforms[0])) {
            return true;
        }
        return Arrays.asList(platforms).contains(OS);
    }

    private void promptContinue() {
        System.err.println("hit enter to continue");
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reportException(Exception e, MeasurementPlugin mPlugin) {
        this.reportException(e, null, mPlugin);
    }

    private void reportException(Exception e, String template, MeasurementPlugin mPlugin) {
        if (template != null) {
            System.err.println("    " + template);
        }
        System.err.println("    getValue failed: " + e.getMessage());
        if ("debug".equals(this.getProperty("log"))) {
            e.printStackTrace();
            System.err.println("classloader=" + mPlugin.getClass().getClassLoader());
            System.err.println("config=" + this.config);
        }
        if ("true".equals(this.getProperty("pause-on-error"))) {
            this.promptContinue();
        }
    }

    private void printMatricHeader(TypeInfo type, MeasurementInfo info, String tmpl) {
        System.out.println("  " + info.getName() + ":");
        Metric metric = Metric.parse(tmpl);
        System.out.println("    " + metric.toDebugString());
    }

    public boolean fetchMetrics(TypeInfo type, boolean translateOnly, ConfigResponse config) throws PluginException {
        MeasurementPlugin mPlugin = this.ppm.getMeasurementPlugin(type.getName());
        if (mPlugin == null) {
            return false;
        }
        MeasurementInfo[] metrics = mPlugin.getMeasurements(type);
        if (metrics == null) {
            return false;
        }
        boolean metricPause = "true".equals(this.getProperty("metric-pause"));
        String collect = this.getProperty("metric-collect");
        boolean isIndicator = "true".equals(this.getProperty("metric-indicator"));
        String category = this.getProperty("metric-cat", "all");
        String iter = this.getProperty("metric-iter");
        int iterations = 1;
        if (iter != null) {
            iterations = Integer.parseInt(iter);
        }
        for (MeasurementInfo metric : metrics) {
            if (isIndicator && !metric.isIndicator() || !category.equals("all") && !category.equalsIgnoreCase(metric.getCategory()) || collect != null && !metric.getName().equals(collect)) continue;
            String template = metric.getTemplate();
            try {
                template = this.mpm.translate(template, config);
            }
            catch (PluginNotFoundException e) {
                this.reportException((Exception)((Object)e), template, mPlugin);
                continue;
            }
            String tmpl = template.substring(template.indexOf(":") + 1);
            this.printMatricHeader(type, metric, tmpl);
            if (translateOnly) continue;
            StopWatch timer = new StopWatch();
            for (int x = 0; x < iterations; ++x) {
                try {
                    MetricValue value = this.getValue(template);
                    if (!Double.isNaN(value.getValue())) {
                        FormattedNumber number = UnitsConvert.convert(value.getValue(), metric.getUnits());
                        System.out.println("    => " + number + " <=");
                    } else {
                        System.out.println("    => NaN <=");
                    }
                }
                catch (Exception e) {
                    this.reportException(e, mPlugin);
                }
                if (!metricPause) continue;
                this.promptContinue();
            }
            if (iterations <= 1 || metricPause) continue;
            System.out.println("Metrics gather in " + timer + " secs");
        }
        return true;
    }

    public void fetchMetrics(String pluginName, boolean translateOnly) throws PluginException {
        String metricPlugin = this.config.type;
        ProductPlugin pPlugin = this.ppm.getProductPlugin(pluginName);
        if (pPlugin == null) {
            System.out.println(pluginName + " not found");
            return;
        }
        TypeInfo[] types = pPlugin.getTypes();
        for (int i = 0; i < types.length; ++i) {
            boolean isPlatform;
            TypeInfo type = types[i];
            boolean bl = isPlatform = type.getType() == 1;
            if (isPlatform) {
                if (metricPlugin == null) {
                    metricPlugin = OS.toLowerCase();
                }
            } else if (!this.isRunnablePlatform(type)) continue;
            if (!type.getName().equals(metricPlugin)) continue;
            ConfigResponse config = this.getPluginConfig(pPlugin, type);
            this.fetchMetrics(type, translateOnly, config);
        }
    }

    public void testControl(String pluginName) throws PluginException {
        ProductPlugin pPlugin = this.ppm.getProductPlugin(pluginName);
        if (pPlugin == null) {
            System.out.println(pluginName + " not found");
            return;
        }
        String runPlugin = this.config.type;
        String runAction = this.config.action;
        TypeInfo[] types = pPlugin.getTypes();
        for (int i = 0; i < types.length; ++i) {
            List<String> actions;
            TypeInfo type = types[i];
            String typeName = type.getName();
            ControlPlugin cPlugin = this.ppm.getControlPlugin(typeName);
            if (cPlugin == null) continue;
            try {
                actions = this.cpm.getActions(typeName);
            }
            catch (PluginNotFoundException e) {
                continue;
            }
            boolean wantedPlugin = typeName.equals(runPlugin);
            if (runPlugin != null && !wantedPlugin) continue;
            ConfigResponse config = this.getPluginConfig(pPlugin, type);
            System.out.println(typeName + " control plugin");
            System.out.println("   actions=" + actions);
            String resourceName = type.getType() + ":" + typeName.hashCode() + ":" + typeName;
            try {
                this.cpm.createControlPlugin(resourceName, typeName, config);
            }
            catch (PluginNotFoundException pne) {
                System.out.println(pne.getMessage());
                continue;
            }
            catch (PluginExistsException pe) {
                System.out.println(pe.getMessage());
                continue;
            }
            catch (PluginException gpe) {
                System.out.println("ERROR: " + gpe.getMessage());
                continue;
            }
            System.out.println("created '" + resourceName + "' control plugin");
            if (!wantedPlugin) continue;
            if (runAction == null) {
                System.out.println("no control-action configured for " + runPlugin);
                continue;
            }
            if (runAction.equals("state")) continue;
            String[] args = StringUtil.explodeQuoted((String)this.getProperty("control.args"));
            try {
                System.out.println("   " + resourceName + " action: " + runAction + " " + Arrays.asList(args));
                this.cpm.doAction(resourceName, runAction, args, null);
                String msg = this.cpm.getMessage(resourceName);
                int result = this.cpm.getResult(resourceName);
                if (msg == null) {
                    msg = "No Message";
                }
                if (result == 0) {
                    System.out.println("   result: success - " + msg);
                    continue;
                }
                System.out.println("   result: error - " + msg + " (" + result + ")");
                continue;
            }
            catch (PluginNotFoundException pne) {
                continue;
            }
            catch (PluginException e) {
                System.out.println("ERROR: " + e.getMessage());
            }
        }
    }

    public void testLiveData() throws PluginException {
        ConfigResponse config = new ConfigResponse((Map)this.config.props);
        String data = this.ldpm.getData(this.config.type, this.config.action, config);
        System.out.println(data);
    }

    private void flushEvents(LinkedList events, String name) {
        if (events.isEmpty()) {
            return;
        }
        System.out.println(name + " events...");
        for (TrackEvent event : events) {
            System.out.println("[" + new Date(event.getTime()) + "] " + "(" + event.getSource() + ") " + event.getMessage());
        }
    }

    private void flushLogTrackEvents() {
        LinkedList events = this.ltpm.getEvents();
        this.flushEvents(events, "log track");
    }

    private void testTrack() throws PluginException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        this.testTrack(this.config.plugin);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    PluginDumper.this.flushLogTrackEvents();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Done");
                        return;
                    }
                }
            }
        };
        thread.start();
        System.out.println("hit 'q' to quit");
        while ((line = in.readLine()) != null && !line.equals("q")) {
        }
        thread.interrupt();
    }

    private void testTrack(String pluginName) throws PluginException {
        ProductPlugin pPlugin = this.ppm.getProductPlugin(pluginName);
        if (pPlugin == null) {
            return;
        }
        TypeInfo[] types = pPlugin.getTypes();
        String runPlugin = this.config.type;
        for (int i = 0; i < types.length; ++i) {
            TypeInfo type = types[i];
            String typeName = type.getName();
            boolean hasLogTrack = false;
            boolean hasConfigTrack = false;
            boolean wantedPlugin = type.getName().equals(runPlugin);
            if (runPlugin == null ? type.getType() == 1 && !type.getName().equals(OS) : !wantedPlugin) continue;
            String action = this.config.action;
            if (action == null || action.equals("log")) {
                try {
                    this.ltpm.getPlugin(typeName);
                    hasLogTrack = true;
                }
                catch (PluginNotFoundException e) {
                    // empty catch block
                }
            }
            String resourceName = type.getType() + ":" + type.getName().hashCode();
            ConfigResponse config = this.getPluginConfig(pPlugin, type);
            try {
                if (!hasLogTrack) continue;
                this.ltpm.createPlugin(resourceName, typeName, config);
                System.out.println("Created log track plugin for " + typeName);
                continue;
            }
            catch (PluginNotFoundException e) {
                System.out.println(e.getMessage());
                continue;
            }
            catch (PluginExistsException e) {
                System.out.println(e.getMessage());
                continue;
            }
            catch (PluginException e) {
                System.out.println("ERROR: " + e.getMessage());
            }
        }
    }

    public void testDiscovery() {
        PluginDiscoverer discoverer = new PluginDiscoverer(this);
        List include = this.getPluginsInclude();
        if (include != null) {
            for (int i = 0; i < include.size(); ++i) {
                this.addDiscovery(discoverer, (String)include.get(i));
            }
        } else {
            for (int i = 0; i < this.pPlugins.length; ++i) {
                this.addDiscovery(discoverer, this.pPlugins[i].getName());
            }
        }
        discoverer.start();
    }

    private void addDiscovery(PluginDiscoverer discoverer, String pluginName) {
        ProductPlugin pPlugin = this.ppm.getProductPlugin(pluginName);
        if (pPlugin == null) {
            return;
        }
        TypeInfo[] types = pPlugin.getTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].getType() != 2) continue;
            String name = types[i].getName();
            if (this.config.type != null) {
                if (!types[i].getName().equals(this.config.type)) continue;
                discoverer.add(name);
                continue;
            }
            discoverer.add(name);
        }
    }

    protected MeasurementPlugin getMeasurementPlugin(TypeInfo info) {
        return this.ppm.getMeasurementPlugin(info.getName());
    }

    private void dumpWikiDocs() throws IOException {
        HashMap<String, TypeInfo> typeMap = new HashMap<String, TypeInfo>();
        File wikiDir = new File("wiki-docs");
        if (!wikiDir.exists()) {
            wikiDir.mkdir();
        }
        for (int n = 0; n < this.pPlugins.length; ++n) {
            ProductPlugin pp = this.pPlugins[n];
            TypeInfo[] types = pp.getTypes();
            if (types == null || types.length == 0) continue;
            for (int i = 0; i < types.length; ++i) {
                String help;
                TypeInfo type = types[i];
                String name = type.getName();
                if (typeMap.put(name, type) != null) continue;
                String typeName = TYPES[type.getType()];
                MeasurementInfo[] metrics = null;
                MeasurementPlugin mp = this.ppm.getMeasurementPlugin(name);
                if (mp != null) {
                    metrics = mp.getMeasurements(types[i]);
                }
                if (metrics == null || metrics.length == 0) continue;
                String fileName = name + " " + typeName;
                PrintStream ps = PluginDumper.openFile(wikiDir, fileName);
                ps.println("h3. " + name + " " + typeName);
                ps.print("*Log Track Supported:* ");
                try {
                    this.ltpm.getPlugin(name);
                    ps.println("Yes");
                }
                catch (PluginNotFoundException e) {
                    ps.println("No");
                }
                ps.print("*Custom Properties Supported:* ");
                ConfigSchema c = pp.getCustomPropertiesSchema(name);
                List options = c.getOptions();
                if (options.size() == 0) {
                    ps.println("None");
                } else {
                    ps.println("");
                    ps.println("||Name||Description");
                    for (int j = 0; j < options.size(); ++j) {
                        ConfigOption opt = (ConfigOption)options.get(j);
                        ps.println("|" + opt.getName() + "|" + opt.getDescription());
                    }
                    ps.println("||");
                }
                ps.print("*Supported Control Actions:* ");
                try {
                    List<String> actions = this.cpm.getActions(name);
                    for (int j = 0; j < actions.size(); ++j) {
                        String action = actions.get(j);
                        if (j < actions.size() - 1) {
                            ps.print(action + ",");
                            continue;
                        }
                        ps.println(action);
                    }
                }
                catch (PluginNotFoundException e) {
                    ps.println("None");
                }
                ps.println("*Supported Metrics:* ");
                ps.println("||Name||Alias||Units||Category||Default On||Default Interval");
                for (int j = 0; j < metrics.length; ++j) {
                    String colorEnd = "{color}";
                    String colorStart = metrics[j].isDefaultOn() ? "{color:navy}" : "{color:gray}";
                    ps.println("|" + colorStart + metrics[j].getName() + colorEnd + "|" + colorStart + metrics[j].getAlias() + colorEnd + "|" + colorStart + metrics[j].getUnits() + colorEnd + "|" + colorStart + metrics[j].getCategory() + colorEnd + "|" + colorStart + new Boolean(metrics[j].isDefaultOn()) + colorEnd + "|" + colorStart + new Long(metrics[j].getInterval() / 60000L) + " min" + colorEnd);
                }
                ps.println("||||||");
                ps.println("");
                ps.println("*Configuration help:* ");
                try {
                    help = this.mpm.getHelp(type, this.getProperties());
                }
                catch (PluginNotFoundException e) {
                    ps.println("None");
                    ps.close();
                    continue;
                }
                if (help != null) {
                    ps.println("{html}");
                    ps.print(help.toString());
                    ps.println("{html}");
                }
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMetrics(String outputDir, String filename, boolean asXML) throws IOException {
        PrintStream os = PluginDumper.openFile(outputDir, filename);
        String pluginIndent = "   ";
        String metricsIndent = "      ";
        String metricIndent = "         ";
        String pluginEnd = "   </plugin>";
        String metricsEnd = "      </metrics>";
        HashMap<String, TypeInfo> typeMap = new HashMap<String, TypeInfo>();
        try {
            if (asXML) {
                os.println(XML_VERSION);
                os.println("<hq>");
            }
            for (int n = 0; n < this.pPlugins.length; ++n) {
                ProductPlugin pp = this.pPlugins[n];
                String productName = pp.getName();
                TypeInfo[] types = pp.getTypes();
                if (asXML) {
                    os.println("   <plugin name =\"" + productName + "\">");
                } else {
                    os.println("\n" + productName + " plugin:");
                }
                if (types == null || types.length == 0) {
                    if (asXML) {
                        os.println("   </plugin>");
                        continue;
                    }
                    os.println("   [No types defined]");
                    continue;
                }
                for (int i = 0; i < types.length; ++i) {
                    TypeInfo type = types[i];
                    String name = type.getName();
                    ServerTypeInfo server = null;
                    String typeName = TYPES[type.getType()];
                    String indent = TYPE_INDENT[type.getType()];
                    String parent = "";
                    String parentType = "";
                    Object[] platforms = null;
                    switch (type.getType()) {
                        case 2: {
                            server = (ServerTypeInfo)type;
                            platforms = server.getValidPlatformTypes();
                            if (platforms == null) break;
                            parent = ArrayUtil.toString((Object[])platforms);
                            parentType = "platform";
                            break;
                        }
                        case 3: {
                            server = ((ServiceTypeInfo)type).getServerTypeInfo();
                            if (server == null) break;
                            if (server.isVirtual()) {
                                platforms = server.getValidPlatformTypes();
                                if (platforms == null) break;
                                parent = ArrayUtil.toString((Object[])platforms);
                                parentType = "platform";
                                break;
                            }
                            parent = server.getName();
                            parentType = "server";
                        }
                    }
                    MeasurementInfo[] metrics = null;
                    MeasurementPlugin mp = this.ppm.getMeasurementPlugin(name);
                    if (mp != null) {
                        metrics = mp.getMeasurements(types[i]);
                    }
                    if (asXML) {
                        if (typeMap.put(name, type) != null) continue;
                        os.println("\n      <metrics type=\"" + typeName + "\" " + "name=\"" + name + "\" " + "parent=\"" + parent + "\" " + "parentType=\"" + parentType + "\">");
                    } else {
                        os.print("\n" + indent + "'" + name + "' " + typeName);
                        if (server != null) {
                            String pTypes = ArrayUtil.toString((Object[])server.getValidPlatformTypes());
                            os.print(" ");
                            os.print(pTypes);
                            if (metrics != null) {
                                int numOn = this.getNumDefaultOn(metrics);
                                os.print(" [" + metrics.length + " metrics" + ", " + numOn + " default on]");
                            }
                        }
                        os.println("");
                    }
                    if (metrics == null || metrics.length == 0) {
                        if (asXML) {
                            os.println("      </metrics>");
                            continue;
                        }
                        os.println(indent + "[No metrics defined]");
                        continue;
                    }
                    for (int j = 0; j < metrics.length; ++j) {
                        if (asXML) {
                            os.println(metrics[j].toXML("         "));
                            continue;
                        }
                        os.println(indent + this.metricString(metrics[j]));
                    }
                    if (!asXML) continue;
                    os.println("      </metrics>");
                }
                if (!asXML) continue;
                os.println("   </plugin>");
            }
            if (asXML) {
                os.println("</hq>");
            }
        }
        finally {
            if (null != os) {
                os.close();
            }
        }
    }

    private void dumpHelp(File dir) throws IOException {
        for (int n = 0; n < this.pPlugins.length; ++n) {
            ProductPlugin pp = this.pPlugins[n];
            String productName = pp.getName();
            TypeInfo[] types = pp.getTypes();
            if (types == null || types.length == 0) continue;
            File pDir = null;
            for (int i = 0; i < types.length; ++i) {
                String[] platforms;
                String help;
                TypeInfo info = types[i];
                int type = info.getType();
                ServerTypeInfo server = null;
                switch (type) {
                    case 2: {
                        server = (ServerTypeInfo)info;
                        break;
                    }
                    case 3: {
                        server = ((ServiceTypeInfo)info).getServerTypeInfo();
                    }
                }
                try {
                    help = this.mpm.getHelp(info, this.getProperties());
                }
                catch (PluginNotFoundException e) {
                    continue;
                }
                if (help == null) continue;
                if (pDir == null) {
                    pDir = new File(dir, productName);
                    pDir.mkdirs();
                }
                String fileName = info.getFormattedName();
                if (server != null && (platforms = info.getPlatformTypes()).length == 1) {
                    fileName = fileName + "-" + platforms[0].toLowerCase();
                }
                PrintStream ps = PluginDumper.openFile(pDir, fileName + ".html");
                ps.println(help.toString());
                ps.close();
            }
        }
    }

    private String metricString(MeasurementInfo metric) {
        String desc = metric.getName();
        String alias = metric.getAlias();
        String defaultOn = metric.isDefaultOn() ? "yes" : "no";
        return "   - " + desc + " (" + alias + ")" + " [default=" + defaultOn + "]";
    }

    private int getNumDefaultOn(MeasurementInfo[] metrics) {
        int numOn = 0;
        for (int i = 0; i < metrics.length; ++i) {
            if (!metrics[i].isDefaultOn()) continue;
            ++numOn;
        }
        return numOn;
    }

    static PrintStream openFile(File dir, String name) throws IOException {
        File file = new File(dir, name);
        dir.mkdirs();
        FileOutputStream os = new FileOutputStream(file);
        System.out.println("generating [" + file + "]");
        return new PrintStream(os);
    }

    static PrintStream openFile(String dir, String name) throws IOException {
        return PluginDumper.openFile(new File(dir), name);
    }

    class PluginDumperConfig {
        boolean registerTypes = true;
        boolean help = false;
        boolean hasSwitches = false;
        String plugin;
        String type;
        String method;
        String action;
        String filename;
        String outputDir;
        String pdkDir;
        String pluginDir;
        Properties props = new Properties();
        Properties defines = new Properties();
        String[] args;

        PluginDumperConfig() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void load(String file) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                Properties pp = new Properties();
                pp.load(is);
                this.defines.putAll((Map<?, ?>)pp);
                this.props.putAll((Map<?, ?>)pp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        void init() {
            String pluginProperties;
            this.plugin = this.props.getProperty(PluginDumper.PROP_PLUGIN, this.plugin);
            this.type = this.props.getProperty(PluginDumper.PROP_TYPE, this.type);
            this.method = this.props.getProperty(PluginDumper.PROP_METHOD, this.method);
            this.action = this.props.getProperty("action", this.action);
            this.outputDir = this.props.getProperty("output.dir", this.outputDir);
            this.filename = this.props.getProperty("filename", this.filename);
            this.pdkDir = this.props.getProperty("agent.pdkDir", this.pdkDir);
            this.pluginDir = this.pdkDir + File.separator + "plugins";
            if ("all".equals(this.plugin)) {
                this.plugin = null;
            }
            if (this.method == null) {
                this.method = PluginDumper.METHOD_METRIC;
            }
            if (this.method.equals(PluginDumper.METHOD_DISCOVER) && !PluginDumper.METHOD_METRIC.equals(this.action)) {
                this.registerTypes = false;
            }
            if (this.action == null && this.method.equals(PluginDumper.METHOD_METRIC)) {
                this.action = "getvalue";
            }
            if (this.outputDir == null) {
                this.outputDir = ".";
            }
            if (this.filename == null) {
                this.filename = PluginDumper.DEFAULT_FILE;
            }
            if ((pluginProperties = this.props.getProperty("plugin.properties")) != null) {
                this.load(pluginProperties);
            }
        }
    }
}

