/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.hq.product.pluginxml.PluginParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PluginXmlValidator {
    private static final String[] SHARED_XML_LOCATIONS = new String[]{"process-plugin/src/main/resources", "jvm-plugin/src/main/resources", "hibernate-plugin/src/main/resources"};
    private final String pluginDir;

    public PluginXmlValidator(String pluginDir) {
        this.pluginDir = pluginDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginData validatePluginXML(String name) throws Exception {
        PluginData data = new PluginData();
        PluginParser parser = new PluginParser();
        FileInputStream is = null;
        File descriptor = new File(name);
        if (!descriptor.exists()) {
            System.out.println("Skipping " + name + " validation " + "(does not exist)");
            return data;
        }
        data.setFile(name);
        try {
            System.out.println("Validating " + name);
            is = new FileInputStream(descriptor);
            parser.parse(is, data, new BuildTimeEntityResolver(data));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return data;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: PluginXmlValidator <plugin dir>");
            System.exit(1);
        }
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.INFO);
        PatternLayout layout = new PatternLayout("%r [%t] %p %c %x - %m%n");
        rootLogger.addAppender((Appender)new ConsoleAppender((Layout)layout));
        String pluginDir = args[0];
        String desc = "/src/main/resources/etc/hq-plugin.xml";
        String plugin = pluginDir + "/src/main/resources/etc/hq-plugin.xml";
        if (!new File(plugin).exists()) {
            String pluginDirName = new File(pluginDir).getName();
            plugin = pluginDir + "/src/main/resources/" + pluginDirName + ".xml";
            if (!new File(plugin).exists()) {
                System.err.println("Unable to find plugin XML to validate");
                System.exit(1);
            }
        }
        PluginXmlValidator validator = new PluginXmlValidator(new File(pluginDir).getParent());
        try {
            validator.validatePluginXML(plugin);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private class BuildTimeEntityResolver
    implements EntityResolver {
        private final PluginData data;

        BuildTimeEntityResolver(PluginData data) {
            this.data = data;
        }

        private String resolveParentFile(String name) {
            if (this.data.getFile() != null) {
                for (File dir = new File(this.data.getFile()).getParentFile(); dir != null; dir = dir.getParentFile()) {
                    File resolved = new File(dir, name);
                    if (!resolved.exists()) continue;
                    return resolved.toString();
                }
            }
            return name;
        }

        private boolean isPluginFile(String name) {
            return name.startsWith("pdk/plugins/");
        }

        private String resolvePluginFile(String name) throws FileNotFoundException {
            for (String sharedLocation : SHARED_XML_LOCATIONS) {
                File referencedFile = new File(PluginXmlValidator.this.pluginDir + "/" + sharedLocation + "/" + name.substring("pdk/plugins/".length()));
                if (!referencedFile.exists()) continue;
                return referencedFile.getAbsolutePath();
            }
            throw new FileNotFoundException("Unable to find included XML file: " + name.substring("pdk/plugins/".length()) + " under any shared locations in plugin dir: " + PluginXmlValidator.this.pluginDir);
        }

        private String resolveFile(String name) throws FileNotFoundException {
            if (this.isPluginFile(name)) {
                return this.resolvePluginFile(name);
            }
            return this.resolveParentFile(name);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            InputStream is = null;
            try {
                String name = null;
                if (systemId.startsWith("/")) {
                    name = systemId;
                } else if (systemId.startsWith("file:/")) {
                    name = new URL(systemId).getFile();
                }
                if (name != null) {
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    String resolvedName = this.resolveFile(name);
                    is = new FileInputStream(resolvedName);
                    this.data.getIncludes().add(resolvedName);
                    return new InputSource(is);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return new InputSource();
        }
    }
}

