/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUResourceBundleReader;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceBundleIterator;
import com.ibm.icu.util.UResourceTypeMismatchException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.MissingResourceException;

class ICUResourceBundleImpl {
    ICUResourceBundleImpl() {
    }

    static final class ResourceTable32
    extends ICUResourceBundle {
        protected UResourceBundle handleGet(String key, HashMap table, UResourceBundle requested) {
            int offset = ResourceTable32.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ResourceTable32.getIntOffset(1);
            int foundOffset = this.findKey(this.size, currentOffset, this, key);
            if (foundOffset == -1) {
                throw new MissingResourceException("Could not find resource ", ICUResourceBundleReader.getFullName(this.baseName, this.localeID), key);
            }
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ResourceTable32.getIntOffset(this.size) + ResourceTable32.getIntOffset(foundOffset));
            String path = this.isTopLevel ? key : this.resPath + "/" + key;
            return this.createBundleObject(key, resource, path, table, requested, this);
        }

        public String getKey(int currentOffset, int index) {
            int charOffset = currentOffset + ResourceTable32.getIntOffset(index);
            int keyOffset = ICUResourceBundle.getInt(this.rawData, charOffset);
            return ResourceTable32.RES_GET_KEY(this.rawData, keyOffset).toString();
        }

        protected UResourceBundle handleGet(int index, HashMap table, UResourceBundle requested) {
            if (this.size <= 0) {
                return null;
            }
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ResourceTable32.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ResourceTable32.getIntOffset(1) + ResourceTable32.getIntOffset(index);
            String itemKey = this.getKey(currentOffset, 0);
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ResourceTable32.getIntOffset(this.size));
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return this.createBundleObject(itemKey, resource, path, table, requested, this);
        }

        private int countItems() {
            int offset = ResourceTable32.RES_GET_OFFSET(this.resource);
            int value = ICUResourceBundle.getInt(this.rawData, offset);
            return value;
        }

        ResourceTable32(String key, String resPath, long resource, ICUResourceBundle bundle) {
            this(key, resPath, resource, bundle, false);
        }

        ResourceTable32(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
            this.rawData = reader.getData();
            this.rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
            this.noFallback = reader.getNoFallback();
            this.baseName = baseName;
            this.localeID = localeID;
            this.ulocale = new ULocale(localeID);
            this.loader = loader;
            this.initialize(null, "", this.rootResource, null, this.isTopLevel);
        }

        void initialize(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            if (bundle != null) {
                ResourceTable32.assign(this, bundle);
            }
            this.key = key;
            this.resource = resource;
            this.isTopLevel = isTopLevel;
            this.size = this.countItems();
            this.resPath = resPath;
        }

        ResourceTable32(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            this.initialize(key, resPath, resource, bundle, isTopLevel);
        }
    }

    static final class ResourceTable
    extends ICUResourceBundle {
        protected UResourceBundle handleGet(String key, HashMap table, UResourceBundle requested) {
            if (this.size <= 0) {
                return null;
            }
            int offset = ResourceTable.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ResourceTable.getCharOffset(1);
            int foundOffset = this.findKey(this.size, currentOffset, this, key);
            if (foundOffset == -1) {
                return null;
            }
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ResourceTable.getCharOffset(this.size + (~this.size & 1)) + ResourceTable.getIntOffset(foundOffset));
            String path = this.isTopLevel ? key : this.resPath + "/" + key;
            return this.createBundleObject(key, resource, path, table, requested, this);
        }

        public String getKey(int currentOffset, int index) {
            int charOffset = currentOffset + ResourceTable.getCharOffset(index);
            char keyOffset = ResourceTable.getChar(this.rawData, charOffset);
            return ResourceTable.RES_GET_KEY(this.rawData, keyOffset).toString();
        }

        protected UResourceBundle handleGet(int index, HashMap table, UResourceBundle requested) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ResourceTable.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ResourceTable.getCharOffset(1);
            String itemKey = this.getKey(currentOffset, index);
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ResourceTable.getCharOffset(this.size + (~this.size & 1)) + ResourceTable.getIntOffset(index));
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return this.createBundleObject(itemKey, resource, path, table, requested, this);
        }

        private int countItems() {
            int offset = ResourceTable.RES_GET_OFFSET(this.resource);
            char value = ResourceTable.getChar(this.rawData, offset);
            return value;
        }

        ResourceTable(String key, String resPath, long resource, ICUResourceBundle bundle) {
            this(key, resPath, resource, bundle, false);
        }

        ResourceTable(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
            this.rawData = reader.getData();
            this.rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
            this.noFallback = reader.getNoFallback();
            this.baseName = baseName;
            this.localeID = localeID;
            this.ulocale = new ULocale(localeID);
            this.loader = loader;
            this.initialize(null, "", this.rootResource, null, this.isTopLevel);
        }

        void initialize(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            if (bundle != null) {
                ResourceTable.assign(this, bundle);
            }
            this.key = key;
            this.resource = resource;
            this.isTopLevel = isTopLevel;
            this.size = this.countItems();
            this.resPath = resPath;
        }

        ResourceTable(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            this.initialize(key, resPath, resource, bundle, isTopLevel);
        }
    }

    static final class ResourceIntVector
    extends ICUResourceBundle {
        private int[] value;

        public int[] getIntVector() {
            return this.value;
        }

        private int[] getValue() {
            int offset = ResourceIntVector.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundle.getInt(this.rawData, offset);
            int intOffset = offset + ResourceIntVector.getIntOffset(1);
            int[] val = new int[length];
            int byteLength = ResourceIntVector.getIntOffset(length);
            for (int i = 0; i < length; ++i) {
                val[i] = ICUResourceBundle.getInt(this.rawData, intOffset + ResourceIntVector.getIntOffset(i));
            }
            return val;
        }

        ResourceIntVector(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceIntVector.assign(this, bundle);
            this.key = key;
            this.resource = resource;
            this.size = 1;
            this.resPath = resPath;
            this.value = this.getValue();
        }
    }

    static final class ResourceString
    extends ICUResourceBundle {
        private String value;

        public String getString() {
            return this.value;
        }

        ResourceString(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceString.assign(this, bundle);
            this.value = this.getStringValue(resource);
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }
    }

    static final class ResourceInt
    extends ICUResourceBundle {
        public int getInt() {
            return ResourceInt.RES_GET_INT(this.resource);
        }

        public int getUInt() {
            long ret = ResourceInt.RES_GET_UINT(this.resource);
            return (int)ret;
        }

        ResourceInt(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceInt.assign(this, bundle);
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }
    }

    static final class ResourceBinary
    extends ICUResourceBundle {
        private byte[] value;

        public ByteBuffer getBinary() {
            return ByteBuffer.wrap(this.value);
        }

        public byte[] getBinary(byte[] ba) {
            return this.value;
        }

        private byte[] getValue() {
            int offset = ResourceBinary.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundle.getInt(this.rawData, offset);
            int byteOffset = offset + ResourceBinary.getIntOffset(1);
            byte[] dst = new byte[length];
            System.arraycopy(this.rawData, byteOffset, dst, 0, length);
            return dst;
        }

        ResourceBinary(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceBinary.assign(this, bundle);
            this.resource = resource;
            this.key = key;
            this.resPath = resPath;
            this.value = this.getValue();
        }
    }

    static final class ResourceArray
    extends ICUResourceBundle {
        protected String[] handleGetStringArray() {
            String[] strings = new String[this.size];
            UResourceBundleIterator iter = this.getIterator();
            int i = 0;
            while (iter.hasNext()) {
                strings[i++] = iter.next().getString();
            }
            return strings;
        }

        public String[] getStringArray() {
            return this.handleGetStringArray();
        }

        protected UResourceBundle handleGet(String index, HashMap table, UResourceBundle requested) {
            int val = ResourceArray.getIndex(index);
            if (val > -1) {
                return this.handleGet(val, table, requested);
            }
            throw new UResourceTypeMismatchException("Could not get the correct value for index: " + index);
        }

        protected UResourceBundle handleGet(int index, HashMap table, UResourceBundle requested) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ResourceArray.RES_GET_OFFSET(this.resource);
            int itemOffset = offset + ResourceArray.getIntOffset(index + 1);
            long itemResource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, itemOffset);
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return this.createBundleObject(null, itemResource, path, table, requested, this);
        }

        private int countItems() {
            int offset = ResourceArray.RES_GET_OFFSET(this.resource);
            int value = ResourceArray.getInt(this.rawData, offset);
            return value;
        }

        ResourceArray(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceArray.assign(this, bundle);
            this.resource = resource;
            this.key = key;
            this.size = this.countItems();
            this.resPath = resPath;
        }
    }
}

