/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.DirStat;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.DiskUsage;
import org.hyperic.sigar.DumpPidCache;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.MultiProcCpu;
import org.hyperic.sigar.MultiProcMem;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetInfo;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.NetRoute;
import org.hyperic.sigar.NetStat;
import org.hyperic.sigar.NfsClientV2;
import org.hyperic.sigar.NfsClientV3;
import org.hyperic.sigar.NfsFileSystem;
import org.hyperic.sigar.NfsServerV2;
import org.hyperic.sigar.NfsServerV3;
import org.hyperic.sigar.NfsUnreachableException;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcCred;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.ProcCumulativeDiskIO;
import org.hyperic.sigar.ProcDiskIO;
import org.hyperic.sigar.ProcEnv;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcStat;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.ResourceLimit;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.SigarLog;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.Tcp;
import org.hyperic.sigar.ThreadCpu;
import org.hyperic.sigar.Uptime;
import org.hyperic.sigar.Who;
import org.hyperic.sigar.ptql.ProcessFinder;

public class Sigar
implements SigarProxy {
    private static String loadError = null;
    public static final long FIELD_NOTIMPL = -1L;
    public static final int PID_PROC_CPU_CACHE = 1;
    public static final int PID_PROC_IO_CACHE = 2;
    public static final String VERSION_STRING = "1.6.6.0";
    public static final String NATIVE_VERSION_STRING;
    public static final String SCM_REVISION = "exported";
    public static final String NATIVE_SCM_REVISION;
    public static final String BUILD_DATE = "12/20/2015 07:54 AM";
    public static final String NATIVE_BUILD_DATE;
    private static boolean enableLogging;
    private static SigarLoader loader;
    private FileSystemMap mounts;
    private boolean open;
    int sigarWrapper;
    long longSigarWrapper;
    private Cpu lastCpu;
    private Cpu[] lastCpuList;
    private ProcessFinder processFinder;

    private static void checkVersion(String nativeVersionString) throws SigarException {
        StringTokenizer javaVersion = new StringTokenizer(VERSION_STRING, ".");
        StringTokenizer nativeVersion = new StringTokenizer(nativeVersionString, ".");
        String[] desc = new String[]{"major", "minor"};
        for (int i = 0; i < desc.length; ++i) {
            String nv;
            String jv = javaVersion.hasMoreTokens() ? javaVersion.nextToken() : "0";
            String string = nv = nativeVersion.hasMoreTokens() ? nativeVersion.nextToken() : "0";
            if (jv.equals(nv)) continue;
            String msg = desc[i] + " version mismatch: (" + jv + "!=" + nv + ") " + "java=" + VERSION_STRING + ", native=" + nativeVersionString;
            throw new SigarException(msg);
        }
    }

    public static void load() throws SigarException {
        if (loadError != null) {
            throw new SigarException(loadError);
        }
    }

    private static void loadLibrary() throws SigarException {
        try {
            if (SigarLoader.IS_WIN32 && System.getProperty("os.version").equals("4.0")) {
                String lib = loader.findJarPath("pdh.dll") + File.separator + "pdh.dll";
                loader.systemLoad(lib);
            }
            loader.load();
        }
        catch (ArchNotSupportedException e) {
            throw new SigarException(e.getMessage());
        }
        catch (ArchLoaderException e) {
            throw new SigarException(e.getMessage());
        }
        catch (UnsatisfiedLinkError e) {
            throw new SigarException(e.getMessage());
        }
    }

    public File getNativeLibrary() {
        return loader.getNativeLibrary();
    }

    public static native String formatSize(long var0);

    private static native String getNativeVersion();

    private static native String getNativeBuildDate();

    private static native String getNativeScmRevision();

    public Sigar() {
        block5: {
            this.mounts = null;
            this.open = false;
            this.sigarWrapper = 0;
            this.longSigarWrapper = 0L;
            this.processFinder = null;
            try {
                this.open();
                this.open = true;
            }
            catch (SigarException e) {
                if (enableLogging) {
                    e.printStackTrace();
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (!enableLogging) break block5;
                e.printStackTrace();
            }
        }
        if (enableLogging) {
            this.enableLogging(true);
        }
    }

    protected void finalize() {
        this.close();
    }

    private native void open() throws SigarException;

    public synchronized void close() {
        if (this.open) {
            this.nativeClose();
            this.open = false;
        }
    }

    private native int nativeClose();

    public native long getPid();

    public native long getServicePid(String var1) throws SigarException;

    public native void kill(long var1, int var3) throws SigarException;

    public void kill(long pid, String signame) throws SigarException {
        int signum;
        if (Character.isDigit(signame.charAt(0))) {
            try {
                signum = Integer.parseInt(signame);
            }
            catch (NumberFormatException e) {
                signum = -1;
            }
        } else {
            signum = Sigar.getSigNum(signame);
        }
        if (signum < 0) {
            throw new SigarException(signame + ": invalid signal specification");
        }
        this.kill(pid, signum);
    }

    public static native int getSigNum(String var0);

    public void kill(String pid, int signum) throws SigarException {
        this.kill(this.convertPid(pid), signum);
    }

    public Mem getMem() throws SigarException {
        return Mem.fetch(this);
    }

    public Swap getSwap() throws SigarException {
        return Swap.fetch(this);
    }

    public Cpu getCpu() throws SigarException {
        return Cpu.fetch(this);
    }

    static void pause(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void pause() {
        Sigar.pause(500);
    }

    public CpuPerc getCpuPerc() throws SigarException {
        Cpu oldCpu;
        if (this.lastCpu == null) {
            oldCpu = this.getCpu();
            Sigar.pause();
        } else {
            oldCpu = this.lastCpu;
        }
        this.lastCpu = this.getCpu();
        return CpuPerc.fetch(this, oldCpu, this.lastCpu);
    }

    public CpuPerc[] getCpuPercList() throws SigarException {
        Cpu[] oldCpuList;
        if (this.lastCpuList == null) {
            oldCpuList = this.getCpuList();
            Sigar.pause();
        } else {
            oldCpuList = this.lastCpuList;
        }
        this.lastCpuList = this.getCpuList();
        int curLen = this.lastCpuList.length;
        int oldLen = oldCpuList.length;
        CpuPerc[] perc = new CpuPerc[curLen < oldLen ? curLen : oldLen];
        for (int i = 0; i < perc.length; ++i) {
            perc[i] = CpuPerc.fetch(this, oldCpuList[i], this.lastCpuList[i]);
        }
        return perc;
    }

    public ResourceLimit getResourceLimit() throws SigarException {
        return ResourceLimit.fetch(this);
    }

    public Uptime getUptime() throws SigarException {
        return Uptime.fetch(this);
    }

    public native double[] getLoadAverage() throws SigarException;

    public native long[] getProcList() throws SigarException;

    public ProcStat getProcStat() throws SigarException {
        return ProcStat.fetch(this);
    }

    private long convertPid(String pid) throws SigarException {
        if (pid.equals("$$")) {
            return this.getPid();
        }
        if (Character.isDigit(pid.charAt(0))) {
            return Long.parseLong(pid);
        }
        if (this.processFinder == null) {
            this.processFinder = new ProcessFinder(this);
        }
        return this.processFinder.findSingleProcess(pid);
    }

    public ProcMem getProcMem(long pid) throws SigarException {
        return ProcMem.fetch(this, pid);
    }

    public ProcMem getProcMem(String pid) throws SigarException {
        return this.getProcMem(this.convertPid(pid));
    }

    public ProcMem getMultiProcMem(String query) throws SigarException {
        return MultiProcMem.get(this, query);
    }

    public ProcState getProcState(long pid) throws SigarException {
        return ProcState.fetch(this, pid);
    }

    public ProcState getProcState(String pid) throws SigarException {
        return this.getProcState(this.convertPid(pid));
    }

    public ProcTime getProcTime(long pid) throws SigarException {
        return ProcTime.fetch(this, pid);
    }

    public ProcTime getProcTime(String pid) throws SigarException {
        return this.getProcTime(this.convertPid(pid));
    }

    public ProcCpu getProcCpu(long pid) throws SigarException {
        return ProcCpu.fetch(this, pid);
    }

    public ProcCpu getProcCpu(String pid) throws SigarException {
        return this.getProcCpu(this.convertPid(pid));
    }

    public MultiProcCpu getMultiProcCpu(String query) throws SigarException {
        return MultiProcCpu.get(this, query);
    }

    public ProcCred getProcCred(long pid) throws SigarException {
        return ProcCred.fetch(this, pid);
    }

    public ProcCred getProcCred(String pid) throws SigarException {
        return this.getProcCred(this.convertPid(pid));
    }

    public ProcCredName getProcCredName(long pid) throws SigarException {
        return ProcCredName.fetch(this, pid);
    }

    public ProcCredName getProcCredName(String pid) throws SigarException {
        return this.getProcCredName(this.convertPid(pid));
    }

    public ProcFd getProcFd(long pid) throws SigarException {
        return ProcFd.fetch(this, pid);
    }

    public ProcFd getProcFd(String pid) throws SigarException {
        return this.getProcFd(this.convertPid(pid));
    }

    public ProcExe getProcExe(long pid) throws SigarException {
        return ProcExe.fetch(this, pid);
    }

    public ProcExe getProcExe(String pid) throws SigarException {
        return this.getProcExe(this.convertPid(pid));
    }

    public native String[] getProcArgs(long var1) throws SigarException;

    public String[] getProcArgs(String pid) throws SigarException {
        return this.getProcArgs(this.convertPid(pid));
    }

    public Map getProcEnv(long pid) throws SigarException {
        return ProcEnv.getAll(this, pid);
    }

    public Map getProcEnv(String pid) throws SigarException {
        return this.getProcEnv(this.convertPid(pid));
    }

    public String getProcEnv(long pid, String key) throws SigarException {
        return ProcEnv.getValue(this, pid, key);
    }

    public String getProcEnv(String pid, String key) throws SigarException {
        return this.getProcEnv(this.convertPid(pid), key);
    }

    private native List getProcModulesNative(long var1) throws SigarException;

    public List getProcModules(long pid) throws SigarException {
        return this.getProcModulesNative(pid);
    }

    public List getProcModules(String pid) throws SigarException {
        return this.getProcModules(this.convertPid(pid));
    }

    public native long getProcPort(int var1, long var2) throws SigarException;

    public long getProcPort(String protocol, String port) throws SigarException {
        return this.getProcPort(NetFlags.getConnectionProtocol(protocol), Integer.parseInt(port));
    }

    public ProcDiskIO getProcDiskIO(long pid) throws SigarException {
        try {
            return ProcDiskIO.fetch(this, pid);
        }
        catch (UnsatisfiedLinkError linkErrorException) {
            SigarNotImplementedException sigarException = new SigarNotImplementedException();
            sigarException.initCause(linkErrorException);
            throw sigarException;
        }
    }

    public ProcDiskIO getProcDiskIO(String pid) throws SigarException {
        return this.getProcDiskIO(this.convertPid(pid));
    }

    public ProcCumulativeDiskIO getProcCumulativeDiskIO(long pid) throws SigarException {
        try {
            return ProcCumulativeDiskIO.fetch(this, pid);
        }
        catch (UnsatisfiedLinkError linkErrorException) {
            SigarNotImplementedException sigarException = new SigarNotImplementedException();
            sigarException.initCause(linkErrorException);
            throw sigarException;
        }
    }

    public ProcCumulativeDiskIO getProcCumulativeDiskIO(String pid) throws SigarException {
        return this.getProcCumulativeDiskIO(this.convertPid(pid));
    }

    public DumpPidCache dumpPidCache() throws SigarException {
        return DumpPidCache.fetch(this);
    }

    public ThreadCpu getThreadCpu() throws SigarException {
        return ThreadCpu.fetch(this, 0L);
    }

    private native FileSystem[] getFileSystemListNative() throws SigarException;

    public FileSystem[] getFileSystemList() throws SigarException {
        FileSystem[] fslist = this.getFileSystemListNative();
        if (this.mounts != null) {
            this.mounts.init(fslist);
        }
        return fslist;
    }

    public FileSystemUsage getFileSystemUsage(String name) throws SigarException {
        if (name == null) {
            throw new SigarException("name cannot be null");
        }
        return FileSystemUsage.fetch(this, name);
    }

    public DiskUsage getDiskUsage(String name) throws SigarException {
        if (name == null) {
            throw new SigarException("name cannot be null");
        }
        return DiskUsage.fetch(this, name);
    }

    public FileSystemUsage getMountedFileSystemUsage(String name) throws SigarException, NfsUnreachableException {
        NfsFileSystem nfs;
        FileSystem fs = this.getFileSystemMap().getFileSystem(name);
        if (fs == null) {
            throw new SigarException(name + " is not a mounted filesystem");
        }
        if (fs instanceof NfsFileSystem && !(nfs = (NfsFileSystem)fs).ping()) {
            throw nfs.getUnreachableException();
        }
        return FileSystemUsage.fetch(this, name);
    }

    public FileSystemMap getFileSystemMap() throws SigarException {
        if (this.mounts == null) {
            this.mounts = new FileSystemMap();
        }
        this.getFileSystemList();
        return this.mounts;
    }

    public FileInfo getFileInfo(String name) throws SigarException {
        return FileInfo.fetchFileInfo(this, name);
    }

    public FileInfo getLinkInfo(String name) throws SigarException {
        return FileInfo.fetchLinkInfo(this, name);
    }

    public DirStat getDirStat(String name) throws SigarException {
        return DirStat.fetch(this, name);
    }

    public DirUsage getDirUsage(String name) throws SigarException {
        return DirUsage.fetch(this, name);
    }

    public native CpuInfo[] getCpuInfoList() throws SigarException;

    private native Cpu[] getCpuListNative() throws SigarException;

    public Cpu[] getCpuList() throws SigarException {
        return this.getCpuListNative();
    }

    public native NetRoute[] getNetRouteList() throws SigarException;

    public native NetConnection[] getNetConnectionList(int var1) throws SigarException;

    public native String getNetListenAddress(long var1) throws SigarException;

    public String getNetListenAddress(String port) throws SigarException {
        return this.getNetListenAddress(Long.parseLong(port));
    }

    public native String getNetServicesName(int var1, long var2);

    public NetStat getNetStat() throws SigarException {
        NetStat netstat = new NetStat();
        netstat.stat(this);
        return netstat;
    }

    public NetStat getNetStat(byte[] address, long port) throws SigarException {
        NetStat netstat = new NetStat();
        netstat.stat(this, address, port);
        return netstat;
    }

    public native Who[] getWhoList() throws SigarException;

    public Tcp getTcp() throws SigarException {
        return Tcp.fetch(this);
    }

    public NfsClientV2 getNfsClientV2() throws SigarException {
        return NfsClientV2.fetch(this);
    }

    public NfsServerV2 getNfsServerV2() throws SigarException {
        return NfsServerV2.fetch(this);
    }

    public NfsClientV3 getNfsClientV3() throws SigarException {
        return NfsClientV3.fetch(this);
    }

    public NfsServerV3 getNfsServerV3() throws SigarException {
        return NfsServerV3.fetch(this);
    }

    public NetInfo getNetInfo() throws SigarException {
        return NetInfo.fetch(this);
    }

    public NetInterfaceConfig getNetInterfaceConfig(String name) throws SigarException {
        return NetInterfaceConfig.fetch(this, name);
    }

    public NetInterfaceConfig getNetInterfaceConfig() throws SigarException {
        String[] interfaces = this.getNetInterfaceList();
        for (int i = 0; i < interfaces.length; ++i) {
            NetInterfaceConfig ifconfig;
            String name = interfaces[i];
            try {
                ifconfig = this.getNetInterfaceConfig(name);
            }
            catch (SigarException e) {
                continue;
            }
            long flags = ifconfig.getFlags();
            if ((flags & 1L) <= 0L || (flags & 0x10L) > 0L || (flags & 8L) > 0L) continue;
            return ifconfig;
        }
        String msg = "No ethernet interface available";
        throw new SigarException(msg);
    }

    public NetInterfaceStat getNetInterfaceStat(String name) throws SigarException {
        return NetInterfaceStat.fetch(this, name);
    }

    public native String[] getNetInterfaceList() throws SigarException;

    static native String getPasswordNative(String var0) throws IOException, SigarNotImplementedException;

    public static String getPassword(String prompt) throws IOException {
        try {
            return Sigar.getPasswordNative(prompt);
        }
        catch (IOException e) {
            throw e;
        }
        catch (SigarNotImplementedException sigarNotImplementedException) {
            System.out.print(prompt);
            return new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
    }

    public native String getFQDN() throws SigarException;

    public void enableLogging(boolean value) {
        if (value) {
            SigarLog.enable(this);
        } else {
            SigarLog.disable(this);
        }
    }

    static {
        enableLogging = "true".equals(System.getProperty("sigar.nativeLogging"));
        loader = new SigarLoader(Sigar.class);
        String nativeVersion = "unknown";
        String nativeBuildDate = "unknown";
        String nativeScmRevision = "unknown";
        try {
            Sigar.loadLibrary();
            nativeVersion = Sigar.getNativeVersion();
            nativeBuildDate = Sigar.getNativeBuildDate();
            nativeScmRevision = Sigar.getNativeScmRevision();
            Sigar.checkVersion(nativeVersion);
        }
        catch (SigarException e) {
            loadError = e.getMessage();
            try {
                SigarLog.debug(loadError, e);
            }
            catch (NoClassDefFoundError ne) {
                System.err.println(loadError);
                e.printStackTrace();
            }
        }
        NATIVE_VERSION_STRING = nativeVersion;
        NATIVE_BUILD_DATE = nativeBuildDate;
        NATIVE_SCM_REVISION = nativeScmRevision;
    }
}

