/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.tokenservice.util;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vcenter.tokenservice.StructDefinitions;
import com.vmware.vcenter.tokenservice.TokenExchangeDefinitions;
import java.util.Map;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.tokenservice.error", (StructType)StructDefinitions.error);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.tokenservice.invalid_grant", (StructType)StructDefinitions.invalidGrant);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.tokenservice.invalid_request", (StructType)StructDefinitions.invalidRequest);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.tokenservice.invalid_scope", (StructType)StructDefinitions.invalidScope);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.tokenservice.token_exchange.exchange_spec", TokenExchangeDefinitions.exchangeSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.tokenservice.token_exchange.info", TokenExchangeDefinitions.info);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key + ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}

