/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.client.view.availability.hms;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.vim.vmomi.core.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HmsServer
extends ExtensionServer<HmsService> {
    public static final Logger LOGGER = LoggerFactory.getLogger(HmsServer.class);

    @Override
    default public Promise<String> getName() {
        return ((HmsService)this.service()).getServiceInstance().thenCompose(si -> {
            FuturePromise contentPromise = new FuturePromise();
            si.getContent((Future)contentPromise);
            return contentPromise;
        }).thenApply(content -> content.getSiteName());
    }

    @Override
    public Stream<HmsPairSetup> getPairs();

    default public Promise<HmsPairSetup> getPairByGuid(String pairServerGuid) {
        return this.getPairs().filter(hmsPair -> hmsPair.pairServerGuid().equals(pairServerGuid)).next().materialize().thenCompose(pairsPromise -> {
            if (pairsPromise.isSuccessful()) {
                return Promises.resolve((Object)pairsPromise.getResult());
            }
            Exception cause = pairsPromise.getError();
            if (cause instanceof Stream.StreamCompleteException) {
                return Promises.reject((Exception)new ExtensionServer.GetPairFailedException(pairServerGuid));
            }
            LOGGER.warn("Error occurred trying to get pair HMS with guid: {}", (Object)pairServerGuid, (Object)cause);
            return Promises.reject((Exception)cause);
        });
    }
}

