/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.client.view.availability.hms;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;

public interface HmsServersView
extends ExtensionServersView {
    default public Stream<HmsServer> getLocalHmsServers() {
        return this.getLocalServers().filter(HmsServer.class::isInstance).map(HmsServer.class::cast);
    }

    default public Promise<HmsServer> getHmsBy(String guid) {
        return this.getServerBy(guid).thenApply(HmsServer.class::cast);
    }

    default public Promise<HmsServer> getHmsByVcGuid(String vcGuid) {
        return this.getServersFor(vcGuid).filter(extSrv -> extSrv instanceof HmsServer).map(srv -> (HmsServer)srv).collect().thenApply(list -> {
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() > 1) {
                throw new IllegalStateException("More than 1 HMS servers found for VC: " + vcGuid);
            }
            return (HmsServer)list.iterator().next();
        });
    }
}

