/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.common;

import com.vmware.srm.client.utilities.ExecutorUtils;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final int EXEC_CORE_SIZE = 64;
    private static final int SCHED_EXEC_CORE_SIZE = 32;
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final ExecutorService EXEC;
    private static final ScheduledExecutorService SCHED_EXEC;

    public static Executor getExecutor() {
        return EXEC;
    }

    public static ScheduledExecutorService getScheduledExecutor() {
        return SCHED_EXEC;
    }

    static {
        ThreadPoolExecutor tes = new ThreadPoolExecutor(64, 64, 60L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), (ThreadFactory)new ThreadFactoryImpl("srm-topology-thread")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t != null) {
                    LOGGER.warn("Topology task finished with error: ", t);
                }
            }
        };
        tes.allowCoreThreadTimeOut(true);
        EXEC = ExecutorUtils.createThreadContextExecutor((ExecutorService)tes);
        ScheduledThreadPoolExecutor ses = new ScheduledThreadPoolExecutor(32, new ThreadFactoryImpl("srm-topology-sched-thread")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t != null) {
                    LOGGER.warn("Scheduled task finished with error: ", t);
                }
            }
        };
        ses.setRemoveOnCancelPolicy(true);
        SCHED_EXEC = ExecutorUtils.createThreadContextScheduledExecutor((ScheduledExecutorService)ses);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXEC.shutdown();
                SCHED_EXEC.shutdown();
            }
        });
    }

    public static class ThreadFactoryImpl
    implements ThreadFactory {
        final AtomicInteger nextThread = new AtomicInteger(1);
        final String threadPrefix;

        public ThreadFactoryImpl(String prefix) {
            this.threadPrefix = prefix + "-%s";
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = String.format(this.threadPrefix, this.nextThread.getAndIncrement());
            Thread t = new Thread(r, name){

                @Override
                public void setContextClassLoader(ClassLoader cl) {
                    super.setContextClassLoader(cl);
                    if (Utils.class.getClassLoader() != cl) {
                        LOGGER.warn("Overriding classloader with: '{}'", (Object)cl, (Object)new RuntimeException());
                    }
                }
            };
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            t.setContextClassLoader(Utils.class.getClassLoader());
            return t;
        }
    }
}

