/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.impl.core.engine.Context;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.LsppConsistencyWatcher;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import java.util.concurrent.ConcurrentHashMap;

public abstract class NodeContext
implements Context {
    private final ConcurrentHashMap<BaseNode, NestedContext> _contexts = new ConcurrentHashMap();
    private final ServersViewImpl _view;
    private final LsppConsistencyWatcher _watcher;

    public NodeContext(ServersViewImpl view, LsppConsistencyWatcher watcher) {
        this._view = view;
        this._watcher = watcher;
    }

    public abstract Promise<Void> initLocalTokenProvider(TokenProvider var1, Exception var2);

    public ServersViewImpl getView() {
        return this._view;
    }

    public LsppConsistencyWatcher getLsppConsistencyWatcher() {
        return this._watcher;
    }

    public NestedContext getNodeContext(BaseNode node) {
        return this._contexts.computeIfAbsent(node, ignored -> new NestedContext());
    }

    public final class NestedContext
    extends ConcurrentHashMap<String, Object> {
        private NestedContext() {
        }
    }
}

