/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes.utils;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.topology.impl.lspp.LsppNegotiator;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsppHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LsppHelper.class);
    private static final int BASE_MAJOR_VERSION = 8;
    private static final String PATTERN = "vrms-(?<hmsGuid>[\\d\\w-]+)--(?<vcGuid>[\\d\\w-]+)";
    private static final Pattern GUIDS = Pattern.compile("vrms-(?<hmsGuid>[\\d\\w-]+)--(?<vcGuid>[\\d\\w-]+)");

    public static boolean filterExtRegs(LsppService extReg) {
        String version = extReg.getServiceVersion();
        if (StringUtils.isEmpty((String)version)) {
            LOGGER.warn("Invalid extension service registration: \n{}", (Object)extReg);
            return false;
        }
        String prefix = version.split("\\.")[0];
        Integer major = null;
        try {
            major = Integer.valueOf(prefix);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("Invalid extension service registration: \n{}", (Object)extReg);
            return false;
        }
        if (major >= 8) {
            return true;
        }
        LOGGER.debug("Filtering out unsupported extension: \n{}", (Object)extReg);
        return false;
    }

    public static LsppServiceEndpoint getVmomiEndpoint(LsppService registration, String type) {
        return LsppHelper.getEndpoint(registration, "vmomi", type);
    }

    public static LsppServiceEndpoint getEndpoint(LsppService registration, String protocol, String type) {
        for (LsppServiceEndpoint ep : registration.getEndpoints()) {
            if (!protocol.equals(ep.protocol) || !type.equals(ep.type)) continue;
            return ep;
        }
        return null;
    }

    public static Promise<Map<Types.LsppType, Set<LsppService>>> listServers(LsppNegotiator ln, Types.LsppType ... serverTypes) {
        if (serverTypes.length == 0) {
            return Promises.resolve(Collections.emptyMap());
        }
        Set types = Arrays.stream(serverTypes).collect(Collectors.toSet());
        Stream consumerStream = Streams.empty();
        for (Types.LsppType type : types) {
            Promise services;
            switch (type) {
                case Srm: 
                case Hms: {
                    services = ln.query(type.getVmodlType()).thenApply(regs -> regs.stream().filter(LsppHelper::filterExtRegs).collect(Collectors.toSet()));
                    break;
                }
                default: {
                    services = ln.query(type.getVmodlType());
                }
            }
            consumerStream = consumerStream.merge(new Publisher[]{services.thenApply(set -> map -> map.put(type, set))});
        }
        return consumerStream.reduce(new HashMap(), (map, consume) -> {
            consume.accept(map);
            return map;
        });
    }

    public static List<DrSite> createDrSites(Map<Types.LsppType, Set<LsppService>> regByType) {
        DrSite site;
        String vcGuid;
        String[] guids;
        Set vcRegs = regByType.getOrDefault((Object)Types.LsppType.Vc, Collections.emptySet());
        Set<LsppService> spbmRegs = regByType.getOrDefault((Object)Types.LsppType.Spbm, Collections.emptySet());
        Set srmRegs = regByType.getOrDefault((Object)Types.LsppType.Srm, Collections.emptySet());
        Set hmsRegs = regByType.getOrDefault((Object)Types.LsppType.Hms, Collections.emptySet());
        HashMap<String, DrSite> siteByVcGuid = new HashMap<String, DrSite>();
        for (LsppService vc : vcRegs) {
            DrSite site2 = new DrSite();
            site2.setVcReg(vc);
            site2.setSpbmReg(LsppHelper.getSpbmForVc(vc, spbmRegs));
            siteByVcGuid.put(vc.getId(), site2);
        }
        for (LsppService srm : srmRegs) {
            guids = LsppHelper.extractVcAndSrmGuid(srm);
            if (guids == null) {
                LOGGER.warn("Invalid Srm registration: '{}'", (Object)srm);
                continue;
            }
            vcGuid = guids[0];
            site = siteByVcGuid.getOrDefault(vcGuid, new DrSite());
            site.addSrmReg(srm);
            siteByVcGuid.put(vcGuid, site);
        }
        for (LsppService hms : hmsRegs) {
            guids = LsppHelper.extractVcAndHmsGuid(hms);
            if (guids == null) {
                LOGGER.warn("Invalid Hms registration: '{}'", (Object)hms);
                continue;
            }
            vcGuid = guids[0];
            site = siteByVcGuid.getOrDefault(vcGuid, new DrSite());
            site.setHmsReg(hms);
            siteByVcGuid.put(vcGuid, site);
        }
        return siteByVcGuid.values().stream().filter(DrSite::validate).collect(Collectors.toList());
    }

    public static String[] extractVcAndSrmGuid(LsppService srmRegistration) {
        String vcGuid = srmRegistration.getAttributes().get("vcInstanceUuid");
        if (vcGuid == null) {
            return null;
        }
        String srmGuid = srmRegistration.getId();
        return new String[]{vcGuid, srmGuid};
    }

    public static String[] extractVcAndHmsGuid(LsppService hmsRegistration) {
        Matcher matcher = GUIDS.matcher(hmsRegistration.getServiceNameDefault());
        if (!matcher.matches()) {
            return null;
        }
        String vcGuid = matcher.group("vcGuid");
        String hmsGuid = matcher.group("hmsGuid");
        return new String[]{vcGuid, hmsGuid};
    }

    public static LsppService getSpbmForVc(LsppService vcReg, Collection<LsppService> spbmRegs) {
        for (LsppService spbm : spbmRegs) {
            if (!vcReg.getSiteId().equals(spbm.getSiteId()) || !vcReg.getNodeId().equals(spbm.getNodeId())) continue;
            return spbm;
        }
        return null;
    }

    public static final class DrSite {
        private LsppService _vcReg;
        private LsppService _spbmReg;
        private LsppService _hmsReg;
        private final Set<LsppService> _srmRegs = new HashSet<LsppService>();

        public LsppService getVcReg() {
            return this._vcReg;
        }

        public void setVcReg(LsppService vcReg) {
            this._vcReg = vcReg;
        }

        public LsppService getSpbmReg() {
            return this._spbmReg;
        }

        public void setSpbmReg(LsppService spbmReg) {
            this._spbmReg = spbmReg;
        }

        public LsppService getHmsReg() {
            return this._hmsReg;
        }

        public void setHmsReg(LsppService hmsReg) {
            this._hmsReg = hmsReg;
        }

        public Set<LsppService> getSrmRegs() {
            return this._srmRegs;
        }

        public void addSrmReg(LsppService srmReg) {
            this._srmRegs.add(srmReg);
        }

        boolean validate() {
            if (this._vcReg == null) {
                LOGGER.warn("No Vc registration for '{}'", (Object)this);
                return false;
            }
            if (this._spbmReg == null) {
                LOGGER.warn("No Spbm registration for '{}'", (Object)this);
                return false;
            }
            if (this._hmsReg == null) {
                LOGGER.trace("No Hms registration for '{}'", (Object)this);
            }
            if (this._srmRegs.isEmpty()) {
                LOGGER.trace("No Srm registration for '{}'", (Object)this);
            }
            return this._hmsReg != null || !this._srmRegs.isEmpty();
        }

        public String toString() {
            return "DrSite {" + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_vcReg = ", (Object)this._vcReg)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_spbmReg = ", (Object)this._spbmReg)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_srmRegs = ", this._srmRegs)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_hmsReg = ", (Object)this._hmsReg)), (boolean)false) + "\n}";
        }
    }
}

