/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.lspp.monitor.model;

import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.utilities.HashUtils;
import com.vmware.srm.client.utilities.StringUtils;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsppService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LsppService.class);
    private final String _id;
    private final String _serviceVersion;
    private final String _serviceNameDefault;
    private final String _siteId;
    private final String _nodeId;
    private final String _ownerId;
    private final String _product;
    private final String _type;
    private final Types.LsppType _serviceType;
    private final Set<LsppServiceEndpoint> _endpoints;
    private final Map<String, String> _attributeValueByKey;
    private Integer _hashCode;

    private static LsppServiceEndpoint createEndpoint(LsppService service, ServiceRegistration.Endpoint endpoint) {
        if (service == null) {
            throw new IllegalArgumentException("service");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint");
        }
        try {
            return new LsppServiceEndpoint(endpoint.getEndpointType().getType(), endpoint.getEndpointType().getProtocol(), endpoint.getUrl(), endpoint.getSslTrust());
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error("Failed to create LsppServiceEndpoint from endpoint " + endpoint, (Throwable)iae);
            return null;
        }
    }

    private LsppService(String id, String serviceVersion, String serviceNameDefault, String nodeId, String siteId, String ownerId, String product, String type, Map<String, String> attributeByValue, Set<LsppServiceEndpoint> endpoints) {
        this._id = id;
        this._serviceVersion = serviceVersion;
        this._serviceNameDefault = serviceNameDefault;
        this._nodeId = nodeId;
        this._siteId = siteId;
        this._ownerId = ownerId;
        this._product = product;
        this._type = type;
        this._serviceType = Types.LsppType.get(new ServiceRegistration.ServiceType(product, type));
        this._attributeValueByKey = attributeByValue;
        this._endpoints = endpoints;
    }

    public LsppService(String id, String serviceVersion, String serviceNameDefault, String nodeId, String siteId, String ownerId, String product, String type, Collection<ServiceRegistration.Attribute> attributes, Collection<ServiceRegistration.Endpoint> endpoints) {
        if (siteId == null) {
            throw new IllegalArgumentException("siteId");
        }
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        if (serviceVersion == null) {
            throw new IllegalArgumentException("serviceVersion");
        }
        if (ownerId == null) {
            throw new IllegalArgumentException("ownerId");
        }
        if (product == null) {
            throw new IllegalArgumentException("product");
        }
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        if (nodeId == null) {
            nodeId = "";
        }
        this._id = id;
        this._serviceVersion = serviceVersion;
        this._serviceNameDefault = serviceNameDefault;
        this._nodeId = nodeId;
        this._siteId = siteId;
        this._ownerId = ownerId;
        this._product = product;
        this._type = type;
        this._serviceType = Types.LsppType.get(new ServiceRegistration.ServiceType(product, type));
        if (attributes == null || attributes.isEmpty()) {
            this._attributeValueByKey = Collections.emptyMap();
        } else {
            this._attributeValueByKey = new HashMap<String, String>(attributes.size());
            for (ServiceRegistration.Attribute attr : attributes) {
                this._attributeValueByKey.put(attr.getKey(), attr.getValue());
            }
        }
        if (endpoints == null || endpoints.isEmpty()) {
            this._endpoints = Collections.emptySet();
        } else {
            this._endpoints = new HashSet<LsppServiceEndpoint>(endpoints.size());
            for (ServiceRegistration.Endpoint ep : endpoints) {
                LsppServiceEndpoint lsppEndpoint = LsppService.createEndpoint(this, ep);
                if (lsppEndpoint == null) continue;
                this._endpoints.add(lsppEndpoint);
            }
        }
    }

    public String getId() {
        return this._id;
    }

    public String getServiceVersion() {
        return this._serviceVersion;
    }

    public String getServiceNameDefault() {
        return this._serviceNameDefault;
    }

    public String getOwnerId() {
        return this._ownerId;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public String getSiteId() {
        return this._siteId;
    }

    public String getProduct() {
        return this._product;
    }

    public String getType() {
        return this._type;
    }

    public Types.LsppType getServiceType() {
        return this._serviceType;
    }

    public Set<LsppServiceEndpoint> getEndpoints() {
        return Collections.unmodifiableSet(this._endpoints);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this._attributeValueByKey);
    }

    public int hashCode() {
        if (this._hashCode == null) {
            this._hashCode = HashUtils.getHashCode((Object[])new Object[]{this._id, this._nodeId, this._siteId, this._ownerId, this._endpoints, this._serviceVersion});
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LsppService)) {
            return false;
        }
        LsppService other = (LsppService)obj;
        return HashUtils.areEqual((Object)this._id, (Object)other._id) && HashUtils.areEqual((Object)this._nodeId, (Object)other._nodeId) && HashUtils.areEqual((Object)this._siteId, (Object)other._siteId) && HashUtils.areEqual((Object)this._ownerId, (Object)other._ownerId) && HashUtils.areEqual(this._endpoints, other._endpoints) && HashUtils.areEqual((Object)this._serviceVersion, (Object)other._serviceVersion);
    }

    public String toString() {
        HashMap<String, Object> members = new HashMap<String, Object>();
        members.put("_id", this._id);
        members.put("_serviceVersion", this._serviceVersion);
        members.put("_serviceNameDefault", this._serviceNameDefault);
        members.put("_siteId", this._siteId);
        members.put("_nodeId", this._nodeId);
        members.put("_ownerId", this._ownerId);
        members.put("_product", this._product);
        members.put("_type", this._type);
        members.put("_attributes", this._attributeValueByKey);
        members.put("_endpoints", this._endpoints);
        return StringUtils.getToStringValue((String)"LsppService", members);
    }

    public LsppService clone() {
        return new LsppService(this._id, this._serviceVersion, this._serviceNameDefault, this._nodeId, this._siteId, this._ownerId, this._product, this._type, this._attributeValueByKey, (Set<LsppServiceEndpoint>)(this._endpoints.isEmpty() ? Collections.emptySet() : new HashSet<LsppServiceEndpoint>(this._endpoints)));
    }
}

