/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.lspp.monitor.model;

import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppNode;
import com.vmware.srm.client.utilities.HashUtils;
import com.vmware.srm.client.utilities.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LsppSite {
    private final String _id;
    private final Map<LsppNode, LsppNode> _nodes = new HashMap<LsppNode, LsppNode>();
    private Integer _hashCode;

    public LsppSite(String id) {
        if (id == null) {
            throw new IllegalArgumentException("is");
        }
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public Set<LsppNode> getNodes() {
        return Collections.unmodifiableSet(this._nodes.keySet());
    }

    public int hashCode() {
        if (this._hashCode == null) {
            this._hashCode = HashUtils.getHashCode((Object[])new Object[]{this._id});
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LsppSite)) {
            return false;
        }
        LsppSite other = (LsppSite)obj;
        return HashUtils.areEqual((Object)this._id, (Object)other._id);
    }

    public String toString() {
        HashMap<String, Object> members = new HashMap<String, Object>();
        members.put("_id", this._id);
        members.put("_nodes", this._nodes);
        return StringUtils.getToStringValue((String)"LsppSite", members);
    }

    public LsppSite clone() {
        LsppSite clone = new LsppSite(this._id);
        for (LsppNode node : this._nodes.keySet()) {
            LsppNode clonedNode = node.clone();
            clone._nodes.put(clonedNode, clonedNode);
        }
        return clone;
    }
}

