/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.view;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.CachingStream;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.StreamImpl;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import com.vmware.srm.client.utilities.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServersViewImpl
implements SrmServersView,
HmsServersView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServersViewImpl.class);
    private final Publisher _localPublisher;
    private final Publisher _remotePublisher;
    private final StreamImpl<Server<?>> _localServers = new CachingStream();
    private final StreamImpl<Server<?>> _remoteServers = new CachingStream();
    private final Stream<Server<?>> _allServers = this._localServers.merge(new com.vmware.srm.client.reactive.Publisher[]{this._remoteServers});
    private final StreamImpl<PairSetupImpl<?>> _pairSetups = new CachingStream();
    private final Promise<Map<String, Set<PairSetupImpl<?>>>> _pairSetupByPairGuidPromise;

    public ServersViewImpl() {
        this._localPublisher = new PublisherImpl((StreamImpl)this._localServers){

            @Override
            public void complete(Exception err) {
                super.complete(new ServersView.ViewInitException(err));
            }
        };
        this._remotePublisher = new PublisherImpl(this._remoteServers);
        this._pairSetupByPairGuidPromise = this.buildPairSetupMap();
    }

    @Override
    public <T extends Server<?>> Promise<T> getServerBy(String guid) {
        if (StringUtils.isEmpty((String)guid)) {
            return Promises.reject((Exception)new IllegalArgumentException("guid"));
        }
        return this._allServers.filter(server -> guid.equals(server.guid())).next().materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve((Object)((Server)pr.getResult()));
            }
            Exception cause = pr.getError();
            if (cause instanceof Stream.StreamCompleteException) {
                return this._pairSetupByPairGuidPromise.thenCompose(pairSetupByPairGuid -> {
                    Set pairs = (Set)pairSetupByPairGuid.get(guid);
                    if (pairs == null) {
                        return Promises.reject((Exception)new ServersView.ServerNotFoundException(guid));
                    }
                    return this.collectErrors(pairs).thenCompose(causeByPair -> {
                        if (causeByPair.isEmpty()) {
                            String msg = String.format("Server for guid '%s' not found, but pair server(s) exist: %s", guid, pairs);
                            LOGGER.error(msg);
                            return Promises.reject((Exception)new IllegalStateException(msg));
                        }
                        return Promises.reject((Exception)new ExtensionServersView.ServerByPairSetupException(guid, (Map<PairSetup<?>, Exception>)causeByPair));
                    });
                });
            }
            LOGGER.debug("Failed to look up server for guid '{}'", (Object)guid, (Object)cause);
            return Promises.reject((Exception)cause);
        });
    }

    private Promise<Map<String, Set<PairSetupImpl<?>>>> buildPairSetupMap() {
        HashMap result = new HashMap();
        return this._pairSetups.reduce(result, this::registerPairSetup);
    }

    private Map<String, Set<PairSetupImpl<?>>> registerPairSetup(Map<String, Set<PairSetupImpl<?>>> map, PairSetupImpl<?> ps) {
        this.registerPairSetup(map, ps, ps.pairServerGuid());
        this.registerPairSetup(map, ps, ps.pairVcGuid());
        return map;
    }

    private void registerPairSetup(Map<String, Set<PairSetupImpl<?>>> map, PairSetupImpl<?> ps, String guid) {
        HashSet temp = new HashSet();
        Set current = map.getOrDefault(guid, temp);
        if (temp == current) {
            map.put(guid, temp);
        }
        current.add(ps);
    }

    public void close() {
        this._remotePublisher.complete();
        this._pairSetups.publishComplete();
    }

    public Publisher getLocalPublisher() {
        return this._localPublisher;
    }

    public Publisher createPublisher() {
        return this._remotePublisher.createPublisher();
    }

    public <T extends Server<?>> Promise<T> getServerByInternal(String guid) {
        if (StringUtils.isEmpty((String)guid)) {
            return Promises.reject((Exception)new IllegalArgumentException(guid));
        }
        return this._allServers.filter(server -> guid.equals(server.guid())).next().materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve((Object)((Server)pr.getResult()));
            }
            Exception cause = pr.getError();
            if (cause instanceof Stream.StreamCompleteException) {
                return Promises.reject((Exception)new ServersView.ServerNotFoundException(guid));
            }
            LOGGER.debug("Failed to look up server for guid '{}'", (Object)guid, (Object)cause);
            return Promises.reject((Exception)cause);
        });
    }

    public void addPairSetup(PairSetupImpl<?> pairSetup) {
        if (this._pairSetups.isComplete()) {
            LOGGER.error("Adding pairSetup to closed view: {}", pairSetup);
            return;
        }
        this._pairSetups.publishNext(pairSetup);
    }

    private Promise<Map<PairSetup<?>, Exception>> collectErrors(Set<PairSetupImpl<?>> pairs) {
        return Streams.from(pairs).flatMap(ps -> ps.getComplete().materialize().toStream().filter(result -> !result.isSuccessful()).map(result -> new Pair(ps, (Object)((Exception)result.getError().getCause())))).collect().thenApply(collected -> collected.stream().collect(Collectors.toMap(Pair::first, Pair::second)));
    }

    @Override
    public Stream<Server<?>> getLocalServers() {
        return this._localServers;
    }

    @Override
    public Stream<Server<?>> getAllServers() {
        return this._allServers;
    }

    private class PublisherImpl
    implements Publisher {
        final StreamImpl<Server<?>> _servers;
        final AtomicBoolean _complete = new AtomicBoolean(false);
        final AtomicInteger _publishers;

        PublisherImpl(StreamImpl<Server<?>> servers, AtomicInteger publishers) {
            this._servers = servers;
            this._publishers = publishers;
        }

        PublisherImpl(StreamImpl<Server<?>> servers) {
            this(servers, new AtomicInteger(1));
        }

        @Override
        public void publish(Server<?> server) {
            if (this._complete.get()) {
                LOGGER.error("Publishing in closed publisher - server: {}", server);
                return;
            }
            this._servers.publishNext(server);
        }

        @Override
        public void complete() {
            if (this._complete.compareAndSet(false, true) && this._publishers.decrementAndGet() == 0) {
                this._servers.publishComplete();
            }
        }

        @Override
        public void complete(Exception err) {
            LOGGER.error("Publisher '{}' completed with error:", (Object)this, (Object)err);
            this._servers.publishError(err);
            this._complete.set(true);
        }

        @Override
        public boolean isComplete() {
            return this._complete.get();
        }

        @Override
        public Publisher createPublisher() {
            this._publishers.incrementAndGet();
            if (this._complete.get()) {
                if (this._publishers.decrementAndGet() == 0) {
                    this._servers.publishComplete();
                }
                IllegalStateException re = new IllegalStateException("Publisher is completed.");
                LOGGER.error("Failed to create publisher:", (Throwable)re);
                throw re;
            }
            return new PublisherImpl(this._servers, this._publishers);
        }
    }

    public static interface Publisher {
        public void publish(Server<?> var1);

        public void complete();

        public void complete(Exception var1);

        public boolean isComplete();

        public Publisher createPublisher();
    }
}

