/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.ssl;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Verifiers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Verifiers.class);
    private static final ThreadLocal<Boolean> VERIFIED = new ThreadLocal();
    private static final String SHA256 = "SHA-256";
    public static final Pattern SHA256_PATTERN = Pattern.compile("[A-F0-9]{2}(?::[A-F0-9]{2}){31}");

    public static final class LoggingVerifier
    implements ThumbprintVerifier {
        private static final AtomicBoolean _done = new AtomicBoolean(false);

        public ThumbprintVerifier.Result verify(String thumbprint) {
            if (_done.compareAndSet(false, true)) {
                LOGGER.error("No verifier specified. Thumbprint: {}", (Object)thumbprint);
            }
            return ThumbprintVerifier.Result.UNKNOWN;
        }

        public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertions) throws SSLException {
        }
    }

    public static final class CapturingVerifier
    implements ThumbprintVerifier {
        private volatile String _capturedSHA256;

        public String get() {
            Validate.notNull((Object)this._capturedSHA256, (String)"Not thumbprint set");
            return this._capturedSHA256;
        }

        public ThumbprintVerifier.Result verify(String thumbprint) {
            return ThumbprintVerifier.Result.MATCH;
        }

        public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertions) throws SSLException {
            if (this._capturedSHA256 != null) {
                return;
            }
            try {
                this._capturedSHA256 = SslUtil.computeCertificateThumbprint((X509Certificate)chain[0], (String)Verifiers.SHA256);
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                throw new SSLException(e);
            }
        }
    }

    public static class DefaultVerifier
    implements ThumbprintVerifier {
        private final String _thumbprint;
        private final boolean _isSHA256;

        public DefaultVerifier(String thumbprint) {
            if (thumbprint == null) {
                throw new IllegalArgumentException("thumbprint");
            }
            this._thumbprint = thumbprint;
            this._isSHA256 = this._thumbprint.length() == 95 && SHA256_PATTERN.matcher(thumbprint).matches();
        }

        public ThumbprintVerifier.Result verify(String thumbprint) {
            boolean verified = this._thumbprint.equals(thumbprint);
            VERIFIED.set(verified);
            if (!verified && !this._isSHA256) {
                return ThumbprintVerifier.Result.MISMATCH;
            }
            return ThumbprintVerifier.Result.MATCH;
        }

        public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertions) throws SSLException {
            String computed;
            Boolean verified = (Boolean)VERIFIED.get();
            VERIFIED.remove();
            if (verified == null) {
                throw new IllegalStateException("Not verified.");
            }
            if (verified.booleanValue() || trustedChain && verifiedAssertions) {
                return;
            }
            if (ArrayUtils.isEmpty((Object[])chain)) {
                throw new IllegalArgumentException("chain");
            }
            try {
                computed = SslUtil.computeCertificateThumbprint((X509Certificate)chain[0], (String)Verifiers.SHA256);
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                throw new SSLException(e);
            }
            if (!this._thumbprint.equals(computed)) {
                throw new SSLException("Certificate thumbprint mismatch.");
            }
        }
    }
}

