/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.impl.common.Utils;
import com.vmware.srm.client.utilities.ExecuteOnceOpWrapper;
import com.vmware.srm.client.utilities.ExpBackOffCalculator;
import com.vmware.srm.client.utilities.OperationWaiter;
import java.lang.ref.WeakReference;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackOffRetryWrapper<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackOffRetryWrapper.class);
    private static final ScheduledExecutorService SCHED_EXEC = Utils.getScheduledExecutor();
    private final Supplier<Promise<T>> _opProvider;
    private final AtomicReference<ExecuteOnceOpWrapper<Promise<T>>> _resultRef = new AtomicReference<Object>(null);
    private final AtomicBoolean _resetable = new AtomicBoolean(false);
    private volatile ExpBackOffCalculator _calculator;
    private final String _description;

    protected BackOffRetryWrapper(Supplier<Promise<T>> opSupplier, String description) {
        Validate.notNull(opSupplier, (String)"opSupplier");
        this._calculator = new ExpBackOffCalculator();
        this._description = description;
        this._opProvider = () -> {
            LOGGER.info("Invoking retryable op for {}#{}", (Object)this._description, (Object)this.hashCode());
            return ((Promise)opSupplier.get()).thenApply(result -> {
                this._calculator = new ExpBackOffCalculator();
                this._resetable.set(true);
                return result;
            });
        };
    }

    public Promise<T> get() {
        ExecuteOnceOpWrapper myWrapper = null;
        do {
            ExecuteOnceOpWrapper<Promise<T>> current;
            if ((current = this._resultRef.get()) != null) {
                OperationWaiter waiter = current.invoke();
                Exception exc = waiter.getError();
                if (exc == null) {
                    return (Promise)waiter.get();
                }
                return Promises.reject((Exception)exc);
            }
            if (myWrapper != null) continue;
            myWrapper = new ExecuteOnceOpWrapper(this::startOp);
        } while (!this._resultRef.compareAndSet(null, myWrapper));
        return this.executeAndRetry(myWrapper);
    }

    public boolean reset() {
        if (this._resetable.getAndSet(false)) {
            LOGGER.info("Resetting retryable op for {}#{}", (Object)this._description, (Object)this.hashCode());
            this._resultRef.set(null);
            return true;
        }
        return false;
    }

    private Promise<T> startOp() {
        return this._opProvider.get();
    }

    private Promise<T> executeAndRetry(ExecuteOnceOpWrapper<Promise<T>> current) {
        OperationWaiter waiter = current.invoke();
        Exception invokeExc = waiter.getError();
        if (invokeExc != null) {
            this._calculator = new ExpBackOffCalculator();
            this._resultRef.lazySet(null);
            return Promises.reject((Exception)invokeExc);
        }
        Promise result = (Promise)waiter.get();
        return result.onError(innerExc -> {
            if (this.shouldDoBackOff((Exception)innerExc)) {
                long after = this._calculator.nextBackOffInterval();
                LOGGER.warn("Retryable op for {}#{} failed. Resetting after {} milliseconds", new Object[]{this._description, this.hashCode(), after});
                SCHED_EXEC.schedule(new ClearOp(this), after, TimeUnit.MILLISECONDS);
                return;
            }
            this._calculator = new ExpBackOffCalculator();
            this._resultRef.lazySet(null);
        });
    }

    protected abstract boolean shouldDoBackOff(Exception var1);

    private static final class ClearOp
    implements Runnable {
        private final WeakReference<BackOffRetryWrapper<?>> _ref;

        private ClearOp(BackOffRetryWrapper<?> wrapper) {
            this._ref = new WeakReference(wrapper);
        }

        @Override
        public void run() {
            BackOffRetryWrapper wrapper = (BackOffRetryWrapper)this._ref.get();
            if (wrapper == null) {
                return;
            }
            wrapper._resultRef.lazySet(null);
        }
    }
}

