/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.srm.client.topology.impl.vmomi.vlsi.ManagedObjectProxy;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

class StubCreator {
    private static final String NAME_SUFFIX = "_DR_GENERATED";
    private static final MethodInterceptor PROTO_INTERCEPT = new MethodInterceptor(){

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) {
            throw new IllegalStateException("Calling method on a prototype method interceptor.");
        }

        public String toString() {
            return "DR Prototype Method Interceptor";
        }
    };
    private static final ConcurrentMap<Class, Factory> FACTORY_CACHE = new ConcurrentHashMap<Class, Factory>();

    StubCreator() {
    }

    static <T extends ManagedObject> T create(ManagedObjectReference moRef, Class<T> moClass, MethodInterceptor interceptor) {
        Factory factory = FACTORY_CACHE.computeIfAbsent(moClass, StubCreator::createFactory);
        return (T)((ManagedObject)factory.newInstance(new Class[]{ManagedObjectReference.class}, new Object[]{moRef}, new Callback[]{interceptor}));
    }

    private static <T> Factory createFactory(final Class<T> moClass) {
        Enhancer enhancer = new Enhancer(){

            protected void setNamePrefix(String namePrefix) {
                super.setNamePrefix(moClass.getName() + StubCreator.NAME_SUFFIX);
            }
        };
        enhancer.setSuperclass(ManagedObjectProxy.class);
        enhancer.setInterfaces(new Class[]{moClass});
        enhancer.setCallback((Callback)PROTO_INTERCEPT);
        enhancer.setUseFactory(true);
        enhancer.setAttemptLoad(true);
        enhancer.setClassLoader(StubCreator.class.getClassLoader());
        return (Factory)enhancer.create(new Class[]{ManagedObjectReference.class}, new Object[]{null});
    }
}

