/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.utils.Exceptions;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.common.AsyncOpRetryWrapper;
import com.vmware.srm.client.topology.impl.common.SrmNotAuthenticatedException;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.BackOffRetryWrapper;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.LoggingMethodInterceptor;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.LoginHelper;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.ManagedMethodInterceptor;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.StubCreator;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VlsiClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.pc.PropertyCollectorProxy;
import com.vmware.srm.client.utilities.Disposable;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.ClientExceptionTranslator;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.KeyStore;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VmomiServiceImpl<S extends ManagedObject, D extends DataObject>
extends ManagedMethodInterceptor
implements Service<S, D>,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmomiServiceImpl.class);
    private static final Logger PERFORMANCE_LOGGER = LoggerFactory.getLogger((String)"com.vmware.srm.client.performance.vmomi");
    private static final int RETRIES = 2;
    private static final String LOGIN_STAMP = "srm.client.vmomiservice.loginStamp";
    private static final String START_TIME_CONTEXT_KEY = "srm.client.vmomiservice.invstarttime";
    private static final String CONNECT_FAILED_KEY = "serviceImpl.connectFailed";
    private final URI _server;
    private final HttpConfiguration _httpConfiguration;
    private final String _serverDescription;
    private final VmodlContextInitializer _vmodlInitializer;
    private final ManagedObjectReference _siRef;
    private final BackOffRetryWrapper<D> _getContentWrapper;
    private final BackOffRetryWrapper<VmodlVersion> _negotiateVersionWrapper;
    private final AsyncOpRetryWrapper<Client> _getVmomiClient;
    private final LoginHelper _loginHelper;
    private final TokenProvider _provider;

    public static boolean shouldDoBackOff(Exception exc) {
        if ((exc = ClientExceptionTranslator.translate((Exception)exc)) instanceof SslException) {
            return false;
        }
        return exc instanceof ConnectionException || exc instanceof TransportProtocolException || exc instanceof UnexpectedStatusCodeException;
    }

    VmomiServiceImpl(URI server, HttpConfiguration httpConfiguration, VmodlContextInitializer vmodlInitializer, TokenProvider provider, ManagedObjectReference siRef, String serverDescription) {
        super(server, serverDescription);
        if (server == null) {
            throw new IllegalArgumentException("server");
        }
        if (httpConfiguration == null) {
            throw new IllegalArgumentException("httpConfiguration");
        }
        if (vmodlInitializer == null) {
            throw new IllegalArgumentException("vmodlContextInitializer");
        }
        if (siRef == null) {
            throw new IllegalArgumentException("serviceInstance");
        }
        this._server = server;
        this._httpConfiguration = httpConfiguration;
        this._provider = provider;
        this._siRef = siRef;
        this._serverDescription = serverDescription;
        try {
            vmodlInitializer.waitToComplete();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        this._vmodlInitializer = vmodlInitializer;
        this._getContentWrapper = new BackOffRetryWrapper<D>(() -> this.retrieveContent(this.createStub(siRef)), "'RetrieveContent' for " + serverDescription + " at " + server.getHost()){

            @Override
            protected boolean shouldDoBackOff(Exception exc) {
                return VmomiServiceImpl.shouldDoBackOff(exc);
            }
        };
        this._negotiateVersionWrapper = new BackOffRetryWrapper<VmodlVersion>(this::getVersionInternal, "'NegotiateVersion' for " + serverDescription + " at " + server.getHost()){

            @Override
            protected boolean shouldDoBackOff(Exception exc) {
                return VmomiServiceImpl.shouldDoBackOff(exc);
            }
        };
        Supplier supplier = () -> this._negotiateVersionWrapper.get().thenApply(version -> Client.Factory.createClient((URI)this._server, (Class)version.getVersionClass(), (VmodlContext)this._vmodlInitializer.getVmodlContext(), (ClientConfiguration)VlsiClientUtils.createClientConfig(this._httpConfiguration)));
        this._getVmomiClient = new AsyncOpRetryWrapper(supplier);
        this._loginHelper = new LoginHelper(){

            @Override
            Promise<Void> login() {
                return VmomiServiceImpl.this._getContentWrapper.get().thenCompose(x$0 -> VmomiServiceImpl.this.doLogin(x$0));
            }
        };
    }

    @Override
    public URI getServerUrl() {
        return this._server;
    }

    @Override
    public <T extends ManagedObject> T createStub(ManagedObjectReference moRef) {
        VmodlContext context = this._vmodlInitializer.getVmodlContext();
        ManagedObjectType moType = VlsiClientUtils.getType(moRef, context.getVmodlTypeMap());
        Class moBackingClass = moType.getTypeClass();
        return StubCreator.create(moRef, moBackingClass, this);
    }

    @Override
    public Promise<S> getServiceInstance() {
        return this.getContent().thenApply(content -> {
            ManagedObjectReference siRef = new ManagedObjectReference(this._siRef.getType(), this._siRef.getValue(), this.getServerGuid(content));
            return this.createStub(siRef);
        });
    }

    @Override
    public Promise<D> getContent() {
        return this._getContentWrapper.get();
    }

    public TokenProvider getTokenProvider() {
        return this._provider;
    }

    public void dispose() {
        this.shutdown();
    }

    public String toString() {
        return String.format("%s at %s", this._serverDescription, this.getServerUrl());
    }

    public KeyStore getTrustStore() {
        return this._httpConfiguration.getTrustStore();
    }

    public ThumbprintVerifier getVerifier() {
        return this._httpConfiguration.getThumbprintVerifier();
    }

    public VmodlTypeMap getTypeMap() {
        return this._vmodlInitializer.getVmodlContext().getVmodlTypeMap();
    }

    VmodlVersionMap getVersionMap() {
        return this._vmodlInitializer.getVmodlContext().getVmodlVersionMap();
    }

    @Override
    public final Promise<VmodlVersion> getVersion() {
        return this._negotiateVersionWrapper.get();
    }

    protected abstract Promise<VmodlVersion> negotiateVersion();

    protected abstract String getServerGuid(D var1);

    protected abstract Promise<D> retrieveContent(S var1);

    protected abstract Promise<Void> login(D var1, String var2);

    protected abstract Promise<Void> logout(D var1);

    @Override
    Promise<? extends ManagedObject> createDelegateStub(ManagedObjectReference moRef) {
        VmodlContext context = this._vmodlInitializer.getVmodlContext();
        return this._getVmomiClient.get().thenApply(client -> {
            Object mo = VlsiClientUtils.createStub(moRef, client, context.getVmodlTypeMap());
            if (mo instanceof PropertyCollector) {
                ManagedObjectReference siRef = new ManagedObjectReference(this._siRef.getType(), this._siRef.getValue(), mo._getRef().getServerGuid());
                return new PropertyCollectorProxy((PropertyCollector)mo, siRef);
            }
            return mo;
        });
    }

    @Override
    Promise<Boolean> shouldRetryRequest(ManagedObject mo, Method method, Map<String, Object> context, Exception err, int failedTries) {
        if (failedTries > 2) {
            LOGGER.warn("Max retry count exceeded for '{}'.", (Object)this);
            return Promises.resolve((Object)false);
        }
        if (!this.retryOnError(err)) {
            return Promises.resolve((Object)false);
        }
        if (this._provider == null || !this._provider.isTokenAvailable()) {
            return Promises.resolve((Object)false);
        }
        Long loginStamp = (Long)context.get(LOGIN_STAMP);
        if (loginStamp == null) {
            String msg = "No login stamp in context for '" + method + "'";
            return Promises.reject((Exception)new IllegalArgumentException(msg));
        }
        return this._loginHelper.retryLogin(loginStamp).thenApply(unused -> true);
    }

    protected boolean retryOnError(Exception err) {
        return err instanceof NotAuthenticated;
    }

    @Override
    void beforeMethodInvoked(ManagedObject mo, Method method, Object[] args, Map<String, Object> context) {
        long currentStamp = this._loginHelper.getCurrentStamp();
        context.put(LOGIN_STAMP, currentStamp);
        LocalDateTime startTime = LocalDateTime.now();
        context.put(START_TIME_CONTEXT_KEY, startTime);
    }

    @Override
    Object afterMethodInvoked(ManagedObject mo, Method method, Object[] args, Map<String, Object> context, Object result) {
        if (PERFORMANCE_LOGGER.isDebugEnabled()) {
            Duration diff = Duration.between((LocalDateTime)context.get(START_TIME_CONTEXT_KEY), LocalDateTime.now());
            PERFORMANCE_LOGGER.debug("{} ms -> [{}] successful invocation of {} {}", new Object[]{diff.toMillis(), this, mo._getRef(), method});
        } else {
            PERFORMANCE_LOGGER.info("Successfully completed invocation of '{}' on '{}'", (Object)method.getName(), (Object)mo._getRef());
        }
        return result;
    }

    @Override
    Throwable afterMethodInvoked(ManagedObject mo, Method method, Object[] args, Map<String, Object> context, Throwable error) {
        if (PERFORMANCE_LOGGER.isDebugEnabled()) {
            Duration diff = Duration.between((LocalDateTime)context.get(START_TIME_CONTEXT_KEY), LocalDateTime.now());
            PERFORMANCE_LOGGER.debug("{} ms -> [{}] FAILED invocation of {} {}", new Object[]{diff.toMillis(), this, mo._getRef(), method, error});
        } else {
            PERFORMANCE_LOGGER.info("Invocation of '{}' on '{}' failed with '{}'.", new Object[]{method.getName(), mo._getRef(), error});
        }
        if (error instanceof Exception && VmomiServiceImpl.shouldDoBackOff((Exception)error) && this._getContentWrapper.reset()) {
            this._getContentWrapper.get();
        }
        return this.transformException(error);
    }

    @Override
    void onShutdown() {
        Promise logout;
        try {
            logout = this.getContent().thenCompose(this::logout);
        }
        catch (Exception exc) {
            LOGGER.error("'logout' for '{}' failed: ", (Object)this, (Object)exc);
            logout = Promises.resolve(null);
        }
        this._getVmomiClient.get().thenCombine(logout.materialize(), (client, unused) -> {
            client.shutdown();
            return null;
        });
    }

    private String getFixedMessage(Throwable error) {
        return L10N.localize(CONNECT_FAILED_KEY, this._serverDescription, this.getServerUrl(), error.getLocalizedMessage());
    }

    private Exception fixStackTrace(Exception toFix, Throwable origErr) {
        toFix.setStackTrace(origErr.getStackTrace());
        return toFix;
    }

    private Promise<VmodlVersion> getVersionInternal() {
        Promise<VmodlVersion> result;
        try {
            result = this.negotiateVersion();
        }
        catch (Exception exc) {
            LOGGER.warn("Calling 'negotiateVersion' failed: ", (Throwable)exc);
            return Promises.reject((Exception)exc);
        }
        return result.materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve((Object)pr.getResult());
            }
            Exception exc = ClientExceptionTranslator.translate((Exception)pr.getError());
            return Promises.reject((Exception)Exceptions.wrap((Throwable)this.transformException(exc)));
        });
    }

    protected <T extends ManagedObject> Promise<T> createFreeStub(ManagedObjectReference moRef) {
        return this.createDelegateStub(moRef).thenApply(stub -> {
            VmodlContext context = this._vmodlInitializer.getVmodlContext();
            ManagedObjectType moType = VlsiClientUtils.getType(moRef, context.getVmodlTypeMap());
            Class moBackingClass = moType.getTypeClass();
            Object result = StubCreator.create(moRef, moBackingClass, new LoggingMethodInterceptor((ManagedObject)stub, this._server, this._serverDescription));
            VlsiClientUtils.setOperationId((Stub)result);
            return result;
        });
    }

    protected <T extends ManagedObject> Promise<T> createLoginStub(ManagedObjectReference moRef) {
        return this.createFreeStub(moRef).thenApply(stub -> {
            VlsiClientUtils.setAuthenticationData((Stub)stub, this._provider.getToken(), this._provider.getPrivateKey());
            return stub;
        });
    }

    public final Promise<Client> getVmomiClient() {
        return this._getVmomiClient.get();
    }

    private Promise<Void> doLogin(D content) {
        return this.login(content, L10N.getLocaleId()).materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve((Object)pr.getResult());
            }
            String msg = L10N.localize("loginFailed.msg", this.toString());
            return Promises.reject((Exception)new Service.LoginFailedException(msg, pr.getError()));
        });
    }

    private Throwable transformException(Throwable error) {
        ConnectionException fixedExc = null;
        if (error instanceof ConnectionException) {
            String fixedMsg = this.getFixedMessage((Throwable)error);
            fixedExc = new ConnectionException(fixedMsg, error.getCause());
        } else if (error instanceof SslException) {
            String fixedMsg = this.getFixedMessage((Throwable)error);
            fixedExc = new SslException(fixedMsg, error.getCause());
        } else if (error instanceof TransportProtocolException) {
            String fixedMsg = this.getFixedMessage((Throwable)error);
            fixedExc = new TransportProtocolException(fixedMsg, error.getCause());
        } else if (error instanceof UnexpectedStatusCodeException) {
            String fixedMsg = this.getFixedMessage((Throwable)error);
            fixedExc = new ConnectionException(fixedMsg, error);
        } else if (error instanceof NotAuthenticated) {
            error = new SrmNotAuthenticatedException((NotAuthenticated)error);
        }
        if (fixedExc == null) {
            return error;
        }
        return this.fixStackTrace((Exception)fixedExc, (Throwable)error);
    }
}

