/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionListener
implements HttpSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionListener.class);

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        session.setMaxInactiveInterval(30);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        String sessionIndex;
        String sessionIdAlias;
        HttpSession session = se.getSession();
        TopologyImpl topology = SessionWrapper.getTopology(session);
        if (topology != null) {
            try {
                topology.destroy();
            }
            catch (Exception exc) {
                LOGGER.warn("Failed to destroy topology.", (Throwable)exc);
            }
        }
        if ((sessionIdAlias = SessionWrapper.getSessionIdAlias(session)) != null) {
            LOGGER.info("Session {} ended.", (Object)sessionIdAlias);
        }
        if ((sessionIndex = SessionWrapper.getSessionIndex(session)) != null) {
            SessionWrapper.removeSession(sessionIndex);
        }
    }
}

