/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.srm.client.infrastructure.authentication.data.ServerGuidData;
import com.vmware.srm.client.infrastructure.authentication.data.SiteAuthenticatedData;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.utilities.Exceptions;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;

@DrInputType(value=ServerGuidData.class)
public class SiteAuthenticatedDataHandler
implements FreeRequestHandler {
    @Override
    public Promise<SiteAuthenticatedData> handle(DrData input, FreeRequestContext context) {
        ServerGuidData guidData = (ServerGuidData)input;
        String pairServerGuid = guidData.getPairServerGuid();
        Object view = context.view();
        return this.checkVcSite((ServersView)view, pairServerGuid);
    }

    private Promise<SiteAuthenticatedData> checkVcSite(ServersView view, String pairServerGuid) {
        return view.getServerBy(pairServerGuid).materialize().thenApply(serverResult -> {
            if (serverResult.isSuccessful()) {
                if (serverResult.getResult() instanceof ExtensionServer) {
                    ExtensionServer server = (ExtensionServer)serverResult.getResult();
                    return new SiteAuthenticatedData(server.vc().url().getHost(), true);
                }
                Server server = (Server)serverResult.getResult();
                return new SiteAuthenticatedData(server.url().getHost(), true);
            }
            if (serverResult.getError() instanceof ExtensionServersView.ServerByPairSetupException) {
                ExtensionServersView.ServerByPairSetupException sbpsExc = (ExtensionServersView.ServerByPairSetupException)serverResult.getError();
                for (PairSetup ps : sbpsExc.getPairSetups()) {
                    if (!(sbpsExc.getCause(ps) instanceof NotAuthenticated)) continue;
                    return new SiteAuthenticatedData(ps.pairVcName(), false);
                }
                throw new RuntimeException(L10N.localize("noEligiblePairSetup", pairServerGuid));
            }
            throw Exceptions.getRuntimeException((Throwable)serverResult.getError());
        });
    }
}

