/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authorization;

import com.vmware.srm.client.infrastructure.authorization.data.EntityPrivilege;
import com.vmware.srm.client.infrastructure.authorization.data.PrivilegeAvailability;
import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.utils.TopologyUtil;
import com.vmware.srm.client.infrastructure.utils.VcVmodlUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.client.vmomi.vc.VcService;
import com.vmware.srm.client.utilities.IndexUtils;
import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegeCheckHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivilegeCheckHelper.class);
    private static final PrivilegeAvailability[] emptyPrivAvailabilities = new PrivilegeAvailability[0];

    public static Promise<List<EntityPrivilege>> hasSrmPrivilegeOnEntities(SrmServersView view, String[] privilegeIds, ManagedObjectReference ... moRefs) {
        Map serverGuidToMoRefMap = IndexUtils.indexByGuid(Arrays.asList(moRefs));
        return Streams.from(serverGuidToMoRefMap.values()).flatMap(moRefList -> PrivilegeCheckHelper.hasSrmPrivilegeOnEntitiesInt(view, privilegeIds, moRefList)).reduce(new ArrayList(), (list, next) -> {
            list.add(next);
            return list;
        });
    }

    public static Stream<EntityPrivilege> hasSrmPrivilegeOnEntitiesInt(SrmServersView view, String[] privilegeIds, List<ManagedObjectReference> moRefs) {
        PrivilegeCheckHelper.validateInput(privilegeIds, moRefs.toArray(new ManagedObjectReference[moRefs.size()]));
        Promise rolesPromise = TopologyUtil.getVc(view, moRefs.get(0), false).thenApply(Server::service).thenCompose(Service::getContent).thenCompose(vcSiContent -> PCUtil.retrieveProperty((ServersView)view, vcSiContent.authorizationManager, "roleList"));
        HashSet<ManagedObjectReference> entities = new HashSet<ManagedObjectReference>(moRefs);
        Promise<PcResult> effectiveRolesPromise = PCUtil.retrieveProperties((ServersView)view, entities, "effectiveRole");
        return effectiveRolesPromise.thenCombine(rolesPromise, (pcResult, rolesList) -> entities.stream().map(moRef -> {
            int[] effectiveRole = (int[])pcResult.tryGetProperty((ManagedObjectReference)moRef, "effectiveRole");
            return new EntityPrivilege((ManagedObjectReference)moRef, PrivilegeCheckHelper.checkPrivileges(effectiveRole, rolesList, privilegeIds));
        }).collect(Collectors.toList())).materialize().thenApply(result -> result.isSuccessful() ? (List<EntityPrivilege>)result.getResult() : PrivilegeCheckHelper.createErrorResult(moRefs, result.getError())).toStream().flatMap(Streams::from);
    }

    public static Promise<EntityPrivilege> hasSrmPrivilegeOnEntity(SrmServersView view, String[] privilegeIds, ManagedObjectReference moRef) {
        PrivilegeCheckHelper.validateInput(privilegeIds, moRef);
        return PrivilegeCheckHelper.hasSrmPrivilegeOnEntities(view, privilegeIds, moRef).thenApply(result -> (EntityPrivilege)result.get(0));
    }

    public static Promise<List<EntityPrivilege>> hasVcPrivilegeOnEntities(VcServer vcServer, String[] privilegeIds, ManagedObjectReference ... moRefs) {
        PrivilegeCheckHelper.validateInput(privilegeIds, moRefs);
        return ((VcService)vcServer.service()).getContent().thenCompose(vcSiContent -> {
            AuthorizationManager authorizationManager = (AuthorizationManager)((VcService)vcServer.service()).createStub(vcSiContent.getAuthorizationManager());
            return PrivilegeCheckHelper.getUserSession(vcServer, vcSiContent).thenCompose(userSession -> {
                FuturePromise privilegesFuture = new FuturePromise();
                authorizationManager.hasPrivilegeOnEntities(moRefs, userSession.key, privilegeIds, (Future)privilegesFuture);
                return privilegesFuture.thenApply(vcEntityPrivileges -> Arrays.stream(vcEntityPrivileges).map(item -> {
                    EntityPrivilege entityPriv = new EntityPrivilege();
                    entityPriv.setMoRef(new MoRefData(item.getEntity()));
                    entityPriv.setPrivilegeAvailabilities(item.getPrivAvailability());
                    return entityPriv;
                }).collect(Collectors.toList()));
            });
        }).materialize().thenApply(result -> result.isSuccessful() ? (List<EntityPrivilege>)result.getResult() : PrivilegeCheckHelper.createErrorResult(Arrays.asList(moRefs), result.getError()));
    }

    public static Promise<EntityPrivilege> hasVcPrivilegeOnEntity(VcServer vcServer, String[] privilegeIds, ManagedObjectReference moRef) {
        ManagedObjectReference patchedMoRef = PrivilegeCheckHelper.patchServiceInstance(moRef);
        PrivilegeCheckHelper.validateInput(privilegeIds, patchedMoRef);
        return ((VcService)vcServer.service()).getContent().thenCompose(vcSiContent -> {
            AuthorizationManager authorizationManager = (AuthorizationManager)((VcService)vcServer.service()).createStub(vcSiContent.getAuthorizationManager());
            return PrivilegeCheckHelper.getUserSession(vcServer, vcSiContent).thenCompose(userSession -> {
                FuturePromise privilegesFuture = new FuturePromise();
                if (userSession == null) {
                    return Promises.resolve((Object)new EntityPrivilege(moRef, emptyPrivAvailabilities));
                }
                authorizationManager.hasPrivilegeOnEntity(patchedMoRef, userSession.key, privilegeIds, (Future)privilegesFuture);
                return privilegesFuture.thenApply(privilegeFlags -> PrivilegeCheckHelper.constructResult(privilegeIds, moRef, privilegeFlags));
            });
        }).materialize().thenApply(result -> result.isSuccessful() ? (EntityPrivilege)result.getResult() : PrivilegeCheckHelper.createErrorResult(moRef, result.getError()));
    }

    public static Promise<List<EntityPrivilege>> hasHmsPrivilegeOnEntities(HmsServer hmsServer, String[] privilegeIds, ManagedObjectReference ... hmsMoRefs) {
        VcServer vcServer = hmsServer.vc();
        ManagedObjectReference vcRootFolder = VcVmodlUtil.getRootFolder(vcServer.guid());
        PrivilegeCheckHelper.validateInput(privilegeIds, vcRootFolder);
        return PrivilegeCheckHelper.hasVcPrivilegeOnEntity(vcServer, privilegeIds, vcRootFolder).thenApply(entityPrivilege -> Arrays.stream(hmsMoRefs).map(hmsMoRef -> new EntityPrivilege(new MoRefData(entityPrivilege.getMoRef().getType(), entityPrivilege.getMoRef().getValue(), hmsMoRef.getServerGuid()), entityPrivilege.getPrivilegeAvailabilities(), entityPrivilege.getError())).collect(Collectors.toList()));
    }

    public static List<EntityPrivilege> createErrorResult(MoRefData[] moRefs, Exception ex) {
        return PrivilegeCheckHelper.createErrorResult(Arrays.asList(moRefs), ex);
    }

    public static List<EntityPrivilege> createErrorResult(List<ManagedObjectReference> moRefs, Exception ex) {
        ArrayList<EntityPrivilege> result = new ArrayList<EntityPrivilege>(moRefs.size());
        for (ManagedObjectReference moRef : moRefs) {
            result.add(new EntityPrivilege(moRef, emptyPrivAvailabilities, ex));
        }
        return result;
    }

    public static EntityPrivilege createErrorResult(ManagedObjectReference moRef, Exception ex) {
        return new EntityPrivilege(moRef, emptyPrivAvailabilities, ex);
    }

    private static EntityPrivilege constructResult(String[] privilegeIds, ManagedObjectReference moRef, boolean[] privilegeFlags) {
        if (privilegeFlags == null) {
            return new EntityPrivilege(moRef, emptyPrivAvailabilities);
        }
        PrivilegeAvailability[] privilegeAvailabilityList = new PrivilegeAvailability[privilegeIds.length];
        for (int i = 0; i < privilegeIds.length; ++i) {
            privilegeAvailabilityList[i] = new PrivilegeAvailability(privilegeIds[i], privilegeFlags[i]);
        }
        return new EntityPrivilege(moRef, privilegeAvailabilityList);
    }

    private static ManagedObjectReference patchServiceInstance(ManagedObjectReference moRef) {
        if (moRef != null && moRef.getType().equals("ServiceInstance")) {
            return VcVmodlUtil.getRootFolder(moRef.getServerGuid());
        }
        return moRef;
    }

    private static FuturePromise<UserSession> getUserSession(VcServer vcServer, ServiceInstanceContent vcSiContent) {
        SessionManager sessionManager = (SessionManager)((VcService)vcServer.service()).createStub(vcSiContent.getSessionManager());
        FuturePromise userSessionFuture = new FuturePromise();
        sessionManager.getCurrentSession((Future)userSessionFuture);
        return userSessionFuture;
    }

    private static PrivilegeAvailability[] checkPrivileges(int[] effectiveRole, AuthorizationManager.Role[] roles, String[] privilegeIds) {
        if (effectiveRole == null) {
            return emptyPrivAvailabilities;
        }
        HashMap<String, Boolean> availabilityMap = new HashMap<String, Boolean>();
        for (int roleId : effectiveRole) {
            AuthorizationManager.Role role = PrivilegeCheckHelper.findRole(roleId, roles);
            if (role == null) {
                LOGGER.warn("Unknown role: {}.", (Object)roleId);
                continue;
            }
            List<String> rolePrivileges = Arrays.asList(role.getPrivilege());
            for (String privilege : privilegeIds) {
                Boolean isGranted = (Boolean)availabilityMap.get(privilege);
                if (isGranted != null && isGranted.booleanValue()) continue;
                availabilityMap.put(privilege, rolePrivileges.contains(privilege));
            }
        }
        List<PrivilegeAvailability> result = Arrays.stream(privilegeIds).map(pid -> {
            Boolean granted = (Boolean)availabilityMap.get(pid);
            return new PrivilegeAvailability((String)pid, granted == null ? false : granted);
        }).collect(Collectors.toList());
        return result.toArray(new PrivilegeAvailability[result.size()]);
    }

    private static AuthorizationManager.Role findRole(int roleToFind, AuthorizationManager.Role[] roles) {
        return Arrays.stream(roles).filter(role -> role.getRoleId() == roleToFind).findFirst().orElse(null);
    }

    private static void validateInput(String[] privilegeIds, ManagedObjectReference ... moRefs) {
        Validate.notEmpty((Object[])privilegeIds, (String)"privilegeIds");
        Validate.notEmpty((Object[])moRefs, (String)"moRefs");
        String serverGuid = moRefs[0].getServerGuid();
        for (ManagedObjectReference moRef : moRefs) {
            Validate.isTrue((boolean)moRef.getServerGuid().equals(serverGuid), (String)"Entities from different servers encountered.");
        }
    }
}

