/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.dataHandlers;

import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.commonData.StringDrData;
import com.vmware.srm.client.infrastructure.dataHandlers.data.PairSitesNames;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrDataList;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.PromiseResult;
import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DrInputType(value=StringDrData.class)
public class AllSrmSitesNameDataHandler
implements FreeRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllSrmSitesNameDataHandler.class);

    @Override
    public Promise<? extends DrData> handle(DrData input, FreeRequestContext context) {
        StringDrData vcGuidData = (StringDrData)input;
        SrmServersView srmServersView = (SrmServersView)context.view();
        return srmServersView.getSrmsFor(vcGuidData.getValue()).flatMap(this::toPairSitesNames).filter(Objects::nonNull).collect().thenApply(DrDataList::new);
    }

    private Publisher<? extends PairSitesNames> toPairSitesNames(SrmServer srmServer) {
        Promise srmNamePromise = srmServer.getName();
        return srmServer.getPair().materialize().thenCombine(srmNamePromise, (pairResult, srmName) -> this.toPairSitesNames(srmServer, (PromiseResult<SrmPairSetup>)pairResult, (String)srmName));
    }

    private PairSitesNames toPairSitesNames(SrmServer srmServer, PromiseResult<SrmPairSetup> pairResult, String srmName) {
        if (pairResult.isSuccessful()) {
            PairSitesNames result = new PairSitesNames();
            result.setLocalSiteName(srmName);
            result.setLocalSiteRef(new MoRefData("DrServiceInstance", "DrServiceInstance", srmServer.guid()));
            SrmPairSetup pairSetup = (SrmPairSetup)pairResult.getResult();
            if (pairSetup == null) {
                return null;
            }
            result.setRemoteSiteName(pairSetup.pairServerName());
            result.setRemoteSiteRef(new MoRefData(pairSetup.pairServerVmomiRef()));
            return result;
        }
        LOGGER.error("Couldn't retrieve pair SRM for {}", (Object)srmServer.guid(), (Object)pairResult.getError());
        return null;
    }
}

