/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.dataHandlers;

import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.SrmRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.SrmRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.FOLDER;
import com.vmware.vim.constants.dr.recovery.RECOVERY_PLAN;
import com.vmware.vim.constants.dr.replication.VM_PROTECTION_GROUP;

@DrInputType(value=MoRefData.class)
public class PeerObjectHandler
implements SrmRequestHandler {
    @Override
    public Promise<? extends DrData> handle(DrData input, SrmRequestContext context) {
        MoRefData moRef = (MoRefData)input;
        String type = moRef.getType();
        if (type.equals("DrReplicationFolder") || type.equals("DrRecoveryFolder")) {
            moRef = new MoRefData("DrFolder", moRef.getValue(), moRef.getServerGuid());
        }
        return PCUtil.retrieveProperty(context.view(), moRef, this.getPeerProperty(moRef)).thenApply(moRefPeer -> new MoRefData(type, ((ManagedObjectReference)moRefPeer).getValue(), ((ManagedObjectReference)moRefPeer).getServerGuid()));
    }

    private String getPeerProperty(ManagedObjectReference moRef) {
        switch (moRef.getType()) {
            case "DrReplicationVmProtectionGroup": 
            case "DrReplicationStorageProfileProtectionGroup": {
                return VM_PROTECTION_GROUP.PEER_.GROUP;
            }
            case "DrRecoveryRecoveryPlan": {
                return RECOVERY_PLAN.PEER_.PLAN;
            }
            case "DrFolder": {
                return FOLDER.PEER_.FOLDER;
            }
        }
        throw new IllegalArgumentException("Unknown moRef type");
    }
}

