/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.logging;

import com.vmware.srm.client.utilities.AsyncConsumer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.async.InternalAsyncUtil;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;

@Plugin(name="DrAsync", category="core", elementType="appender", printObject=true)
public class DrAsyncAppender
extends AbstractAppender {
    private final ArrayList<AppenderControl> _appenders;
    private final Configuration _config;
    private final AppenderRef[] _appenderRefs;
    private final AsyncConsumer<LogEvent> _dispatcher;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private DrAsyncAppender(String name, Filter filter, boolean ignoreExceptions, Property[] properties, Configuration config, AppenderRef[] appenderRefs) {
        super(name, filter, null, ignoreExceptions, properties);
        this._config = config;
        this._appenderRefs = appenderRefs;
        this._appenders = new ArrayList(this._appenderRefs.length);
        this._dispatcher = new AsyncConsumer<LogEvent>(this::callAppenders){

            protected void handleError(Throwable t, LogEvent item) {
                t.printStackTrace();
            }

            protected void endOfBatch(LogEvent event) {
                super.endOfBatch((Object)event);
                if (event != null) {
                    event.setEndOfBatch(true);
                }
            }
        };
    }

    public void start() {
        Map map = this._config.getAppenders();
        for (AppenderRef appenderRef : this._appenderRefs) {
            Appender appender = (Appender)map.get(appenderRef.getRef());
            if (appender != null) {
                this._appenders.add(new AppenderControl(appender, appenderRef.getLevel(), appenderRef.getFilter()));
                continue;
            }
            LOGGER.error("No appender named {} was configured", (Object)appenderRef);
        }
        super.start();
    }

    public void append(LogEvent event) {
        if (!this.isStarted()) {
            throw new IllegalStateException("AsyncAppender " + this.getName() + " is not active");
        }
        Log4jLogEvent memento = Log4jLogEvent.createMemento((LogEvent)event, (boolean)false);
        InternalAsyncUtil.makeMessageImmutable((Message)event.getMessage());
        this._dispatcher.accept((Object)memento);
    }

    private void callAppenders(LogEvent event) {
        for (AppenderControl ac : this._appenders) {
            try {
                ac.callAppender(event);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<DrAsyncAppender> {
        @PluginElement(value="AppenderRef")
        @Required(message="No appender references provided to AsyncAppender")
        private AppenderRef[] appenderRefs;
        @PluginBuilderAttribute
        @Required(message="No name provided for AsyncAppender")
        private String name;
        @PluginConfiguration
        private Configuration configuration;

        public Builder setAppenderRefs(AppenderRef[] appenderRefs) {
            this.appenderRefs = appenderRefs;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public DrAsyncAppender build() {
            return new DrAsyncAppender(this.name, this.getFilter(), true, this.getPropertyArray(), this.configuration, this.appenderRefs);
        }
    }
}

