/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.providers;

import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.SERVICE_INSTANCE;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitesNameProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SitesNameProvider.class);

    public static List<PropertyCollector.PropertySpec> getPropertySpecs() {
        ArrayList<PropertyCollector.PropertySpec> result = new ArrayList<PropertyCollector.PropertySpec>();
        result.add(PCUtil.createPropertySpec("DrServiceInstance", SERVICE_INSTANCE.CONTENT_.SITE_NAME));
        result.add(PCUtil.createPropertySpec("DrSiteRemoteSite", "name", "uuid"));
        return result;
    }

    public static PropertyCollector.ObjectSpec getObjectSpecs(ManagedObjectReference serviceInstanceRef) {
        ObjectSpecBuilder builder = new ObjectSpecBuilder(serviceInstanceRef, true);
        builder.traverseTo(SERVICE_INSTANCE.CONTENT_.SITE_MANAGER, true).traverseTo("remoteSiteList");
        return builder.build();
    }

    public static SitesNamesResult getResult(PcResult pcResult) {
        SitesNamesResult result = new SitesNamesResult();
        for (ManagedObjectReference moRef : pcResult.getMoRefs()) {
            if ("DrServiceInstance".equals(moRef.getType())) {
                result.localSiteName = (String)pcResult.getProperty(moRef, SERVICE_INSTANCE.CONTENT_.SITE_NAME);
                result.localSiteRef = new MoRefData(moRef);
                LOGGER.trace("Local site [{}], name: {}.", (Object)moRef, (Object)result.localSiteName);
                continue;
            }
            if (!"DrSiteRemoteSite".equals(moRef.getType())) continue;
            result.remoteSiteName = (String)pcResult.getProperty(moRef, "name");
            result.remoteSiteRef = new MoRefData(ClientUtils.createMoRef((String)"DrServiceInstance", (String)"DrServiceInstance", (String)((String)pcResult.getProperty(moRef, "uuid"))));
            LOGGER.trace("Remote site [{}], name: {}.", (Object)moRef, (Object)result.remoteSiteName);
        }
        return result;
    }

    public static final class SitesNamesResult {
        public String localSiteName = null;
        public String remoteSiteName = null;
        public MoRefData localSiteRef = null;
        public MoRefData remoteSiteRef = null;
    }
}

