/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.context.impl;

import com.vmware.srm.client.infrastructure.requestHandlers.context.DrRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FilterSortPageContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContextWithFSP;
import com.vmware.srm.client.infrastructure.requestHandlers.context.GetTopology;
import com.vmware.srm.client.infrastructure.requestHandlers.context.HmsRequestContextWithFSP;
import com.vmware.srm.client.infrastructure.requestHandlers.context.SrmRequestContextWithFSP;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.FilterData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.PageData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.SortData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;

public abstract class RequestContextImpl {
    private final Topology _topology;
    private final ExtensionServersView _view;
    private final SrmServer _srm;
    private final SrmPairSetup _srmPairSetup;
    private final HmsServer _hms;
    private final HmsPairSetup _hmsPairSetup;
    private final FilterData _filterData;
    private final SortData _sortData;
    private final PageData _pageData;
    private final _SrmContext _srmContext;
    private final _HmsContext _hmsContext;
    private final _FreeContext _freeContext = new _FreeContext();

    public RequestContextImpl(Topology topology, ExtensionServersView view, SrmServer srm, SrmPairSetup srmPairSetup, HmsServer hms, HmsPairSetup hmsPairSetup, FilterData filterData, SortData sortData, PageData pageData) {
        this._topology = topology;
        this._view = view;
        this._srm = srm;
        this._srmPairSetup = srmPairSetup;
        this._hms = hms;
        this._hmsPairSetup = hmsPairSetup;
        this._filterData = filterData;
        this._sortData = sortData;
        this._pageData = pageData;
        this._srmContext = new _SrmContext();
        this._hmsContext = new _HmsContext();
    }

    public RequestContextImpl(Topology topology, ExtensionServersView view, SrmServer srm, SrmPairSetup srmPairSetup, FilterData filterData, SortData sortData, PageData pageData) {
        this._topology = topology;
        this._view = view;
        this._srm = srm;
        this._srmPairSetup = srmPairSetup;
        this._hms = null;
        this._hmsPairSetup = null;
        this._filterData = filterData;
        this._sortData = sortData;
        this._pageData = pageData;
        this._srmContext = new _SrmContext();
        this._hmsContext = null;
    }

    public RequestContextImpl(Topology topology, ExtensionServersView view, HmsServer hms, HmsPairSetup hmsPairSetup, FilterData filterData, SortData sortData, PageData pageData) {
        this._topology = topology;
        this._view = view;
        this._srm = null;
        this._srmPairSetup = null;
        this._hms = hms;
        this._hmsPairSetup = hmsPairSetup;
        this._filterData = filterData;
        this._sortData = sortData;
        this._pageData = pageData;
        this._srmContext = null;
        this._hmsContext = new _HmsContext();
    }

    public RequestContextImpl(Topology topology, ExtensionServersView view, HmsServer hms, FilterData filterData, SortData sortData, PageData pageData) {
        this._topology = topology;
        this._view = view;
        this._srm = null;
        this._srmPairSetup = null;
        this._hms = hms;
        this._hmsPairSetup = null;
        this._filterData = filterData;
        this._sortData = sortData;
        this._pageData = pageData;
        this._srmContext = null;
        this._hmsContext = null;
    }

    public RequestContextImpl(Topology topology, ExtensionServersView view, FilterData filterData, SortData sortData, PageData pageData) {
        this._topology = topology;
        this._view = view;
        this._srm = null;
        this._srmPairSetup = null;
        this._hms = null;
        this._hmsPairSetup = null;
        this._filterData = filterData;
        this._sortData = sortData;
        this._pageData = pageData;
        this._srmContext = null;
        this._hmsContext = null;
    }

    public SrmRequestContextWithFSP asSrmContext() {
        if (this._srmContext == null) {
            throw new DrRequestContext.ContextNotAvailable("SRM context is not available.");
        }
        return this._srmContext;
    }

    public HmsRequestContextWithFSP asHmsContext() {
        if (this._hmsContext == null) {
            throw new DrRequestContext.ContextNotAvailable("HMS context is not available.");
        }
        return this._hmsContext;
    }

    public FreeRequestContextWithFSP asFreeContext() {
        return this._freeContext;
    }

    public abstract <T extends DrData> Promise<T> dispatch(String var1, DrData var2);

    private final class _FreeContext
    extends Impl<ServersView>
    implements FreeRequestContextWithFSP {
        private _FreeContext() {
        }
    }

    private final class _HmsContext
    extends DrImpl<HmsServer, HmsPairSetup, HmsServersView>
    implements HmsRequestContextWithFSP {
        private _HmsContext() {
        }

        @Override
        public HmsServer extServer() {
            return RequestContextImpl.this._hms;
        }

        @Override
        public HmsPairSetup pairSetup() {
            return RequestContextImpl.this._hmsPairSetup;
        }
    }

    private final class _SrmContext
    extends DrImpl<SrmServer, SrmPairSetup, SrmServersView>
    implements SrmRequestContextWithFSP {
        private _SrmContext() {
        }

        @Override
        public SrmServer extServer() {
            return RequestContextImpl.this._srm;
        }

        @Override
        public SrmPairSetup pairSetup() {
            return RequestContextImpl.this._srmPairSetup;
        }
    }

    abstract class DrImpl<T extends ExtensionServer<?>, S extends PairSetup<T>, V extends ExtensionServersView>
    extends Impl<V> {
        DrImpl() {
        }

        public abstract T extServer();

        public abstract S pairSetup();
    }

    abstract class Impl<T extends ServersView>
    implements GetTopology,
    FilterSortPageContext {
        Impl() {
        }

        public T view() {
            return (T)RequestContextImpl.this._view;
        }

        public <P extends DrData> Promise<P> dispatch(String path, DrData arg) {
            return RequestContextImpl.this.dispatch(path, arg);
        }

        @Override
        public FilterData getFilterData() {
            return RequestContextImpl.this._filterData;
        }

        @Override
        public SortData getSortData() {
            return RequestContextImpl.this._sortData;
        }

        @Override
        public PageData getPageData() {
            return RequestContextImpl.this._pageData;
        }

        @Override
        public Topology get() {
            return RequestContextImpl.this._topology;
        }
    }
}

