/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.navigation;

import com.vmware.srm.client.infrastructure.requestHandlers.navigation.SitePairHelper;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.SitePairPicker;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.DrSitePair;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.ServerPair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;

public final class DrSitePairBuilder {
    private final String _vcGuid1;
    private final String _vcGuid2;
    private final String _vcGuidBias;
    private final List<SitePairHelper.VcExtPair> _srms1 = new ArrayList<SitePairHelper.VcExtPair>();
    private SitePairHelper.VcExtPair _hms1 = null;
    private final List<SitePairHelper.VcExtPair> _srms2 = new ArrayList<SitePairHelper.VcExtPair>();
    private SitePairHelper.VcExtPair _hms2 = null;

    DrSitePairBuilder(String vcGuid1, String vcGuid2, String vcGuidBias) {
        Validate.notEmpty((String)vcGuid1, (String)"vcGuid1");
        Validate.notEmpty((String)vcGuid2, (String)"vcGuid2");
        Validate.isTrue((!vcGuid1.equals(vcGuid2) ? 1 : 0) != 0);
        this._vcGuid1 = vcGuid1;
        this._vcGuid2 = vcGuid2;
        this._vcGuidBias = vcGuidBias;
    }

    private void validatePair(SitePairHelper.VcExtPair pair) {
        ServerPair vcs = pair.getVcPair();
        String vcGuid1 = vcs.getServer().getGuid();
        String vcGuid2 = vcs.getPairServer().getGuid();
        Validate.isTrue((boolean)(vcGuid1.equals(this._vcGuid1) ^ vcGuid1.equals(this._vcGuid2)));
        Validate.isTrue((boolean)(vcGuid2.equals(this._vcGuid1) ^ vcGuid2.equals(this._vcGuid2)));
    }

    void addSrm(SitePairHelper.VcExtPair srm) {
        this.validatePair(srm);
        if (this._vcGuid1.equals(srm.getVcPair().getServer().getGuid())) {
            this._srms1.add(srm);
        } else {
            this._srms2.add(srm);
        }
    }

    void addHms(SitePairHelper.VcExtPair hms) {
        this.validatePair(hms);
        if (this._vcGuid1.equals(hms.getVcPair().getServer().getGuid())) {
            this._hms1 = hms;
        } else {
            this._hms2 = hms;
        }
    }

    List<DrSitePair> build() {
        DrSitePair dsp1 = new DrSitePair();
        DrSitePair dsp2 = new DrSitePair();
        Map<SitePairHelper.UnorderedKey, List<SitePairHelper.VcExtPair>> srmPairs1 = this._srms1.stream().collect(Collectors.groupingBy(SitePairHelper::getGroupByPairsUnorderedKey));
        Map<SitePairHelper.UnorderedKey, List<SitePairHelper.VcExtPair>> srmPairs2 = this._srms2.stream().collect(Collectors.groupingBy(SitePairHelper::getGroupByPairsUnorderedKey));
        boolean hmsPairUsed = false;
        while (!srmPairs1.isEmpty() || !srmPairs2.isEmpty()) {
            SitePairHelper.VcExtPair srm1 = null;
            SitePairHelper.VcExtPair srm2 = null;
            Map.Entry<SitePairHelper.UnorderedKey, List<SitePairHelper.VcExtPair>> entry = null;
            Iterator<Map.Entry<SitePairHelper.UnorderedKey, List<SitePairHelper.VcExtPair>>> iter = null;
            if (!srmPairs1.isEmpty()) {
                iter = srmPairs1.entrySet().iterator();
                entry = iter.next();
                iter.remove();
                srm1 = entry.getValue().get(0);
                List<SitePairHelper.VcExtPair> srms2 = srmPairs2.remove(entry.getKey());
                if (srms2 != null) {
                    srm2 = srms2.get(0);
                }
            } else {
                iter = srmPairs2.entrySet().iterator();
                entry = iter.next();
                iter.remove();
                srm2 = entry.getValue().get(0);
            }
            SitePairPicker.select(srm1, srm2, this._hms1, this._hms2, this._vcGuidBias, dsp1, dsp2);
            hmsPairUsed = true;
        }
        if (!hmsPairUsed) {
            SitePairPicker.select(null, null, this._hms1, this._hms2, this._vcGuidBias, dsp1, dsp2);
        }
        ArrayList<DrSitePair> result = new ArrayList<DrSitePair>(2);
        if (dsp1.getVcPair() != null) {
            result.add(dsp1);
        }
        if (dsp2.getVcPair() != null) {
            result.add(dsp2);
        }
        return result;
    }
}

