/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.navigation;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;

public class SitePairRequestProcessor {
    private static final String MODE = "mode";
    private static final String VC_GUID = "vcGuid";
    private static final String PAIR_VC_GUID = "pairVcGuid";
    private static final String SRM_GUID = "srmGuid";
    private static final String PAIR_SRM_GUID = "pairSrmGuid";
    private static final String HMS_GUID = "hmsGuid";
    private static final String PAIR_HMS_GUID = "pairHmsGuid";

    public SitePairRequestData process(HttpServletRequest request) {
        String modeValue = request.getParameter(MODE);
        Validate.notEmpty((String)modeValue, (String)"Site-pair mode not specified");
        SitePairMode mode = SitePairMode.valueOf(modeValue.toUpperCase());
        String vcGuid = request.getParameter(VC_GUID);
        String pairVcGuid = request.getParameter(PAIR_VC_GUID);
        String srmGuid = request.getParameter(SRM_GUID);
        String pairSrmGuid = request.getParameter(PAIR_SRM_GUID);
        String hmsGuid = request.getParameter(HMS_GUID);
        String pairHmsGuid = request.getParameter(PAIR_HMS_GUID);
        return new SitePairRequestData(mode, vcGuid, pairVcGuid, srmGuid, pairSrmGuid, hmsGuid, pairHmsGuid);
    }

    public static final class SitePairRequestData {
        public final SitePairMode mode;
        public final String vcGuid;
        public final String pairVcGuid;
        public final String srmGuid;
        public final String pairSrmGuid;
        public final String hmsGuid;
        public final String pairHmsGuid;

        public SitePairRequestData(SitePairMode mode, String vcGuid, String pairVcGuid, String srmGuid, String pairSrmGuid, String hmsGuid, String pairHmsGuid) {
            this.mode = mode;
            this.vcGuid = vcGuid;
            this.pairVcGuid = pairVcGuid;
            this.srmGuid = srmGuid;
            this.pairSrmGuid = pairSrmGuid;
            this.hmsGuid = hmsGuid;
            this.pairHmsGuid = pairHmsGuid;
        }
    }

    public static enum SitePairMode {
        ALL{

            @Override
            public void accept(ModeVisitor mv, SitePairRequestData data) {
                mv.visitAll(data);
            }
        }
        ,
        SRM{

            @Override
            public void accept(ModeVisitor mv, SitePairRequestData data) {
                mv.visitSrm(data);
            }
        }
        ,
        HMS{

            @Override
            public void accept(ModeVisitor mv, SitePairRequestData data) {
                mv.visitHms(data);
            }
        }
        ,
        ROBO{

            @Override
            public void accept(ModeVisitor mv, SitePairRequestData data) {
                mv.visitHmsRobo(data);
            }
        }
        ,
        FREE{

            @Override
            public void accept(ModeVisitor mv, SitePairRequestData data) {
                mv.visitFree(data);
            }
        };


        public abstract void accept(ModeVisitor var1, SitePairRequestData var2);
    }

    public static interface ModeVisitor {
        public void visitAll(SitePairRequestData var1);

        public void visitSrm(SitePairRequestData var1);

        public void visitHms(SitePairRequestData var1);

        public void visitHmsRobo(SitePairRequestData var1);

        public void visitFree(SitePairRequestData var1);
    }
}

