/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.srm.client.infrastructure.tasks.FakeMultiTask;
import com.vmware.srm.client.infrastructure.tasks.FakeMultiTaskImpl;
import com.vmware.srm.client.infrastructure.tasks.FakeTask;
import com.vmware.srm.client.infrastructure.tasks.FakeTaskImpl;
import com.vmware.srm.client.infrastructure.tasks.FakeTaskRegistry;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.concurrent.atomic.AtomicLong;

public class FakeTaskFactory {
    private static final AtomicLong _id = new AtomicLong(0L);

    public static FakeTask createFakeTask() {
        FakeTaskImpl task = new FakeTaskImpl(FakeTaskFactory.createMoRef());
        FakeTaskRegistry.registerTask(task);
        return task;
    }

    public static <T> FakeTask createFakeTask(T result) {
        FakeTask task = FakeTaskFactory.createFakeTask();
        task.setState(TaskInfo.State.success, result, null, (Future)new BlockingFuture());
        return task;
    }

    public static FakeTask createFakeTask(Exception exc) {
        FakeTask task = FakeTaskFactory.createFakeTask();
        task.setState(TaskInfo.State.error, null, exc, (Future)new BlockingFuture());
        return task;
    }

    public static FakeMultiTask createFakeMultiTask(ManagedObjectReference[] subTaskMoRefs) {
        FakeMultiTask task = FakeTaskFactory.createFakeMultiTask();
        task.setSubTasks(subTaskMoRefs);
        return task;
    }

    public static FakeMultiTask createFakeMultiTask() {
        FakeMultiTaskImpl task = new FakeMultiTaskImpl(FakeTaskFactory.createMoRef());
        FakeTaskRegistry.registerTask(task);
        return task;
    }

    public static ManagedObjectReference createMoRef() {
        return ClientUtils.createMoRef((String)"VmodlFakeTask", (String)("srm-fake-task-" + _id.getAndIncrement()), (String)"fake-server-guid");
    }
}

