/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.srm.client.infrastructure.tasks.FakeTask;
import com.vmware.srm.client.infrastructure.tasks.TaskUtil;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vim.CustomFieldsManager;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.NotImplemented;
import com.vmware.vim.binding.vmodl.fault.NotSupported;
import com.vmware.vim.binding.vmodl.fault.RequestCanceled;
import com.vmware.vim.vmomi.core.Future;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeTaskImpl
implements FakeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeTaskImpl.class);
    private final ManagedObjectReference _moref;
    final TaskInfo _info;

    FakeTaskImpl(ManagedObjectReference moref) {
        if (moref == null) {
            throw new IllegalArgumentException("moref");
        }
        if (StringUtils.isEmpty((String)moref.getValue()) || !moref.getValue().startsWith("srm-fake-task")) {
            throw new IllegalArgumentException("Moref is not a fake task moref.");
        }
        this._moref = moref;
        this._info = TaskUtil.createInitialTaskInfo(moref);
    }

    public void getValue(Future<CustomFieldsManager.Value[]> _f) {
        throw new NotImplemented();
    }

    public void getAvailableField(Future<CustomFieldsManager.FieldDef[]> _f) {
        throw new NotImplemented();
    }

    public void setCustomValue(String key, String value, Future<Void> _f) {
        throw new NotImplemented();
    }

    public ManagedObjectReference _getRef() {
        return ClientUtils.createMoRef((String)this._moref.getType(), (String)this._moref.getValue(), (String)this._moref.getServerGuid());
    }

    public void getInfo(Future<TaskInfo> _f) {
        _f.set((Object)this._info);
    }

    public void cancel(Future<Void> _f) {
        try {
            this.cancel();
        }
        catch (Exception e) {
            _f.setException(e);
            return;
        }
        _f.set();
    }

    private void cancel() throws InvalidState {
        FakeTaskImpl fakeTaskImpl = this;
        synchronized (fakeTaskImpl) {
            if (!this._info.cancelable) {
                throw new NotSupported();
            }
            if (this._info.cancelled || TaskInfo.State.success.equals((Object)this._info.state) || TaskInfo.State.error.equals((Object)this._info.state)) {
                throw new InvalidState();
            }
            if (TaskInfo.State.running.equals((Object)this._info.state) || TaskInfo.State.queued.equals((Object)this._info.state)) {
                this._info.cancelled = true;
                this._info.state = TaskInfo.State.error;
                this._info.error = new RequestCanceled();
                LOGGER.info("[{}]: Task cancelled.", (Object)this._moref);
                this.notifyAll();
                return;
            }
            throw new InvalidState();
        }
    }

    public void UpdateProgress(int percentDone, Future<Void> _f) {
        try {
            this.updateProgress(percentDone);
        }
        catch (Exception e) {
            _f.setException(e);
            return;
        }
        _f.set();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgress(int percentDone) throws InvalidState {
        FakeTaskImpl fakeTaskImpl = this;
        synchronized (fakeTaskImpl) {
            if (!TaskInfo.State.running.equals((Object)this._info.state)) {
                throw new InvalidState();
            }
            int percent = percentDone;
            if (percent > 100) {
                percent = 100;
            } else if (percent < 0) {
                percent = 0;
            }
            LOGGER.info("[{}]: Updated task progress to: {}%", (Object)this._moref, (Object)percent);
            this._info.progress = percent;
            this.notifyAll();
        }
    }

    public void setState(TaskInfo.State state, Object result, Exception fault, Future<Void> _f) {
        try {
            this.setState(state, result, fault);
        }
        catch (Exception e) {
            _f.setException(e);
            return;
        }
        _f.set();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(TaskInfo.State state, Object result, Exception fault) throws InvalidState {
        if (result != null && !TaskInfo.State.success.equals((Object)state)) {
            throw new InvalidState();
        }
        if (fault != null && !TaskInfo.State.error.equals((Object)state)) {
            throw new InvalidState();
        }
        FakeTaskImpl fakeTaskImpl = this;
        synchronized (fakeTaskImpl) {
            if (TaskInfo.State.success.equals((Object)this._info.state) || TaskInfo.State.error.equals((Object)this._info.state)) {
                throw new InvalidState();
            }
            TaskInfo.State oldState = this._info.state;
            this._info.state = state;
            if (TaskInfo.State.error.equals((Object)state)) {
                this._info.error = fault;
                this._info.completeTime = Calendar.getInstance();
                this._info.progress = 100;
            } else if (TaskInfo.State.success.equals((Object)state)) {
                this._info.result = result;
                this._info.completeTime = Calendar.getInstance();
                this._info.progress = 100;
            }
            LOGGER.info("[{}]: Task state changed from [{}] to [{}].", new Object[]{this._moref, oldState, this._info.state});
            if (TaskInfo.State.error.equals((Object)this._info.state)) {
                LOGGER.error("[{}]: ", (Object)this._moref, (Object)this._info.error);
            }
            this.notifyAll();
        }
    }

    public void UpdateDescription(LocalizableMessage description, Future<Void> _f) {
        this.updateDescription(description);
        _f.set();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDescription(LocalizableMessage description) {
        FakeTaskImpl fakeTaskImpl = this;
        synchronized (fakeTaskImpl) {
            this._info.description = description;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntityName(String name) {
        FakeTaskImpl fakeTaskImpl = this;
        synchronized (fakeTaskImpl) {
            this._info.entityName = name;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntity(ManagedObjectReference moref) {
        FakeTaskImpl fakeTaskImpl = this;
        synchronized (fakeTaskImpl) {
            this._info.entity = moref;
            this.notifyAll();
        }
    }
}

