/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.srm.client.infrastructure.exceptions.CompositeException;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.tasks.FakeMultiTask;
import com.vmware.srm.client.infrastructure.tasks.FakeTaskRegistry;
import com.vmware.srm.client.infrastructure.tasks.TaskUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.impl.common.SyncUtils;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTaskProgressUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTaskProgressUpdater.class);
    private static final int TIMER_DELAY = 1000;
    private static final Map<FakeMultiTask, TaskDetails> _detailsByTask = new HashMap<FakeMultiTask, TaskDetails>();
    private static Timer _timer;

    private MultiTaskProgressUpdater() {
    }

    private static int calculatePercent(int allTaskCount, int completed) {
        if (completed == allTaskCount) {
            return 100;
        }
        return (int)((double)completed / (double)allTaskCount * 100.0);
    }

    private static Exception getSingleError(Collection<Exception> errors) {
        if (CollectionUtils.isEmpty(errors)) {
            return null;
        }
        Exception result = errors.size() == 1 ? errors.iterator().next() : new CompositeException(errors);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTask(FakeMultiTask task, ServersView view) {
        if (task == null) {
            throw new IllegalArgumentException("task");
        }
        if (view == null) {
            throw new IllegalArgumentException("view");
        }
        TaskDetails details = new TaskDetails();
        LOGGER.trace("Registering multi task [{}] for monitoring", (Object)task._getRef());
        Class<MultiTaskProgressUpdater> clazz = MultiTaskProgressUpdater.class;
        synchronized (MultiTaskProgressUpdater.class) {
            if (_detailsByTask.containsKey(task)) {
                LOGGER.trace("Task [{}] already registered. Skipping.", (Object)task._getRef());
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            _detailsByTask.put(task, details);
            MultiTaskProgressUpdater.startTimer(view);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static void startTimer(final ServersView view) {
        if (_detailsByTask.isEmpty()) {
            return;
        }
        if (_timer == null) {
            _timer = new Timer(true);
            _timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    MultiTaskProgressUpdater.timerTick(view);
                }
            }, 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Exception> getSubTaskErrors(FakeMultiTask task) {
        Class<MultiTaskProgressUpdater> clazz = MultiTaskProgressUpdater.class;
        synchronized (MultiTaskProgressUpdater.class) {
            TaskDetails details = _detailsByTask.get(task);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            LinkedList<Exception> errors = new LinkedList<Exception>();
            for (ManagedObjectReference subTask : task.getSubTasks()) {
                TaskInfo info = details.subTaskInfoByMoref.get(subTask);
                if (info == null || !TaskInfo.State.error.equals((Object)info.state) || info.error == null) continue;
                errors.add(info.error);
            }
            return errors;
        }
    }

    private static Promise<Void> updateProgress(FakeMultiTask task, ServersView view) {
        FuturePromise fp = new FuturePromise();
        task.getInfo((Future)fp);
        TaskInfo info = (TaskInfo)SyncUtils.getSync((Promise)fp);
        switch (info.state) {
            case success: 
            case error: 
            case queued: {
                return Promises.resolve(null);
            }
        }
        TaskInfo.State startState = info.state;
        Set<ManagedObjectReference> subTasks = MultiTaskProgressUpdater.getRunningSubTasks(task, false);
        Set<ManagedObjectReference> fakeSubTasks = MultiTaskProgressUpdater.getRunningSubTasks(task, true);
        Promise updateSubtasksPromise = subTasks.isEmpty() ? Promises.resolve(null) : PCUtil.retrieveProperties(view, subTasks, "info").thenApply(pcResult -> {
            MultiTaskProgressUpdater.updateSubTaskInfo(task, subTasks, pcResult);
            return pcResult;
        }).materialize();
        Promise updateFakeSubTasksPromise = Promises.resolve((Object)MultiTaskProgressUpdater.updateFakeSubTaskInfo(task, fakeSubTasks)).materialize();
        return updateSubtasksPromise.thenCombine(updateFakeSubTasksPromise, (subTasksResult, fakeSubTasksResult) -> {
            Exception subTasksError = null;
            if (subTasksResult != null) {
                subTasksError = !subTasksResult.isSuccessful() ? subTasksResult.getError() : MultiTaskProgressUpdater.getPcResultError((PcResult)subTasksResult.getResult());
            }
            FakeMultiTask fakeMultiTask2 = task;
            synchronized (fakeMultiTask2) {
                FuturePromise fpNewInfo = new FuturePromise();
                task.getInfo((Future)fpNewInfo);
                TaskInfo newInfo = (TaskInfo)SyncUtils.getSync((Promise)fpNewInfo);
                if (!startState.equals((Object)newInfo.state)) {
                    return null;
                }
                if (subTasksError != null) {
                    task.setState(TaskInfo.State.error, null, subTasksError, (Future)new BlockingFuture());
                    return null;
                }
                int percent = MultiTaskProgressUpdater.calculatePercent(task.getSubTasks().length, MultiTaskProgressUpdater.getFinishedSubTasks(task));
                try {
                    task.UpdateProgress(percent, (Future)new BlockingFuture());
                    if (percent == 100) {
                        Exception error = MultiTaskProgressUpdater.getSingleError(MultiTaskProgressUpdater.getSubTaskErrors(task));
                        task.setState(error == null ? TaskInfo.State.success : TaskInfo.State.error, null, error, (Future)new BlockingFuture());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to update progress: ", (Throwable)e);
                }
            }
            return null;
        });
    }

    private static Exception getPcResultError(PcResult pcResult) {
        Optional<ManagedObjectReference> morefWithError = pcResult.getMoRefs().stream().filter(item -> pcResult.getErrorForGuid(item.getServerGuid()) != null).findFirst();
        return morefWithError.map(managedObjectReference -> pcResult.getErrorForGuid(managedObjectReference.getServerGuid())).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSubTaskInfo(FakeMultiTask task, Collection<ManagedObjectReference> runningTasks, PcResult result) {
        if (MultiTaskProgressUpdater.getPcResultError(result) != null) {
            return;
        }
        Class<MultiTaskProgressUpdater> clazz = MultiTaskProgressUpdater.class;
        synchronized (MultiTaskProgressUpdater.class) {
            TaskDetails details = _detailsByTask.get(task);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (result.getMoRefs().isEmpty()) {
                MultiTaskProgressUpdater.assumeSubTasksHaveFinished(runningTasks, details.subTaskInfoByMoref);
                return;
            }
            HashSet morefsInResult = new HashSet();
            result.getMoRefs().forEach(moref -> {
                TaskInfo subInfo = (TaskInfo)result.getProperty((ManagedObjectReference)moref, "info");
                taskDetails.subTaskInfoByMoref.put(subInfo.task, subInfo);
                morefsInResult.add(moref);
            });
            LinkedList<ManagedObjectReference> missing = new LinkedList<ManagedObjectReference>(runningTasks);
            missing.removeAll(morefsInResult);
            if (missing.isEmpty()) {
                return;
            }
            MultiTaskProgressUpdater.assumeSubTasksHaveFinished(missing, details.subTaskInfoByMoref);
            return;
        }
    }

    private static void assumeSubTasksHaveFinished(Collection<ManagedObjectReference> subTasks, Map<ManagedObjectReference, TaskInfo> taskInfoByMoref) {
        for (ManagedObjectReference moref : subTasks) {
            TaskInfo info = TaskUtil.createInitialTaskInfo(moref);
            info.state = TaskInfo.State.success;
            info.completeTime = Calendar.getInstance();
            taskInfoByMoref.put(moref, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Void updateFakeSubTaskInfo(FakeMultiTask task, Collection<ManagedObjectReference> runningFakeTasks) {
        Class<MultiTaskProgressUpdater> clazz = MultiTaskProgressUpdater.class;
        synchronized (MultiTaskProgressUpdater.class) {
            TaskDetails details = _detailsByTask.get(task);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            HashSet morefsInResult = new HashSet();
            runningFakeTasks.forEach(moref -> {
                Task subTask = FakeTaskRegistry.getTask(moref);
                if (subTask == null) {
                    return;
                }
                FuturePromise fpSubInfo = new FuturePromise();
                subTask.getInfo((Future)fpSubInfo);
                TaskInfo subInfo = (TaskInfo)SyncUtils.getSync((Promise)fpSubInfo);
                taskDetails.subTaskInfoByMoref.put(subInfo.task, subInfo);
                morefsInResult.add(moref);
            });
            LinkedList<ManagedObjectReference> missing = new LinkedList<ManagedObjectReference>(runningFakeTasks);
            missing.removeAll(morefsInResult);
            if (missing.isEmpty()) {
                return null;
            }
            MultiTaskProgressUpdater.assumeSubTasksHaveFinished(missing, details.subTaskInfoByMoref);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ManagedObjectReference> getRunningSubTasks(FakeMultiTask task, boolean fakeTasks) {
        LOGGER.debug("Collecting morefs of sub-tasks which have not finished yet");
        Class<MultiTaskProgressUpdater> clazz = MultiTaskProgressUpdater.class;
        synchronized (MultiTaskProgressUpdater.class) {
            TaskDetails details = _detailsByTask.get(task);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            HashSet<ManagedObjectReference> subTasks = new HashSet<ManagedObjectReference>();
            for (ManagedObjectReference subTask : task.getSubTasks()) {
                TaskInfo subInfo = details.subTaskInfoByMoref.get(subTask);
                if (subInfo != null && (TaskInfo.State.error.equals((Object)subInfo.state) || TaskInfo.State.success.equals((Object)subInfo.state)) || fakeTasks != "VmodlFakeTask".equals(subTask.getType())) continue;
                subTasks.add(subTask);
            }
            LOGGER.debug("Found {} sub-task which are still running.", (Object)subTasks.size());
            return subTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFinishedSubTasks(FakeMultiTask task) {
        Class<MultiTaskProgressUpdater> clazz = MultiTaskProgressUpdater.class;
        synchronized (MultiTaskProgressUpdater.class) {
            TaskDetails details = _detailsByTask.get(task);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int res = 0;
            for (ManagedObjectReference moref : task.getSubTasks()) {
                TaskInfo info = details.subTaskInfoByMoref.get(moref);
                if (info == null || !TaskInfo.State.error.equals((Object)info.state) && !TaskInfo.State.success.equals((Object)info.state)) continue;
                ++res;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFinishedTasks() {
        Class<MultiTaskProgressUpdater> clazz = MultiTaskProgressUpdater.class;
        synchronized (MultiTaskProgressUpdater.class) {
            Iterator<FakeMultiTask> it = _detailsByTask.keySet().iterator();
            while (it.hasNext()) {
                FakeMultiTask task = it.next();
                FuturePromise fp = new FuturePromise();
                task.getInfo((Future)fp);
                TaskInfo info = (TaskInfo)SyncUtils.getSync((Promise)fp);
                if (!TaskInfo.State.error.equals((Object)info.state) && !TaskInfo.State.success.equals((Object)info.state)) continue;
                it.remove();
                LOGGER.trace("Removing finished task: [{}]", (Object)task._getRef());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void timerTick(ServersView view) {
        Stream stream = Streams.empty();
        Class<MultiTaskProgressUpdater> clazz = MultiTaskProgressUpdater.class;
        synchronized (MultiTaskProgressUpdater.class) {
            if (_detailsByTask.isEmpty()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            for (FakeMultiTask task : _detailsByTask.keySet()) {
                stream = stream.merge(new Publisher[]{MultiTaskProgressUpdater.updateProgress(task, view).materialize().thenApply(promiseResult -> {
                    if (promiseResult.getError() != null) {
                        task.setState(TaskInfo.State.error, null, promiseResult.getError(), (Future)new BlockingFuture());
                    }
                    return promiseResult;
                })});
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            stream.collect().onSuccess(voids -> {
                try {
                    MultiTaskProgressUpdater.removeFinishedTasks();
                }
                finally {
                    Class<MultiTaskProgressUpdater> clazz = MultiTaskProgressUpdater.class;
                    synchronized (MultiTaskProgressUpdater.class) {
                        _timer = null;
                        MultiTaskProgressUpdater.startTimer(view);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                }
            });
            return;
        }
    }

    private static class TaskDetails {
        final Map<ManagedObjectReference, TaskInfo> subTaskInfoByMoref = new HashMap<ManagedObjectReference, TaskInfo>();

        private TaskDetails() {
        }
    }
}

