/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.srm.client.infrastructure.tasks.ComposableTask;
import com.vmware.srm.client.infrastructure.tasks.FakeMultiTask;
import com.vmware.srm.client.infrastructure.tasks.FakeTaskFactory;
import com.vmware.srm.client.infrastructure.tasks.MultiTaskProgressUpdater;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ParallelTasksExecutor {
    public static Promise<ManagedObjectReference> runTasks(Set<ComposableTask> tasks, ServersView view) {
        if (CollectionUtils.isEmpty(tasks)) {
            return Promises.resolve(null);
        }
        if (tasks.size() == 1) {
            return tasks.iterator().next().run();
        }
        List<Promise> runningTasks = tasks.stream().map(ComposableTask::run).collect(Collectors.toList());
        return Promises.all((Promise[])runningTasks.toArray(new Promise[runningTasks.size()])).thenApply(tasksResult -> {
            List<ManagedObjectReference> taskRefs = runningTasks.stream().map(arg_0 -> ((Promises.ResultAccessor)tasksResult).getResult(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            if (taskRefs.size() == 1) {
                return (ManagedObjectReference)taskRefs.get(0);
            }
            FakeMultiTask multiTask = FakeTaskFactory.createFakeMultiTask(taskRefs.toArray(new ManagedObjectReference[taskRefs.size()]));
            MultiTaskProgressUpdater.registerTask(multiTask, view);
            return multiTask._getRef();
        });
    }
}

