/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.srm.client.infrastructure.tasks.FakeTask;
import com.vmware.srm.client.infrastructure.tasks.FakeTaskFactory;
import com.vmware.srm.client.infrastructure.tasks.FakeTaskRegistry;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.common.TaskMonitor;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.Calendar;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskUtil.class);

    @Deprecated
    public static <T> Promise<T> waitForTaskToFinish(Service srmService, ManagedObjectReference taskMoRef) {
        Task task = "VmodlFakeTask".equals(taskMoRef.getType()) ? FakeTaskRegistry.getTask(taskMoRef) : (Task)srmService.createStub(taskMoRef);
        if (task == null) {
            LOGGER.error("The task with ref {} is null!", (Object)taskMoRef.toString());
            return Promises.reject((Exception)new IllegalStateException("The task is null!"));
        }
        TaskMonitor taskMonitor = new TaskMonitor(task);
        return taskMonitor.start();
    }

    public static Promise<TaskInfo> getTaskInfo(Service srmService, ManagedObjectReference taskMoRef) {
        Task task = "VmodlFakeTask".equals(taskMoRef.getType()) ? FakeTaskRegistry.getTask(taskMoRef) : (Task)srmService.createStub(taskMoRef);
        if (task == null) {
            LOGGER.error("The task with ref {} is null!", (Object)taskMoRef.toString());
            throw new IllegalStateException("The task is null!");
        }
        FuturePromise taskInfoFuture = new FuturePromise();
        task.getInfo((Future)taskInfoFuture);
        return taskInfoFuture;
    }

    public static TaskInfo createInitialTaskInfo(ManagedObjectReference moref) {
        TaskInfo info = new TaskInfo();
        info.task = moref;
        info.state = TaskInfo.State.running;
        info.progress = 0;
        info.startTime = Calendar.getInstance();
        info.descriptionId = "";
        return info;
    }

    public static <T> FakeTask toFakeTask(Supplier<Promise<T>> supplier) {
        Promise result;
        FakeTask fakeTask = FakeTaskFactory.createFakeTask();
        try {
            result = supplier.get();
        }
        catch (Exception e) {
            result = Promises.reject((Exception)e);
        }
        result.onSuccess(data -> fakeTask.setState(TaskInfo.State.success, data, null, (Future)new BlockingFuture())).onError(error -> fakeTask.setState(TaskInfo.State.error, null, (Exception)error, (Future)new BlockingFuture()));
        return fakeTask;
    }

    public static <T, U> FakeTask toFakeTask(Task task, Function<T, Promise<U>> resultHandler) {
        return TaskUtil.toFakeTask(() -> new TaskMonitor(task).start().thenCompose(resultHandler));
    }
}

