/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.vim.Tag;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

public class NetworkUtil {
    public static final String UPLINK_PG_TAG = "SYSTEM/DVS.UPLINKPG";

    public static Promise<Boolean> isUplinkPortgroup(ManagedObjectReference dvPgRef, ServersView view) {
        Promise tagsPromise = PCUtil.retrieveProperty(view, dvPgRef, "tag");
        return tagsPromise.thenApply(NetworkUtil::isUplinkPortgroup);
    }

    public static Promise<Boolean> hasUplinkPortgroup(Set<ManagedObjectReference> dvPgRefs, ServersView view) {
        Validate.notNull(dvPgRefs);
        Promise<PcResult> tagsPromise = PCUtil.retrieveProperties(view, dvPgRefs, "tag");
        return tagsPromise.thenApply(pcResult -> pcResult.getMoRefs().stream().map(moRef -> (Tag[])pcResult.tryGetProperty((ManagedObjectReference)moRef, "tag")).anyMatch(NetworkUtil::isUplinkPortgroup));
    }

    public static boolean isUplinkPortgroup(Tag[] tags) {
        return ArrayUtils.isNotEmpty((Object[])tags) && Arrays.stream(tags).anyMatch(tag -> UPLINK_PG_TAG.equals(tag.key));
    }
}

