/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version.class);
    public final int major;
    public final int minor;
    public final int revision;
    public final int buildNumber;

    public Version(String version) {
        if (StringUtils.isBlank((String)version)) {
            this.major = 0;
            this.minor = 0;
            this.revision = 0;
            this.buildNumber = 0;
            return;
        }
        String[] parts = version.split("\\.");
        if (parts.length > 4) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        int major = Integer.parseInt(parts[0]);
        if (major < 0) {
            major = 0;
        }
        this.major = major;
        int minorValue = 0;
        int revisionValue = 0;
        int buildNumberValue = 0;
        if (parts.length > 1) {
            minorValue = Integer.parseInt(parts[1]);
            if (minorValue < 0) {
                minorValue = 0;
            }
            if (parts.length > 2) {
                revisionValue = Integer.parseInt(parts[2]);
                if (revisionValue < 0) {
                    revisionValue = 0;
                }
                if (parts.length > 3 && (buildNumberValue = Integer.parseInt(parts[3])) < 0) {
                    buildNumberValue = 0;
                }
            }
        }
        this.minor = minorValue;
        this.revision = revisionValue;
        this.buildNumber = buildNumberValue;
    }

    public int compareTo(Version value) {
        if (value == null) {
            return 1;
        }
        if (this.major != value.major) {
            if (this.major > value.major) {
                return 1;
            }
            return -1;
        }
        if (this.minor != value.minor) {
            if (this.minor > value.minor) {
                return 1;
            }
            return -1;
        }
        if (this.revision != value.revision) {
            if (this.revision > value.revision) {
                return 1;
            }
            return -1;
        }
        if (this.buildNumber == value.buildNumber) {
            return 0;
        }
        if (this.buildNumber > value.buildNumber) {
            return 1;
        }
        return -1;
    }

    public static int compare(Version v1, Version v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return v1.compareTo(v2);
    }

    public static boolean isValidVersion(String versionStr) {
        Version version = null;
        try {
            version = new Version(versionStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version != null;
    }

    public static boolean isSupportedVersion(String[] supportedVersions, String version) {
        if (supportedVersions == null) {
            return false;
        }
        Version v = new Version(version);
        for (String supportedVersion : supportedVersions) {
            if (!Version.matchMajorMinorVersions(supportedVersion, v)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchMajorMinorVersions(String supportedVersion, Version v) {
        try {
            Version sv = new Version(supportedVersion);
            return sv.major == v.major && sv.minor == v.minor;
        }
        catch (Exception e) {
            LOGGER.error("Error when comparing versions", (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return String.format("%s.%s.%s.%s", this.major, this.minor, this.revision, this.buildNumber);
    }
}

