/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.validation;

import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.commonData.StringDrData;
import com.vmware.srm.client.infrastructure.commonData.ValidationResult;
import com.vmware.srm.client.infrastructure.exceptions.ExceptionUtil;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrFaultImpl;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.infrastructure.validation.data.NameValidationData;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.utilities.Exceptions;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.recovery.RECOVERY_PLAN;
import com.vmware.vim.constants.dr.replication.PROTECTION_GROUP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DrInputType(value=NameValidationData.class)
public class NameValidationDataHandler
implements FreeRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NameValidationDataHandler.class);
    private static final Map<String, String> TYPE_TO_NAME_PROPERTY = new HashMap<String, String>();

    @Override
    public Promise<? extends DrData> handle(DrData input, FreeRequestContext context) {
        NameValidationData data = (NameValidationData)input;
        MoRefData location = NameValidationDataHandler.fixFolderRef(this.getLocation(data));
        MoRefData entity = data.isEditMode() ? NameValidationDataHandler.fixFolderRef(data.getMoRef()) : location;
        return this.validate(entity, data, context).materialize().thenCompose(promiseResult -> {
            if (!promiseResult.isSuccessful()) {
                return ExceptionUtil.checkNoPermission(promiseResult.getError(), context.view()).thenApply(error -> {
                    ValidationResult result = new ValidationResult();
                    result.setEntity(entity);
                    result.setResult(false);
                    result.setError(DrFaultImpl.from(L10N.localize("cannotValidateName", new Object[0]), error));
                    LOGGER.warn("Cannot validate name.", (Throwable)error);
                    return result;
                });
            }
            return Promises.resolve((Object)promiseResult.getResult());
        });
    }

    public Promise<ValidationResult> validate(MoRefData entity, NameValidationData spec, FreeRequestContext context) {
        Validate.notNull((Object)entity, (String)"entity");
        ValidationResult result = new ValidationResult();
        result.setEntity(entity);
        result.setResult(true);
        Object view = context.view();
        if (!spec.isEditMode()) {
            return this.isNameUnique((ServersView)view, entity, spec.getName().trim(), spec.getTargetType(), false, result);
        }
        return this.getName(entity, context).thenCompose(nameResult -> {
            String name = nameResult.getValue();
            if (name.equals(spec.getName())) {
                return Promises.resolve((Object)result);
            }
            return this.isNameUnique((ServersView)view, entity, spec.getName().trim(), spec.getTargetType(), true, result);
        });
    }

    private Promise<StringDrData> getName(MoRefData entity, FreeRequestContext context) {
        return context.dispatch("getSrmObjectName", entity);
    }

    private Promise<ValidationResult> isNameUnique(ServersView view, MoRefData objRef, String name, String type, Boolean isEditMode, ValidationResult result) {
        PropertyCollector.ObjectSpec objectSpec;
        ObjectSpecBuilder builder = new ObjectSpecBuilder(objRef);
        if (isEditMode.booleanValue()) {
            builder.traverseTo("parentEntity", true).traverseTo("DrFolder", "childEntity");
            objectSpec = builder.build();
        } else {
            builder.traverseTo("childEntity");
            objectSpec = builder.build();
        }
        List<String> childTypes = this.getChildTypes(type);
        List<PropertyCollector.PropertySpec> props = childTypes.stream().map(childType -> PCUtil.createPropertySpec(childType, TYPE_TO_NAME_PROPERTY.get(childType))).collect(Collectors.toList());
        PropertyCollector.FilterSpec filterSpec = PCUtil.createFilterSpec(objectSpec, props.toArray(new PropertyCollector.PropertySpec[props.size()]));
        return PCUtil.retrieveProperties(view, filterSpec).thenApply(pcResult -> {
            Exception error = pcResult.getErrorForGuid(objRef.getServerGuid());
            if (error != null) {
                throw Exceptions.getRuntimeException((Throwable)error);
            }
            boolean hasDuplicateName = pcResult.getMoRefs().stream().filter(item -> !item.equals((Object)objRef)).map(item -> pcResult.getProperty((ManagedObjectReference)item, TYPE_TO_NAME_PROPERTY.get(item.getType()))).anyMatch(childName -> childName.equals(name));
            result.setResult(!hasDuplicateName);
            return result;
        });
    }

    private List<String> getChildTypes(String parentType) {
        ArrayList<String> result = new ArrayList<String>();
        switch (parentType) {
            case "DrReplicationProtectionGroup": {
                result.add("DrReplicationVmProtectionGroup");
                result.add("DrReplicationStorageProfileProtectionGroup");
                break;
            }
            case "DrFolder": {
                result.add("DrFolder");
                break;
            }
            case "DrRecoveryRecoveryPlan": {
                result.add("DrRecoveryRecoveryPlan");
            }
        }
        return result;
    }

    private MoRefData getLocation(NameValidationData data) {
        MoRefData location = data.getLocationRef();
        if (location != null && "DrServiceInstance".equals(location.getType())) {
            if ("DrReplicationProtectionGroup".equals(data.getTargetType())) {
                location = new MoRefData("DrFolder", "DrReplicationRootFolder", location.getServerGuid());
            } else if ("DrRecoveryRecoveryPlan".equals(data.getTargetType())) {
                location = new MoRefData("DrFolder", "DrRecoveryRootFolder", location.getServerGuid());
            }
        }
        location = location == null ? null : new MoRefData("DrFolder", location.getValue(), location.getServerGuid());
        return location;
    }

    private static MoRefData fixFolderRef(MoRefData moRef) {
        if (moRef == null) {
            return null;
        }
        if ("DrRecoveryFolder".equals(moRef.getType()) || "DrRecoveryRootFolder".equals(moRef.getType()) || "DrReplicationFolder".equals(moRef.getType()) || "DrReplicationRootFolder".equals(moRef.getType())) {
            return new MoRefData("DrFolder", moRef.getValue(), moRef.getServerGuid());
        }
        return moRef;
    }

    static {
        TYPE_TO_NAME_PROPERTY.put("DrReplicationVmProtectionGroup", PROTECTION_GROUP.BASIC_SETTINGS_.NAME);
        TYPE_TO_NAME_PROPERTY.put("DrReplicationStorageProfileProtectionGroup", PROTECTION_GROUP.BASIC_SETTINGS_.NAME);
        TYPE_TO_NAME_PROPERTY.put("DrFolder", "name");
        TYPE_TO_NAME_PROPERTY.put("DrRecoveryRecoveryPlan", RECOVERY_PLAN.INFO_.NAME);
    }
}

