/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.srm.client.topology.impl.core.mxn.nodes.TokenProviderImpl;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.sso.TokenManager;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.exception.SsoException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class SolutionUserTokenManager {
    private final X509Certificate cert;
    private final PrivateKey privateKey;
    private final TokenProviderImpl _provider;

    public SolutionUserTokenManager(X509Certificate cert, PrivateKey privateKey) {
        this.cert = cert;
        this.privateKey = privateKey;
        this._provider = new ProviderImpl();
    }

    public TokenProvider getTokenProvider() {
        return this._provider;
    }

    public void setSso(LsppService ssoReg) throws SsoException, GeneralSecurityException, IOException {
        DrSecurityTokenService sts = this.createSts(ssoReg);
        this._provider.setSts(sts);
    }

    public void dispose() {
        this._provider.dispose();
    }

    private DrSecurityTokenService createSts(LsppService ssoReg) throws GeneralSecurityException, IOException, SsoException {
        DrSecurityTokenService sts = SsoFacade.createSts((LsppService)ssoReg, (X509Certificate)this.cert, (PrivateKey)this.privateKey);
        try {
            SsoFacade.getTokenManager().acquireTokenByCertificate((SecurityTokenService)sts);
        }
        catch (SsoException | RuntimeException exc) {
            sts.dispose();
            throw exc;
        }
        return sts;
    }

    private static final class ProviderImpl
    extends TokenProviderImpl {
        private ProviderImpl() {
        }

        public void login(String username, String password) {
            throw new UnsupportedOperationException();
        }

        public void login(SamlToken suToken, SamlToken actAsToken) {
            throw new UnsupportedOperationException();
        }

        public SamlToken getToken() throws TokenProvider.AuthenticationTokenNotAvailable {
            try {
                return super.getToken();
            }
            catch (TokenProvider.AuthenticationTokenNotAvailable notAvailable) {
                try {
                    DrSecurityTokenService current = this.getSts();
                    SamlToken result = SsoFacade.getTokenManager().acquireTokenByCertificate((SecurityTokenService)current);
                    if (current != this.getSts()) {
                        SsoFacade.getTokenManager().releaseToken((SecurityTokenService)current);
                        return this.getToken();
                    }
                    return result;
                }
                catch (TokenManager.TokenRequestExists requestExists) {
                    return this.getToken();
                }
                catch (SsoException ssoExc) {
                    notAvailable.addSuppressed((Throwable)ssoExc);
                    throw notAvailable;
                }
            }
        }
    }
}

