/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.srm.client.infrastructure.websso.SolutionUserTokenManager;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import java.security.cert.X509Certificate;

final class SsoContextBuilder {
    private SolutionUserTokenManager suTokenManager;
    private IDPConfiguration idpConfig;
    private SPConfiguration spConfig;
    private LsppService ssoReg;
    private long clockTolerance;
    private X509Certificate[] signingCerts;
    private MetadataSettings _metadataSettings;

    SsoContextBuilder() {
    }

    SsoContextBuilder setSuTokenManager(SolutionUserTokenManager suTokenManager) {
        this.suTokenManager = suTokenManager;
        return this;
    }

    SsoContextBuilder setIdpConfig(IDPConfiguration idpConfig) {
        this.idpConfig = idpConfig;
        return this;
    }

    SsoContextBuilder setSpConfig(SPConfiguration spConfig) {
        this.spConfig = spConfig;
        return this;
    }

    SsoContextBuilder setSsoReg(LsppService ssoReg) {
        this.ssoReg = ssoReg;
        return this;
    }

    SsoContextBuilder setClockTolerance(long clockTolerance) {
        this.clockTolerance = clockTolerance;
        return this;
    }

    SsoContextBuilder setSigningCerts(X509Certificate[] signingCerts) {
        this.signingCerts = signingCerts;
        return this;
    }

    SsoContextBuilder setMetadataSettings(MetadataSettings settings) {
        this._metadataSettings = settings;
        return this;
    }

    SsoContext build() {
        return new SsoContext(this.suTokenManager, this.idpConfig, this.spConfig, this.ssoReg, this.clockTolerance, this.signingCerts, this._metadataSettings);
    }
}

