/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.config;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.ApiProviderStub;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.internal.provider.introspection.ApiIntrospectionStubImpl;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vapi.provider.local.LocalProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfacesHelper {
    static final Logger logger = LoggerFactory.getLogger(InterfacesHelper.class);

    public Map<String, ApiProvider> buildInterfacesMap(LocalProvider localProvider) {
        logger.debug("Adding local interfaces.");
        HashMap<String, ApiProvider> result = new HashMap<String, ApiProvider>();
        Set<InterfaceIdentifier> localInterfaces = localProvider.getInterfaceIdentifiers(null);
        for (InterfaceIdentifier interfaceIdentifier : localInterfaces) {
            result.put(interfaceIdentifier.toString(), localProvider);
        }
        return result;
    }

    public Map<String, ApiProvider> buildInterfacesMap(ApiProvider apiProvider) {
        HashMap<String, ApiProvider> result = new HashMap<String, ApiProvider>();
        ApiIntrospectionStubImpl introspectionService = new ApiIntrospectionStubImpl(apiProvider);
        Set<InterfaceIdentifier> interfaces = introspectionService.getInterfaceIdentifiers();
        for (InterfaceIdentifier interfaceIdentifier : interfaces) {
            result.put(interfaceIdentifier.toString(), apiProvider);
        }
        return result;
    }

    public Map<String, ApiProvider> buildInterfacesMap(ProtocolConnection protocolConnection) {
        ApiProvider provider = protocolConnection.getApiProvider();
        ApiProviderStub stub = protocolConnection.getApiProviderStub();
        HashMap<String, ApiProvider> result = new HashMap<String, ApiProvider>();
        for (InterfaceIdentifier id : stub.getInterfaceIdentifiers()) {
            result.put(id.getName(), provider);
        }
        return result;
    }
}

