/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.data.TypeConverterDrivenConstraintValidator;
import com.vmware.vapi.internal.util.Validate;

public class HasFieldsOfValidator
implements TypeConverterDrivenConstraintValidator {
    static final String CAPABILITY = "capability";
    static final String AT_CLASS = "@class";
    private static final String COMPUTE_POLICY_CAPABILITIES_PACKAGE = "com.vmware.vcenter.compute.policies";
    private static final String CREATE_SPEC = "create_spec";
    private static final Message FAILED_VALIDATION_MSG = MessageFactory.getMessage("vapi.data.structure.hasfieldsof.invalid", new String[0]);
    private final TypeReference<? extends StructType> structTypeRef;
    private TypeConverter converter;

    public HasFieldsOfValidator(TypeReference<? extends StructType> structTypeRef) {
        Validate.notNull(structTypeRef);
        this.structTypeRef = structTypeRef;
    }

    static DataValue populateCapabilityFieldForComputePolicy(DataValue dataValue) {
        if (!(dataValue instanceof StructValue)) {
            return dataValue;
        }
        StructValue asStructValue = (StructValue)dataValue;
        String name = asStructValue.getName();
        if (name == null || name.isEmpty()) {
            if (asStructValue.hasField(AT_CLASS)) {
                try {
                    name = asStructValue.getString(AT_CLASS);
                }
                catch (CoreException ex) {
                    return dataValue;
                }
            } else {
                name = null;
            }
        }
        if (name != null && name.startsWith(COMPUTE_POLICY_CAPABILITIES_PACKAGE) && name.endsWith(CREATE_SPEC)) {
            if (asStructValue.hasField(CAPABILITY)) {
                return dataValue;
            }
            StructValue copy = asStructValue.copy();
            copy.setField(CAPABILITY, "doesn't matter");
            return copy;
        }
        return dataValue;
    }

    @Override
    public void validate(DataValue dataValue) {
        if (this.converter == null) {
            this.converter = new TypeConverterImpl(true);
        }
        try {
            dataValue = HasFieldsOfValidator.populateCapabilityFieldForComputePolicy(dataValue);
            this.converter.convertToJava(dataValue, this.structTypeRef.resolve());
        }
        catch (ConverterException e) {
            throw new ConstraintValidationException(FAILED_VALIDATION_MSG, (Throwable)e);
        }
    }

    @Override
    public void validate(DataValue dataValue, TypeConverter converter) {
        Validate.notNull(converter);
        dataValue = HasFieldsOfValidator.populateCapabilityFieldForComputePolicy(dataValue);
        converter.convertToJava(dataValue, this.structTypeRef.resolve());
    }
}

