/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.util.StructTypeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class MapBasedNameToTypeResolver
implements NameToTypeResolver {
    public static final Map<String, StructType> STANDARD_ERRORS;
    private final Map<String, StructType> typeMap;

    public MapBasedNameToTypeResolver(Map<String, StructType> typeMap) {
        Validate.notNull(typeMap);
        Validate.noNullElements(typeMap.keySet());
        Validate.noNullElements(typeMap.values());
        this.typeMap = Collections.unmodifiableMap(typeMap);
    }

    @Override
    public Type resolve(String name) {
        Validate.notNull(name);
        return this.typeMap.get(name);
    }

    public static Map<String, StructType> augmentWithStandardErrors(Set<ErrorType> typeSet) {
        if (typeSet == null || typeSet.isEmpty()) {
            return STANDARD_ERRORS;
        }
        HashMap<String, StructType> errorTypeMap = new HashMap<String, StructType>();
        errorTypeMap.putAll(STANDARD_ERRORS);
        errorTypeMap.putAll(MapBasedNameToTypeResolver.toMap(typeSet));
        return errorTypeMap;
    }

    private static Map<String, StructType> toMap(Set<ErrorType> typeSet) {
        HashMap<String, StructType> typeMap = new HashMap<String, StructType>();
        for (ErrorType t : typeSet) {
            typeMap.put(t.getName(), t);
        }
        return typeMap;
    }

    static {
        HashMap<String, StructType> typeMap = new HashMap<String, StructType>();
        StructTypeUtil.populateCanonicalNameToStructTypeMap(typeMap);
        HashMap errorMap = new HashMap();
        for (Map.Entry e : typeMap.entrySet()) {
            if (!((String)e.getKey()).startsWith("com.vmware.vapi.std.errors")) continue;
            errorMap.put(e.getKey(), e.getValue());
        }
        STANDARD_ERRORS = Collections.unmodifiableMap(errorMap);
    }
}

