/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.msg.json;

import com.vmware.vapi.client.exception.MessageProtocolException;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.core.abort.AbortHandleProvider;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.common.Util;
import com.vmware.vapi.internal.protocol.common.json.JsonApiRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonApiResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonBaseResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonConstants;
import com.vmware.vapi.internal.protocol.common.json.JsonInvokeRequestParams2;
import com.vmware.vapi.internal.protocol.common.json.JsonMsgDeserializer2;
import com.vmware.vapi.internal.protocol.common.json.JsonMsgSerializer2;
import com.vmware.vapi.internal.protocol.common.json.JsonProgressResponse;
import com.vmware.vapi.internal.protocol.common.msg.JsonMessageProtocolExceptionTranslator;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.internal.util.io.ReleasableInputStream;
import com.vmware.vapi.protocol.ClientConfiguration;
import com.vmware.vapi.protocol.Constants;
import com.vmware.vapi.protocol.RequestProcessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonApiProvider
implements ApiProvider {
    private static final String UTF8_CHARSET = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(JsonApiProvider.class);
    private final JsonMsgSerializer2 jsonSerializer2;
    private final JsonMsgDeserializer2 jsonDeserializer2;
    private final List<RequestProcessor> processorChain;
    private final CorrelatingClient client;

    public JsonApiProvider(CorrelatingClient client, ClientConfiguration config) {
        this.client = client;
        if (config == null) {
            config = new ClientConfiguration.Builder().getConfig();
        }
        this.processorChain = Collections.unmodifiableList(config.getRequestProcessors());
        this.jsonSerializer2 = new JsonMsgSerializer2();
        this.jsonDeserializer2 = new JsonMsgDeserializer2();
    }

    private void sendRequest(Object jsonRequestObj, Map<String, Object> processorMetaData, ExecutionContext ctx, AbortHandle abortHandle, CorrelatingClient.ResponseCallback cb, String serviceId, String operationId) {
        if (Util.checkRequestAborted(abortHandle, cb)) {
            return;
        }
        byte[] jsonRequest = this.jsonSerializer2.serialize(jsonRequestObj);
        for (RequestProcessor proc : this.processorChain) {
            if (Util.checkRequestAborted(abortHandle, cb)) {
                return;
            }
            jsonRequest = proc.process(jsonRequest, processorMetaData, null);
        }
        if (logger.isDebugEnabled() && Constants.shouldLogRawRequestResponse()) {
            try {
                String jsonRequestString = new String(jsonRequest, UTF8_CHARSET);
                logger.debug("JSON request: {}", (Object)jsonRequestString);
            }
            catch (UnsupportedEncodingException ex) {
                logger.debug("Cound not decode JSON request", (Throwable)ex);
            }
        }
        logger.debug("Sending request of size: {}", (Object)jsonRequest.length);
        ByteArrayInputStream requestAsByteIS = new ByteArrayInputStream(jsonRequest);
        ReleasableInputStream releasableRequest = new ReleasableInputStream(requestAsByteIS);
        this.client.send(releasableRequest, jsonRequest.length, ctx, abortHandle, cb, serviceId, operationId);
    }

    private static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    private void checkResponseId(JsonBaseResponse response, String UUID2) {
        String responseId = response.getId();
        if (!responseId.equals(UUID2)) {
            throw new MessageProtocolException("UUID mismatch in getProviderIdentifier");
        }
    }

    private CorrelatingClient.ResponseCallback decorateCallbackWithExceptionTranslation(final CorrelatingClient.ResponseCallback cb) {
        return new CorrelatingClient.ResponseCallback(){

            @Override
            public void received(InputStream response) {
                try {
                    cb.received(response);
                }
                catch (Exception e) {
                    throw JsonMessageProtocolExceptionTranslator.translate(e);
                }
            }

            @Override
            public void failed(RuntimeException error) {
                try {
                    cb.failed(error);
                }
                catch (Exception e) {
                    throw JsonMessageProtocolExceptionTranslator.translate(e);
                }
            }
        };
    }

    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        AbortHandle requestAbortHandle = asyncHandle instanceof AbortHandleProvider ? ((AbortHandleProvider)((Object)asyncHandle)).getAbortHandle() : null;
        final String UUID2 = JsonApiProvider.generateUUID();
        AsyncHandle<MethodResult> resultHandle = asyncHandle;
        if (requestAbortHandle != null) {
            resultHandle = this.createSetOnceAsyncHandleWrapper(asyncHandle);
        }
        JsonInvokeRequestParams2 jsonInvokeParams = new JsonInvokeRequestParams2(serviceId, operationId, ctx, input);
        JsonApiRequest jsonApiRequest = new JsonApiRequest(UUID2, jsonInvokeParams);
        CorrelatingClient.ResponseCallback cb = this.decorateCallbackWithExceptionTranslation(new ResponseCallbackImpl<MethodResult>(resultHandle, requestAbortHandle){

            @Override
            protected MethodResult decodeResponse(JsonApiResponse jsonResponse) {
                JsonApiProvider.this.checkResponseId(jsonResponse, UUID2);
                return jsonResponse.getResult();
            }
        });
        try {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("security_context", jsonInvokeParams.getCtx().retrieveSecurityContext());
            this.sendRequest(jsonApiRequest, metadata, ctx, requestAbortHandle, cb, serviceId, operationId);
        }
        catch (RuntimeException e) {
            resultHandle.setError(JsonMessageProtocolExceptionTranslator.translate(e));
        }
    }

    private AsyncHandle<MethodResult> createSetOnceAsyncHandleWrapper(final AsyncHandle<MethodResult> asyncHandle) {
        return new AsyncHandle<MethodResult>(){
            private AtomicBoolean isCompleted = new AtomicBoolean(false);

            @Override
            public void updateProgress(DataValue progress) {
                asyncHandle.updateProgress(progress);
            }

            @Override
            public void setResult(MethodResult result) {
                if (this.isCompleted.compareAndSet(false, true)) {
                    asyncHandle.setResult(result);
                }
            }

            @Override
            public synchronized void setError(RuntimeException error) {
                if (this.isCompleted.compareAndSet(false, true)) {
                    asyncHandle.setError(error);
                }
            }
        };
    }

    private abstract class ResponseCallbackImpl<T>
    implements CorrelatingClient.ResponseCallback {
        private final AsyncHandle<T> asyncHandle;
        private final AbortHandle abortHandle;

        ResponseCallbackImpl(AsyncHandle<T> asyncHandle, AbortHandle abortHandle) {
            this.asyncHandle = asyncHandle;
            this.abortHandle = abortHandle;
        }

        @Override
        public void failed(RuntimeException error) {
            this.asyncHandle.setError(JsonMessageProtocolExceptionTranslator.translate(error));
        }

        @Override
        public void received(InputStream response) {
            if (logger.isDebugEnabled() && Constants.shouldLogRawRequestResponse()) {
                try {
                    byte[] responseBytes = IoUtil.readAll(response);
                    String responseText = new String(responseBytes, JsonApiProvider.UTF8_CHARSET);
                    logger.debug("JSON response: {}", (Object)responseText);
                    response = new ByteArrayInputStream(responseBytes);
                }
                catch (IOException ex) {
                    logger.debug("Could not log JSON response", (Throwable)ex);
                }
            }
            if (Util.checkRequestAborted(this.abortHandle, this)) {
                return;
            }
            Object result = null;
            DataValue progress = null;
            JsonBaseResponse jsonObj = this.deseralizeResponse(response);
            if (jsonObj instanceof JsonProgressResponse) {
                progress = ((JsonProgressResponse)jsonObj).retrieveProgress();
            } else if (jsonObj instanceof JsonApiResponse) {
                result = this.decodeResponse((JsonApiResponse)jsonObj);
            } else {
                throw new RuntimeException("Unknown JsonBaseResponse sub-type");
            }
            if (Util.checkRequestAborted(this.abortHandle, this)) {
                return;
            }
            if (progress != null) {
                this.asyncHandle.updateProgress(progress);
            } else {
                this.asyncHandle.setResult(result);
            }
        }

        private JsonBaseResponse deseralizeResponse(InputStream response) {
            return JsonApiProvider.this.jsonDeserializer2.responseDeserialize(response, JsonConstants.RequestType.invoke);
        }

        protected abstract T decodeResponse(JsonApiResponse var1);
    }
}

