/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.http;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.client.exception.ConnectionException;
import com.vmware.vapi.client.exception.SslException;
import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vapi.internal.common.exception.ExceptionTranslatorBase;
import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.core.abort.RequestAbortedException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import javax.net.ssl.SSLException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.ParseException;

public class ApacheHttpClientExceptionTranslator
extends ExceptionTranslatorBase {
    public static RuntimeException translate(Exception e, AbortHandle abortHandle) {
        return ApacheHttpClientExceptionTranslator.translate(e, abortHandle, null);
    }

    public static RuntimeException translate(Exception e, AbortHandle abortHandle, String uri) {
        if (abortHandle != null && abortHandle.isAborted()) {
            return new RequestAbortedException(e.getMessage(), e);
        }
        String message = ApacheHttpClientExceptionTranslator.getUriExceptionMessage(e, uri);
        if (e instanceof SSLException) {
            return ApacheHttpClientExceptionTranslator.fixStackTrace(new SslException(message, e));
        }
        if (e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof ConnectionClosedException || e instanceof InterruptedIOException || e instanceof UnknownHostException) {
            return ApacheHttpClientExceptionTranslator.fixStackTrace(new ConnectionException(message, e));
        }
        if (e instanceof MalformedChunkCodingException || e instanceof HttpException || e instanceof ParseException || e instanceof CancellationException || e instanceof CoreException || e instanceof IOException) {
            return ApacheHttpClientExceptionTranslator.fixStackTrace(new TransportProtocolException(message, e));
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e.getMessage(), e);
    }

    public static String getUriExceptionMessage(Exception e, String uri) {
        return uri == null ? e.getMessage() : String.format("%s invocation failed with \"%s\"", uri, e);
    }
}

