/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.protocol.common.DirectSerializer;
import com.vmware.vapi.internal.protocol.common.SerializerConfig;
import com.vmware.vapi.internal.util.Validate;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDirectSerializer
implements DirectSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDirectSerializer.class);
    private JsonFactory factory;

    public JsonDirectSerializer(JsonFactory factory) {
        Validate.notNull(factory);
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(DataValue value, OutputStream outputStream, SerializerConfig serializerConfig) throws IOException {
        JsonGenerator generator = null;
        try {
            generator = this.factory.createGenerator(outputStream);
            if (serializerConfig.isPrettyPrint()) {
                generator.useDefaultPrettyPrinter();
            }
            this.writeValue(generator, value, null);
            generator.flush();
        }
        finally {
            if (serializerConfig.isCloseRequired() && generator != null) {
                generator.close();
            }
        }
    }

    private void writeValue(JsonGenerator generator, DataValue dataValue, StructValue parentStructValue) throws JsonGenerationException, IOException {
        switch (dataValue.getType()) {
            case STRING: {
                generator.writeString(((StringValue)dataValue).getValue());
                break;
            }
            case INTEGER: {
                generator.writeNumber(((IntegerValue)dataValue).getValue());
                break;
            }
            case DOUBLE: {
                this.writeDoubleValue((DoubleValue)dataValue, generator);
                break;
            }
            case BOOLEAN: {
                generator.writeBoolean(((BooleanValue)dataValue).getValue());
                break;
            }
            case BLOB: {
                generator.writeString(Base64.encodeBase64String((byte[])((BlobValue)dataValue).getValue()));
                break;
            }
            case VOID: {
                break;
            }
            case SECRET: {
                generator.writeString(new String(((SecretValue)dataValue).getValue()));
                break;
            }
            case OPTIONAL: {
                DataValue nestedValue = ((OptionalValue)dataValue).getValue();
                if (nestedValue != null) {
                    this.writeValue(generator, nestedValue, parentStructValue);
                    break;
                }
                generator.writeNull();
                break;
            }
            case LIST: {
                ListValue listValue = (ListValue)dataValue;
                generator.writeStartArray();
                for (DataValue nestedData : listValue) {
                    this.writeValue(generator, nestedData, parentStructValue);
                }
                generator.writeEndArray();
                break;
            }
            case STRUCTURE: 
            case ERROR: {
                StructValue structValue = (StructValue)dataValue;
                generator.writeStartObject();
                for (Map.Entry<String, DataValue> entry : structValue.getFields().entrySet()) {
                    generator.writeFieldName(entry.getKey());
                    this.writeValue(generator, entry.getValue(), structValue);
                }
                generator.writeEndObject();
                break;
            }
            default: {
                LOGGER.error("Unrecognized DataType {0}", (Object)dataValue.getType());
                throw new RuntimeException(MessageFormat.format("Unrecognized DataType {0}", new Object[]{dataValue.getType()}));
            }
        }
    }

    private void writeDoubleValue(DoubleValue doubleVal, JsonGenerator generator) throws IOException {
        double d = doubleVal.getValue();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new RuntimeException("JSON doesn't support the double value: " + d);
        }
        generator.writeNumber(d);
    }
}

