/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol;

import com.vmware.vapi.internal.util.Validate;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.util.Objects;

public final class HttpConfiguration {
    private final LibType libraryType;
    private final SslConfiguration sslConfig;
    private final int ioThreadCount;
    private final int connectTimeout;
    private final int soTimeout;
    private final int maxConnections;
    private final long keepAlivePeriod;
    private final HeadersProvider headersProvider;
    private final Protocol protocol;

    private HttpConfiguration(LibType libraryType, SslConfiguration sslConfig, int ioThreadCount, int connectTimeout, int soTimeout, int maxConnections, long keepAlivePeriod, HeadersProvider headersProvider, Protocol protocol) {
        this.libraryType = libraryType;
        this.sslConfig = sslConfig;
        this.ioThreadCount = ioThreadCount;
        this.connectTimeout = connectTimeout;
        this.soTimeout = soTimeout;
        this.maxConnections = maxConnections;
        this.keepAlivePeriod = keepAlivePeriod;
        this.headersProvider = headersProvider;
        this.protocol = protocol;
    }

    public LibType getLibraryType() {
        return this.libraryType;
    }

    public SslConfiguration getSslConfiguration() {
        return this.sslConfig;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getKeepAlivePeriod() {
        return this.keepAlivePeriod;
    }

    public HeadersProvider getHeadersProvider() {
        return this.headersProvider;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public static class BasicHeader
    implements Header {
        private final String name;
        private final String value;

        public BasicHeader(String name, String value) {
            Objects.requireNonNull(name, "name cannot be null");
            if ("".equals(name)) {
                throw new IllegalArgumentException("name cannot be empty");
            }
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("{0}/{1}", this.name, this.value);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasicHeader other = (BasicHeader)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static interface Header {
        public String getName();

        public String getValue();
    }

    public static interface HeadersProvider {
        public Iterable<Header> getHeaders();
    }

    public static final class Builder {
        private static final int DEFAULT_MAX_CONNECTIONS = 20;
        private static final long DEFAULT_KEEP_ALIVE_PERIOD = 45000L;
        private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
        private static final int DEFAULT_SOCKET_TIMEOUT = 0;
        private LibType libraryType = LibType.APACHE_HTTP_CLIENT;
        private Protocol protocol = Protocol.VAPI_JSON_RPC_1_0;
        private SslConfiguration sslConfig;
        private Integer ioThreadCount;
        private int connectTimeout = 15000;
        private int soTimeout = 0;
        private int maxConnections = 20;
        private long keepAlivePeriod = 45000L;
        private HeadersProvider headersProvider;

        public Builder setLibraryType(LibType libraryType) {
            Validate.notNull((Object)libraryType);
            this.libraryType = libraryType;
            return this;
        }

        public Builder setSslConfiguration(SslConfiguration sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public Builder setIoThreadCount(int ioThreadCount) {
            Validate.isTrue(ioThreadCount > 0);
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            Validate.isTrue(connectTimeout >= 0);
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSoTimeout(int soTimeout) {
            Validate.isTrue(soTimeout >= 0);
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            Validate.isTrue(maxConnections > 0);
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setKeepAlivePeriod(long keepAlivePeriod) {
            this.keepAlivePeriod = keepAlivePeriod;
            return this;
        }

        public Builder setHeadersProvider(HeadersProvider headersProvider) {
            this.headersProvider = headersProvider;
            return this;
        }

        public Builder setProtocol(Protocol protocol) {
            Validate.notNull((Object)protocol);
            this.protocol = protocol;
            return this;
        }

        public HttpConfiguration getConfig() {
            this.validate();
            int ioThreads = this.ioThreadCount == null ? Runtime.getRuntime().availableProcessors() : this.ioThreadCount.intValue();
            SslConfiguration nonNullSslConfig = this.sslConfig == null ? SslConfiguration.DEFAULT : this.sslConfig;
            return new HttpConfiguration(this.libraryType, nonNullSslConfig, ioThreads, this.connectTimeout, this.soTimeout, this.maxConnections, this.keepAlivePeriod, this.headersProvider, this.protocol);
        }

        private void validate() {
            if (this.ioThreadCount != null && this.libraryType != LibType.APACHE_HTTP_ASYNC_CLIENT) {
                throw new IllegalStateException("IO thread count setting is not supported for transport based on library " + (Object)((Object)this.libraryType));
            }
        }
    }

    public static final class KeyStoreConfig {
        private final String keyAlias;
        private final String keyStorePassword;

        public KeyStoreConfig(String keyAlias, String keyStorePassword) {
            Validate.notNull(keyAlias);
            Validate.notNull(keyStorePassword);
            this.keyAlias = keyAlias;
            this.keyStorePassword = keyStorePassword;
        }

        public String getKeyAlias() {
            return this.keyAlias;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }
    }

    public static final class SslConfiguration {
        private static final SslConfiguration DEFAULT;
        static final String[] DEFAULT_PROTOCOLS;
        private final KeyStore trustStore;
        private final KeyStore keyStore;
        private final KeyStoreConfig keyStoreConfig;
        private final CertStore crlCertStore;
        private final String[] enabledProtocols;
        private final String[] enabledCipherSuites;
        private final boolean hostnameVerificationDisabled;
        private final boolean certificateValidationDisabled;

        @Deprecated
        public SslConfiguration(KeyStore trustStore) {
            this(trustStore, null, null);
        }

        @Deprecated
        public SslConfiguration(KeyStore trustStore, KeyStore keyStore, KeyStoreConfig keyStoreConfig) {
            this(trustStore, keyStore, keyStoreConfig, null);
        }

        @Deprecated
        public SslConfiguration(KeyStore trustStore, KeyStore keyStore, KeyStoreConfig keyStoreConfig, CertStore crlCertStore) {
            this(trustStore, keyStore, keyStoreConfig, crlCertStore, DEFAULT_PROTOCOLS, null, false, false);
        }

        private SslConfiguration(KeyStore trustStore, KeyStore keyStore, KeyStoreConfig keyStoreConfig, CertStore crlCertStore, String[] enabledProtocols, String[] enabledCipherSuites, boolean hostnameVerificationDisabled, boolean certificateValidationDisabled) {
            this.trustStore = trustStore;
            this.keyStore = keyStore;
            this.keyStoreConfig = keyStoreConfig;
            this.crlCertStore = crlCertStore;
            this.enabledProtocols = enabledProtocols;
            this.enabledCipherSuites = enabledCipherSuites;
            this.hostnameVerificationDisabled = hostnameVerificationDisabled;
            this.certificateValidationDisabled = certificateValidationDisabled;
            this.validate();
        }

        private void validate() {
            if (this.keyStore != null ^ this.keyStoreConfig != null) {
                throw new IllegalStateException("Key-store and key-store-config should both be set to non-null values for the key-store to work.");
            }
            if (this.crlCertStore != null && this.trustStore == null) {
                throw new IllegalStateException("Custom CRL-cert-store cannot be configured along with the default trust-store.");
            }
            if (this.certificateValidationDisabled && this.trustStore != null) {
                throw new IllegalStateException("Certificate validation is disabled. Custom trust-store cannot be set.");
            }
        }

        public KeyStore getTrustStore() {
            return this.trustStore;
        }

        public KeyStore getKeyStore() {
            return this.keyStore;
        }

        public KeyStoreConfig getKeyStoreConfig() {
            return this.keyStoreConfig;
        }

        public CertStore getCrlCertStore() {
            return this.crlCertStore;
        }

        public String[] getEnabledProtocols() {
            return this.enabledProtocols;
        }

        public String[] getEnabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        public boolean isHostnameVerificationDisabled() {
            return this.hostnameVerificationDisabled;
        }

        public boolean isCertificateValidationDisabled() {
            return this.certificateValidationDisabled;
        }

        static {
            DEFAULT_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
            DEFAULT = new Builder().getConfig();
        }

        public static final class Builder {
            private KeyStore trustStore;
            private KeyStore keyStore;
            private KeyStoreConfig keyStoreConfig;
            private CertStore crlCertStore;
            private String[] enabledProtocols = DEFAULT_PROTOCOLS;
            private String[] enabledCipherSuites;
            private boolean hostnameVerificationDisabled;
            private boolean certificateValidationDisabled;

            public Builder() {
                this(null);
            }

            public Builder(KeyStore trustStore) {
                this.trustStore = trustStore;
            }

            public Builder setTrustStore(KeyStore trustStore) {
                this.trustStore = trustStore;
                return this;
            }

            public Builder setKeyStore(KeyStore keyStore) {
                this.keyStore = keyStore;
                return this;
            }

            public Builder setKeyStoreConfig(KeyStoreConfig keyStoreConfig) {
                this.keyStoreConfig = keyStoreConfig;
                return this;
            }

            public Builder setCrlCertStore(CertStore crlCertStore) {
                this.crlCertStore = crlCertStore;
                return this;
            }

            public Builder setEnabledProtocols(String[] enabledProtocols) {
                Validate.notEmpty(enabledProtocols);
                this.enabledProtocols = enabledProtocols;
                return this;
            }

            public Builder setEnabledCipherSuites(String[] enabledCipherSuites) {
                this.enabledCipherSuites = enabledCipherSuites;
                return this;
            }

            public Builder disableHostnameVerification() {
                this.hostnameVerificationDisabled = true;
                return this;
            }

            public Builder disableCertificateValidation() {
                this.certificateValidationDisabled = true;
                return this;
            }

            public SslConfiguration getConfig() {
                return new SslConfiguration(this.trustStore, this.keyStore, this.keyStoreConfig, this.crlCertStore, this.enabledProtocols, this.enabledCipherSuites, this.hostnameVerificationDisabled, this.certificateValidationDisabled);
            }
        }
    }

    public static enum Protocol {
        VAPI_JSON_RPC_1_0,
        VAPI_JSON_RPC_1_1;

    }

    public static enum LibType {
        APACHE_HTTP_CLIENT,
        APACHE_HTTP_ASYNC_CLIENT;

    }
}

