/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.provider;

import com.vmware.vapi.ErrorValueFactory;
import com.vmware.vapi.bindings.server.impl.InvocationContextImpl;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.provider.ApiTaskMethod;
import com.vmware.vapi.provider.ApiInterface;
import com.vmware.vapi.provider.ApiMethod;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ApiMethodBasedApiInterface
implements ApiInterface {
    private final Map<MethodIdentifier, ApiMethod> methods = new HashMap<MethodIdentifier, ApiMethod>();
    private final InterfaceIdentifier ifaceId;
    private final InterfaceDefinition definition;

    public ApiMethodBasedApiInterface(InterfaceIdentifier iface) {
        this.ifaceId = iface;
        this.definition = new InterfaceDefinition(this.ifaceId, Collections.unmodifiableSet(this.methods.keySet()));
    }

    public ApiMethodBasedApiInterface(String iface) {
        this(new InterfaceIdentifier(iface));
    }

    @Override
    public InterfaceIdentifier getIdentifier() {
        return this.ifaceId;
    }

    @Override
    public InterfaceDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public MethodDefinition getMethodDefinition(MethodIdentifier methodId) {
        ApiMethod method = this.getMethod(methodId);
        if (method != null) {
            return method.getDefinition();
        }
        return null;
    }

    @Override
    public void invoke(ExecutionContext ctx, MethodIdentifier methodId, DataValue input, AsyncHandle<MethodResult> asyncHandle) {
        ApiMethod method = this.getMethod(methodId);
        if (method != null) {
            InvocationContextImpl invocationContext = new InvocationContextImpl(ctx);
            method.invoke(invocationContext, input, asyncHandle);
        } else {
            String operationId = methodId.getName();
            String serviceId = methodId.getInterfaceIdentifier().getName();
            ErrorValue error = ErrorValueFactory.buildErrorValue("com.vmware.vapi.std.errors.operation_not_found", "vapi.method.input.invalid.method", operationId, serviceId);
            MethodResult result = MethodResult.newErrorResult(error);
            asyncHandle.setResult(result);
        }
    }

    private ApiMethod getMethod(MethodIdentifier methodId) {
        return this.methods.get(methodId);
    }

    protected void registerMethod(ApiMethod method) {
        MethodIdentifier methodId = method.getIdentifier();
        if (method.getDefinition().getTaskSupport() != MethodDefinition.TaskSupport.TASK_ONLY) {
            this.methods.put(methodId, method);
        }
        if (method.getDefinition().getTaskSupport() != MethodDefinition.TaskSupport.NONE) {
            ApiTaskMethod taskMethod = new ApiTaskMethod(method);
            this.methods.put(taskMethod.getIdentifier(), taskMethod);
        }
    }
}

