/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.provider.local;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.core.ProviderDefinition;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StringDefinition;
import com.vmware.vapi.diagnostics.LogDiagnosticUtil;
import com.vmware.vapi.diagnostics.LogDiagnosticsConfigurator;
import com.vmware.vapi.diagnostics.Slf4jMDCLogConfigurator;
import com.vmware.vapi.internal.provider.introspection.OperationIntrospectionService;
import com.vmware.vapi.internal.provider.introspection.ProviderIntrospectionService;
import com.vmware.vapi.internal.provider.introspection.ServiceIntrospectionService;
import com.vmware.vapi.internal.util.TaskUtil;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.internal.util.async.StrictAsyncHandle;
import com.vmware.vapi.internal.util.time.Chronometer;
import com.vmware.vapi.provider.ApiInterface;
import com.vmware.vapi.provider.introspection.SyncApiIntrospection;
import com.vmware.vapi.std.StandardDataFactory;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProvider
implements ApiProvider,
SyncApiIntrospection {
    private static final String INVOKEMETHOD_MISSING_INPUT_DEF = "vapi.provider.local.invokemethod.missing.input.def";
    private static final StringDefinition TASK_OUTPUT_DEFINITION = StringDefinition.getInstance();
    public static final String LOCAL_PROVIDER_DEFAULT_NAME = "LocalProvider";
    private static final Logger logger = LoggerFactory.getLogger(LocalProvider.class);
    private final LogDiagnosticsConfigurator logDiag = new Slf4jMDCLogConfigurator();
    static final Set<ErrorDefinition> LOCAL_PROVIDER_ERROR_DEFS = Collections.unmodifiableSet(new HashSet<ErrorDefinition>(Arrays.asList(StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.internal_server_error"), StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.invalid_argument"), StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.operation_not_found"))));
    private final ConcurrentMap<String, ApiInterface> services = new ConcurrentHashMap<String, ApiInterface>();
    private final String name;

    public LocalProvider(String name) {
        this(name, Collections.emptyList());
    }

    public LocalProvider(String name, List<ApiInterface> ifaces) {
        this(name, ifaces, true);
    }

    public LocalProvider(String name, List<ApiInterface> ifaces, boolean deployIntrospectionServices) {
        this.name = name != null && !name.trim().isEmpty() ? name.trim() : LOCAL_PROVIDER_DEFAULT_NAME;
        if (deployIntrospectionServices) {
            this.addInterface(new ProviderIntrospectionService(this));
            this.addInterface(new ServiceIntrospectionService(this));
            this.addInterface(new OperationIntrospectionService(this));
        }
        if (ifaces != null) {
            for (ApiInterface i : ifaces) {
                this.addInterface(i);
            }
        }
    }

    public void addInterface(ApiInterface iface) {
        Validate.notNull(iface);
        String serviceId = iface.getIdentifier().getName();
        ApiInterface duplicate = this.services.putIfAbsent(serviceId, iface);
        if (duplicate != null) {
            throw new IllegalArgumentException("Duplicate service name: " + serviceId);
        }
        logger.info("Registered the service {}", (Object)serviceId);
    }

    public void addInterfaces(List<ApiInterface> ifaces) {
        Validate.notNull(ifaces);
        for (ApiInterface i : ifaces) {
            this.addInterface(i);
        }
    }

    @Override
    public ProviderDefinition getDefinition(ExecutionContext ctx) {
        return new ProviderDefinition(this.name, this.computeCheckSum());
    }

    private String computeCheckSum() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (ApiInterface iface : this.services.values()) {
                md.update(iface.getIdentifier().getName().getBytes("UTF-8"));
                for (MethodIdentifier methodId : iface.getDefinition().getMethodIdentifiers()) {
                    MethodDefinition methodDef = iface.getMethodDefinition(methodId);
                    md.update(methodDef.toString().getBytes("UTF-8"));
                }
            }
            return Hex.encodeHexString((byte[])md.digest());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Unable to get UTF-8 bytes for data for checksum", (Throwable)ex);
            return "";
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("Unable to load algorithm to compute provider checksum", (Throwable)ex);
            return "";
        }
    }

    @Override
    public Set<InterfaceIdentifier> getInterfaceIdentifiers(ExecutionContext ctx) {
        LinkedHashSet<InterfaceIdentifier> ids = new LinkedHashSet<InterfaceIdentifier>();
        for (ApiInterface i : this.services.values()) {
            ids.add(i.getIdentifier());
        }
        return ids;
    }

    @Override
    public InterfaceDefinition getInterface(ExecutionContext ctx, InterfaceIdentifier iface) {
        if (iface == null) {
            return null;
        }
        ApiInterface service = (ApiInterface)this.services.get(iface.getName());
        if (service != null) {
            return service.getDefinition();
        }
        return null;
    }

    @Override
    public MethodDefinition getMethod(ExecutionContext ctx, MethodIdentifier methodId) {
        if (methodId == null) {
            return null;
        }
        ApiInterface iface = (ApiInterface)this.services.get(methodId.getInterfaceIdentifier().getName());
        if (iface == null) {
            return null;
        }
        MethodDefinition methodDef = iface.getMethodDefinition(methodId);
        if (methodDef == null) {
            return null;
        }
        HashSet<ErrorDefinition> augmentedErrors = new HashSet<ErrorDefinition>(methodDef.getErrorDefinitions());
        augmentedErrors.addAll(LOCAL_PROVIDER_ERROR_DEFS);
        return new MethodDefinition(methodDef.getIdentifier(), methodDef.getInputDefinition(), methodDef.getOutputDefinition(), augmentedErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        try {
            this.logDiag.configureContext(LogDiagnosticUtil.getDiagnosticContext(ctx));
            this.invokeMethodInt(serviceId, operationId, input, ctx, asyncHandle);
        }
        catch (InvocationError ex) {
            MethodResult errorResult = ex.getMethodResult();
            this.setError(asyncHandle, errorResult, serviceId, operationId, ex);
        }
        catch (Exception ex) {
            MethodResult errorResult = LocalProvider.invokeMethodError(serviceId, operationId, ex);
            this.setError(asyncHandle, errorResult, serviceId, operationId, ex);
        }
        finally {
            this.logDiag.cleanUpContext(LogDiagnosticUtil.getDiagnosticKeys());
        }
    }

    private void setError(AsyncHandle<MethodResult> asyncHandle, MethodResult errorResult, String serviceId, String operationId, Exception ex) {
        try {
            asyncHandle.setResult(errorResult);
        }
        catch (IllegalStateException e) {
            logger.error(String.format("Operation '{}' from Service '{}'  threw an exception after completing the invocation", operationId, serviceId), (Throwable)ex);
        }
    }

    private static MethodResult invokeMethodError(String serviceId, String operationId, Exception e) {
        if (e instanceof ConstraintValidationException) {
            ConstraintValidationException cve = (ConstraintValidationException)e;
            logger.error("Validation error", (Throwable)cve);
            return LocalProvider.createErrorResult("com.vmware.vapi.std.errors.invalid_argument", cve.getExceptionMessages());
        }
        if (e instanceof CoreException) {
            CoreException ex = (CoreException)e;
            logger.error("invokeMethod error:", (Throwable)ex);
            return LocalProvider.createErrorResult("com.vmware.vapi.std.errors.internal_server_error", ex.getExceptionMessages());
        }
        logger.warn("invokeMethod error:", (Throwable)e);
        Message message = MessageFactory.getMessage("vapi.provider.local.invoke.exception", operationId, serviceId);
        return LocalProvider.createErrorResult("com.vmware.vapi.std.errors.internal_server_error", Arrays.asList(message));
    }

    private void invokeMethodInt(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        Objects.requireNonNull(asyncHandle, "AsyncHandle must not be null");
        Chronometer invokeMethodTimer = new Chronometer();
        invokeMethodTimer.start();
        try {
            this.validateInvokeInputs(serviceId, operationId, input, ctx);
            ApiInterface iface = (ApiInterface)this.services.get(serviceId);
            if (iface == null) {
                throw new InvocationError("com.vmware.vapi.std.errors.operation_not_found", "vapi.method.input.invalid.interface", serviceId);
            }
            MethodIdentifier methodId = new MethodIdentifier(iface.getIdentifier(), operationId);
            MethodDefinition methodDef = iface.getMethodDefinition(methodId);
            if (methodDef == null) {
                throw new InvocationError("com.vmware.vapi.std.errors.operation_not_found", "vapi.method.input.invalid.method", operationId, serviceId);
            }
            this.validateMethodInput(methodDef, input);
            logger.debug("call to invoke() for service '{}', operation '{}'", (Object)serviceId, (Object)operationId);
            boolean taskInvocation = TaskUtil.isTaskInvocation(operationId);
            AsyncHandleAdapter cb = new AsyncHandleAdapter(methodDef, taskInvocation, asyncHandle, invokeMethodTimer);
            iface.invoke(ctx, methodId, input, new StrictAsyncHandle<MethodResult>(cb));
        }
        catch (InvocationError e) {
            invokeMethodTimer.stop();
            throw e;
        }
    }

    private void validateInvokeInputs(String serviceId, String operationId, DataValue input, ExecutionContext ctx) {
        if (ctx == null) {
            throw new InvocationError("com.vmware.vapi.std.errors.internal_server_error", "vapi.provider.local.invoke.missing.execution.context", new String[0]);
        }
        if (serviceId == null) {
            throw new InvocationError("com.vmware.vapi.std.errors.internal_server_error", "vapi.provider.local.invoke.missing.serviceId", new String[0]);
        }
        if (operationId == null) {
            throw new InvocationError("com.vmware.vapi.std.errors.internal_server_error", "vapi.provider.local.invoke.missing.operationId", new String[0]);
        }
        if (input == null) {
            throw new InvocationError("com.vmware.vapi.std.errors.internal_server_error", "vapi.provider.local.invoke.missing.input.value", serviceId, operationId);
        }
    }

    private void validateMethodInput(MethodDefinition method, DataValue input) {
        DataDefinition inputType = method.getInputDefinition();
        MethodIdentifier methodId = method.getIdentifier();
        if (inputType == null) {
            throw new CoreException(INVOKEMETHOD_MISSING_INPUT_DEF, methodId.toString());
        }
        inputType.completeValue(input);
        List<Message> inputErrors = inputType.validate(input);
        if (!inputErrors.isEmpty()) {
            logger.error("Validation failed for input value of method {}: {}", (Object)methodId, inputErrors);
            logger.error("Will not invoke method {} because the input is invalid", (Object)methodId);
            String[] msgArgs = new String[]{methodId.toString()};
            throw new InvocationError("com.vmware.vapi.std.errors.invalid_argument", inputErrors, "vapi.invoke.input.invalid", msgArgs);
        }
    }

    private ErrorValue validateMethodResult(MethodDefinition method, MethodResult result, DataDefinition outputType) {
        String methodName = method.getIdentifier().getFullyQualifiedName();
        if (result == null) {
            throw new CoreException("vapi.provider.local.invokemethod.missing.result", methodName);
        }
        if (result.success()) {
            return this.validateMethodOutput(methodName, result.getOutput(), outputType);
        }
        return this.validateMethodError(method, result);
    }

    private DataDefinition getOutputType(MethodDefinition method, boolean isTaskInvocation) {
        DataDefinition outputType = isTaskInvocation && this.isTaskEnabledOperation(method) ? TASK_OUTPUT_DEFINITION : method.getOutputDefinition();
        return outputType;
    }

    private boolean isTaskEnabledOperation(MethodDefinition method) {
        return MethodDefinition.TaskSupport.NONE != method.getTaskSupport();
    }

    private ErrorValue validateMethodOutput(String methodName, DataValue output, DataDefinition outputType) {
        if (outputType == null) {
            throw new CoreException("vapi.provider.local.invokemethod.missing.output.def", methodName);
        }
        List<Message> outputErrors = outputType.validate(output);
        if (!outputErrors.isEmpty()) {
            logger.error("Method {} returned invalid output: {}", (Object)methodName, outputErrors);
            return LocalProvider.createErrorForMsgs("com.vmware.vapi.std.errors.internal_server_error", outputErrors, "vapi.provider.local.invokemethod.output.invalid", methodName);
        }
        return null;
    }

    private ErrorValue validateMethodError(MethodDefinition method, MethodResult result) {
        ErrorValue error = result.getError();
        ErrorDefinition errorDef = method.getErrorDefinition(error.getName());
        if (errorDef == null) {
            logger.error("Undeclared error %s reported from method {}", (Object)error.getName(), (Object)method.getIdentifier());
            return LocalProvider.createErrorForMsgs("com.vmware.vapi.std.errors.internal_server_error", StandardDataFactory.getMessagesFromErrorValue(error), "vapi.provider.local.invokemethod.errors.undeclared", error.getName(), method.getIdentifier().toString());
        }
        List<Message> validationMsgs = errorDef.validate(error);
        if (validationMsgs.size() > 0) {
            logger.error("Invalid error {} reported from method {}: {}", new Object[]{error, method.getIdentifier(), validationMsgs});
            List<Message> msgs = StandardDataFactory.getMessagesFromErrorValue(error);
            return LocalProvider.createErrorForMsgs("com.vmware.vapi.std.errors.internal_server_error", LocalProvider.joinMsgs(validationMsgs, msgs), "vapi.provider.local.invokemethod.errors.invalid", error.getName(), method.getIdentifier().toString());
        }
        return null;
    }

    private static List<Message> joinMsgs(List<Message> first, List<Message> second) {
        LinkedList<Message> msgs = new LinkedList<Message>(first);
        msgs.addAll(second);
        return msgs;
    }

    private static ErrorValue createErrorForMsgs(String errorName, List<Message> previousMsgs, String msgId, String ... msgArgs) {
        List<Message> allMsgs = LocalProvider.appendMsg(previousMsgs, msgId, msgArgs);
        return StandardDataFactory.createErrorValueForMessages(errorName, allMsgs);
    }

    private static MethodResult createErrorResult(String errorName, List<Message> msgs) {
        return MethodResult.newErrorResult(StandardDataFactory.createErrorValueForMessages(errorName, msgs));
    }

    private static ErrorValue createErrorForMsgs(String errorName, String msgId, String ... msgArgs) {
        Message msg = MessageFactory.getMessage(msgId, msgArgs);
        List<Message> allMsgs = Collections.singletonList(msg);
        return StandardDataFactory.createErrorValueForMessages(errorName, allMsgs);
    }

    private static List<Message> appendMsg(List<Message> previousMsgs, String msgId, String ... msgArgs) {
        Message message = MessageFactory.getMessage(msgId, msgArgs);
        LinkedList<Message> allMsgs = new LinkedList<Message>();
        allMsgs.add(message);
        allMsgs.addAll(previousMsgs);
        return allMsgs;
    }

    private static class InvocationError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private ErrorValue errorValue;

        public InvocationError(String errorName, List<Message> previousMsgs, String msgId, String ... msgArgs) {
            this(LocalProvider.createErrorForMsgs(errorName, previousMsgs, msgId, msgArgs));
        }

        public InvocationError(String errorName, String msgId, String ... msgArgs) {
            this(LocalProvider.createErrorForMsgs(errorName, msgId, msgArgs));
        }

        public InvocationError(ErrorValue errorValue) {
            this.errorValue = Objects.requireNonNull(errorValue);
        }

        public MethodResult getMethodResult() {
            return MethodResult.newErrorResult(this.errorValue);
        }
    }

    private class AsyncHandleAdapter
    extends AsyncHandle<MethodResult> {
        protected final MethodDefinition methodDef;
        protected final AsyncHandle<MethodResult> asyncHandle;
        protected final Chronometer invokeMethodTimer;
        protected final MethodIdentifier methodId;
        protected final String serviceId;
        protected final String operationId;
        protected final DataDefinition outputType;

        public AsyncHandleAdapter(MethodDefinition methodDef, boolean isTaskInvocation, AsyncHandle<MethodResult> asyncHandle, Chronometer invokeMethodTimer) {
            this.methodDef = methodDef;
            this.asyncHandle = asyncHandle;
            this.outputType = LocalProvider.this.getOutputType(methodDef, isTaskInvocation);
            this.invokeMethodTimer = invokeMethodTimer;
            this.methodId = methodDef.getIdentifier();
            this.serviceId = this.methodId.getInterfaceIdentifier().getName();
            this.operationId = this.methodId.getName();
        }

        @Override
        public void updateProgress(DataValue progress) {
            this.asyncHandle.updateProgress(progress);
        }

        @Override
        public void setResult(MethodResult result) {
            ErrorValue valError;
            try {
                valError = LocalProvider.this.validateMethodResult(this.methodDef, result, this.outputType);
            }
            catch (RuntimeException ex) {
                this.asyncHandle.setResult(LocalProvider.invokeMethodError(this.serviceId, this.operationId, ex));
                this.invokeMethodTimer.stop();
                return;
            }
            if (valError != null) {
                this.asyncHandle.setResult(MethodResult.newErrorResult(valError));
            } else {
                this.asyncHandle.setResult(result);
            }
            this.invokeMethodTimer.stop();
        }

        @Override
        public void setError(RuntimeException error) {
            this.asyncHandle.setResult(LocalProvider.invokeMethodError(this.serviceId, this.operationId, error));
        }
    }
}

