/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io.data;

import com.vmware.srm.client.impex.tool.io.data.ArrayManagerCredentials;
import com.vmware.srm.client.impex.tool.io.data.Credentials;
import com.vmware.srm.client.impex.tool.io.data.KeyStoreData;
import com.vmware.srm.client.impex.tool.io.data.Lspp;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UserInputProperties {
    private static final String ADDRESS = "lookup.service.address";
    private static final String PORT = "port";
    private static final String LOCAL_SRM_NAME = "local.srm.name";
    private static final String LOCAL_USE_KS = "local.auth.use.keystore";
    private static final String LOCAL_AUTH_USERNAME = "local.auth.credentials.vc.username";
    private static final String LOCAL_AUTH_PASSWORD = "local.auth.credentials.vc.password";
    private static final String LOCAL_AUTH_KS_TYPE = "local.auth.keystore.type";
    private static final String LOCAL_AUTH_KS_PATH = "local.auth.keystore.path";
    private static final String LOCAL_AUTH_KS_PASS = "local.auth.keystore.pass";
    private static final String LOCAL_AUTH_KS_CERT_ALIAS = "local.auth.keystore.certAlias";
    private static final String LOCAL_AUTH_KS_KEY_ALIAS = "local.auth.keystore.keyAlias";
    private static final String LOCAL_AUTH_KS_KEY_PASS = "local.auth.keystore.keyPass";
    private static final String REMOTE_USE_KS = "remote.auth.use.keystore";
    private static final String REMOTE_AUTH_USERNAME = "remote.auth.credentials.vc.username";
    private static final String REMOTE_AUTH_PASSWORD = "remote.auth.credentials.vc.password";
    private static final String REMOTE_AUTH_KS_TYPE = "remote.auth.keystore.type";
    private static final String REMOTE_AUTH_KS_PATH = "remote.auth.keystore.path";
    private static final String REMOTE_AUTH_KS_PASS = "remote.auth.keystore.pass";
    private static final String REMOTE_AUTH_KS_CERT_ALIAS = "remote.auth.keystore.certAlias";
    private static final String REMOTE_AUTH_KS_KEY_ALIAS = "remote.auth.keystore.keyAlias";
    private static final String REMOTE_AUTH_KS_KEY_PASS = "remote.auth.keystore.keyPass";
    private static final String CONTINUE_AFTER_AM_ERROR = "continue.after.array.manager.errors";
    private static final String AM_NTH = "array.manager.%s.";
    private final Lspp _lspp;
    private final String _localSrmName;
    private final boolean _localUseKeyStore;
    private final Credentials _localCredentials;
    private final KeyStoreData _localKeyStoreData;
    private final boolean _remoteUseKeyStore;
    private final Credentials _remoteCredentials;
    private final KeyStoreData _remoteKeyStoreData;
    private final boolean _continueAfterAmError;
    private final Set<ArrayManagerCredentials> _arrayManagerCredentials;

    public UserInputProperties(Properties properties) throws InvalidPropertyException {
        String host = properties.getProperty(ADDRESS);
        String port = properties.getProperty(PORT);
        if (Objects.isNull(port)) {
            port = String.valueOf(443);
        }
        if (!StringUtils.isNumeric(port)) {
            throw new NonNumericPropertyException(PORT);
        }
        this._lspp = new Lspp(host, Integer.parseInt(port));
        String localSrmName = properties.getProperty(LOCAL_SRM_NAME);
        UserInputProperties.validateNotEmpty(localSrmName, LOCAL_SRM_NAME);
        this._localSrmName = localSrmName;
        String localUseKeyStore = properties.getProperty(LOCAL_USE_KS);
        this._localUseKeyStore = Boolean.parseBoolean(localUseKeyStore);
        if (this._localUseKeyStore) {
            String ksType = properties.getProperty(LOCAL_AUTH_KS_TYPE);
            if (StringUtils.isEmpty(ksType)) {
                ksType = "JCEKS";
            }
            String ksPath = properties.getProperty(LOCAL_AUTH_KS_PATH);
            UserInputProperties.validateNotEmpty(ksPath, LOCAL_AUTH_KS_PATH);
            String ksPass = properties.getProperty(LOCAL_AUTH_KS_PASS);
            UserInputProperties.validateNotNull(ksPass, LOCAL_AUTH_KS_PASS);
            String ksCertAlias = properties.getProperty(LOCAL_AUTH_KS_CERT_ALIAS);
            UserInputProperties.validateNotEmpty(ksCertAlias, LOCAL_AUTH_KS_CERT_ALIAS);
            String ksKeyAlias = properties.getProperty(LOCAL_AUTH_KS_KEY_ALIAS);
            UserInputProperties.validateNotEmpty(ksKeyAlias, LOCAL_AUTH_KS_KEY_ALIAS);
            String ksKeyPass = properties.getProperty(LOCAL_AUTH_KS_KEY_PASS);
            UserInputProperties.validateNotNull(ksKeyPass, LOCAL_AUTH_KS_KEY_PASS);
            this._localKeyStoreData = new KeyStoreData(ksType, ksPath, ksPass, ksCertAlias, ksKeyAlias, ksKeyPass);
            this._localCredentials = null;
        } else {
            String localVcUsername = properties.getProperty(LOCAL_AUTH_USERNAME);
            UserInputProperties.validateNotEmpty(localVcUsername, LOCAL_AUTH_USERNAME);
            String localVcPassword = properties.getProperty(LOCAL_AUTH_PASSWORD);
            UserInputProperties.validateNotNull(localVcPassword, LOCAL_AUTH_PASSWORD);
            this._localCredentials = new Credentials(localVcUsername, localVcPassword);
            this._localKeyStoreData = null;
        }
        String remoteUseKeyStore = properties.getProperty(REMOTE_USE_KS);
        this._remoteUseKeyStore = Boolean.parseBoolean(remoteUseKeyStore);
        if (this._remoteUseKeyStore) {
            String ksType = properties.getProperty(REMOTE_AUTH_KS_TYPE);
            if (StringUtils.isEmpty(ksType)) {
                ksType = "JCEKS";
            }
            String ksPath = properties.getProperty(REMOTE_AUTH_KS_PATH);
            UserInputProperties.validateNotEmpty(ksPath, REMOTE_AUTH_KS_PATH);
            String ksPass = properties.getProperty(REMOTE_AUTH_KS_PASS);
            UserInputProperties.validateNotNull(ksPass, REMOTE_AUTH_KS_PASS);
            String ksCertAlias = properties.getProperty(REMOTE_AUTH_KS_CERT_ALIAS);
            UserInputProperties.validateNotEmpty(ksCertAlias, REMOTE_AUTH_KS_CERT_ALIAS);
            String ksKeyAlias = properties.getProperty(REMOTE_AUTH_KS_KEY_ALIAS);
            UserInputProperties.validateNotEmpty(ksKeyAlias, REMOTE_AUTH_KS_KEY_ALIAS);
            String ksKeyPass = properties.getProperty(REMOTE_AUTH_KS_KEY_PASS);
            UserInputProperties.validateNotNull(ksKeyPass, REMOTE_AUTH_KS_KEY_PASS);
            this._remoteKeyStoreData = new KeyStoreData(ksType, ksPath, ksPass, ksCertAlias, ksKeyAlias, ksKeyPass);
            this._remoteCredentials = null;
        } else {
            String remoteVcUsername = properties.getProperty(REMOTE_AUTH_USERNAME);
            String remoteVcPassword = properties.getProperty(REMOTE_AUTH_PASSWORD);
            if (Objects.nonNull(remoteVcUsername)) {
                UserInputProperties.validateNotNull(remoteVcPassword, REMOTE_AUTH_KS_PASS);
            }
            this._remoteCredentials = Objects.isNull(remoteVcUsername) ? new Credentials("", "") : new Credentials(remoteVcUsername, remoteVcPassword);
            this._remoteKeyStoreData = null;
        }
        String continueAfterAmError = properties.getProperty(CONTINUE_AFTER_AM_ERROR);
        this._continueAfterAmError = Boolean.parseBoolean(continueAfterAmError);
        this._arrayManagerCredentials = new HashSet<ArrayManagerCredentials>();
        int i = 1;
        String currentAm = String.format(AM_NTH, i);
        String amName = properties.getProperty(currentAm + "name");
        while (Objects.nonNull(amName)) {
            UserInputProperties.validateNotEmpty(amName, "Array manager name for: " + currentAm);
            String amSkipVal = properties.getProperty(currentAm + "skip");
            UserInputProperties.validateNotEmpty(amSkipVal, "Array manager skip for: " + currentAm);
            boolean amSkip = Boolean.parseBoolean(amSkipVal);
            String amUsername = null;
            String amPassword = null;
            if (!amSkip) {
                amUsername = properties.getProperty(currentAm + "username");
                UserInputProperties.validateNotEmpty(amUsername, "Array manager username for: " + currentAm);
                amPassword = properties.getProperty(currentAm + "password");
                UserInputProperties.validateNotNull(amPassword, "Array manager password for: " + currentAm);
            }
            this._arrayManagerCredentials.add(new ArrayManagerCredentials(amName, amSkip, new Credentials(amUsername, amPassword)));
            currentAm = String.format(AM_NTH, ++i);
            amName = properties.getProperty(currentAm + "name");
        }
    }

    public Lspp getLspp() {
        return this._lspp;
    }

    public String getLocalSrmName() {
        return this._localSrmName;
    }

    public boolean isLocalUseKeyStore() {
        return this._localUseKeyStore;
    }

    public Credentials getLocalCredentials() {
        return this._localCredentials;
    }

    public KeyStoreData getLocalKeyStoreData() {
        return this._localKeyStoreData;
    }

    public boolean isRemoteUseKeyStore() {
        return this._remoteUseKeyStore;
    }

    public Credentials getRemoteCredentials() {
        return this._remoteCredentials;
    }

    public KeyStoreData getRemoteKeyStoreData() {
        return this._remoteKeyStoreData;
    }

    public boolean continueAfterAmError() {
        return this._continueAfterAmError;
    }

    public ArrayManagerCredentials getArrayManagerCredentials(String amName) {
        return this._arrayManagerCredentials.stream().filter(amCreds -> amName.equals(amCreds.getName())).findFirst().orElse(null);
    }

    private static void validateNotNull(String property, String key) {
        if (property == null) {
            throw new PropertyNotProvidedException(key);
        }
    }

    private static void validateNotEmpty(String property, String key) {
        UserInputProperties.validateNotNull(property, key);
        if (property.length() == 0) {
            throw new PropertyNotProvidedException(key);
        }
    }

    public String toString() {
        return "UserInputProperties {" + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_lspp = ", (Object)this._lspp)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_localSrmName = ", (Object)this._localSrmName)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_localUseKeyStore = ", (Object)this._localUseKeyStore)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_localCredentials = ", (Object)((Object)this._localCredentials))), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_localKeyStoreData = ", (Object)this._localKeyStoreData)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_remoteUseKeyStore = ", (Object)this._remoteUseKeyStore)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_remoteCredentials = ", (Object)((Object)this._remoteCredentials))), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_remoteKeyStoreData = ", (Object)this._remoteKeyStoreData)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_continueAfterAmError = ", (Object)this._continueAfterAmError)), (boolean)false) + "," + StringUtil.indent((String)("\n" + com.vmware.srm.client.utilities.StringUtils.toStringMemberObject((String)"_arrayManagerCredentials = ", this._arrayManagerCredentials)), (boolean)false) + "\n}";
    }

    private static final class NonNumericPropertyException
    extends InvalidPropertyException {
        private static final String MESSAGE = "Property '%s' is not a number.";

        NonNumericPropertyException(String key) {
            super(String.format(MESSAGE, key));
        }
    }

    private static final class PropertyNotProvidedException
    extends InvalidPropertyException {
        private static final String MESSAGE = "Property '%s' is required.";

        PropertyNotProvidedException(String key) {
            super(String.format(MESSAGE, key));
        }
    }

    public static class InvalidPropertyException
    extends RuntimeException {
        public InvalidPropertyException(String message) {
            super(message);
        }
    }
}

